# Encoding: UTF-8.
# Encoding: .

#==============================================================================*.

# TÍTULO DE LA SINTAXIS:							   
# Tabulados	del Registro Estadístico de Rewcursos y Actividades de Salud - RAS   				   
# OPERACIÓN ESTADÍSTICA:													   
# Recursos y Actividades de Salud - RAS				   
# UNIDAD TÉCNICA RESPONSABLE: 												   
# Dirección de Estadísticas Sociodemográficas (DIES)						   
# ENTIDAD EJECUTORA:														   
# Instituto Nacional de Estadística y Censos (INEC)	

#==============================================================================*.

# Fecha última modificación:   Diciembre - 2025.

#==============================================================================*.

# Elaborado por:													   
# Dirección de Estadísticas Sociodemográficas (DIES)						   
# Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA)  	   						   
# Aprobado por:													   
# Dirección de Estadísticas Sociodemográficas (DIES)				       
# Unidad de Gestión de Estadísticas Sociodemográficas en Base a Registros Administrativos (GESRA)								       

#==============================================================================*.


# SCRIPt PARA PREPARACIÓN DE LA BASE DE DATOS DEL RAS 2021 
# ACTUALIZADA CON EL CLASIFICADOR GEOGRÁFICO 2025 DPA

# **********************************************************************
# *******************SINTAXIS 1 BASE DE DATOS RAS***********************
# **********************************************************************

# Limpiamos la Consola

rm(list = ls())

# Instalamos los paquetes 

install.packages("dplyr")
install.packages("tidyr")
install.packages("scales")
install.packages("writexl")

library(writexl)
library(haven)
library(dplyr)
library(tidyr)
library(scales)
library(readxl)
library(purrr)
library(rlang)



# CREAMOS LA CAPETA RAS 2021

# COLOCAMOS LA BASE DE DATOS EN FORMATO .SAV CON EL SIGUIENTE NOMBRE: RAS_2021.SAV

# Cargamos y visualizamos la base de datos


RAS_2021 <- read_sav("C:/.........../Desktop/RAS 2021/RAS 2021.sav")

View(RAS_2021)

# Cargamos la base de datos y la guardamos en el objeto df

df <- RAS_2021

# Definir las columnas que deben permanecer como carácter

cols_char <- c("secuencial", "prov_ubi", "cant_ubi", "parr_ubi",
               "clase", "entidad", "tipo")

# Identificar las columnas que deben convertirse a numérico, (todas las demás columnas de df que no estén en cols_char)

cols_num <- setdiff(names(df), cols_char)

# Aplicar las conversiones selectivas

convert_to_num_safe <- function(x) {
  if (is.numeric(x)) return(as.numeric(x))
  # si es character, intenta extraer números
  if (is.character(x)) {
    num <- suppressWarnings(as.numeric(x))
    return(num)
  }
  as.numeric(x)
}

df <- df %>%
  mutate(across(all_of(cols_num), convert_to_num_safe),
         across(all_of(cols_char), as.character))

# Etiquetar variables del data frame  marque todo el teto hasta el final y digite CTRL + ENTER

attr(df$k1, "label") <- "BLOQUE (1) TOTAL MÉDICOS 8 horas"  
attr(df$k3, "label") <- "BLOQUE (1) TOTAL MÉDICOS 6 horas"  
attr(df$k4, "label") <- "BLOQUE (1) TOTAL MÉDICOS 4 horas"  
attr(df$k5, "label") <- "BLOQUE (1) TOTAL MÉDICOS eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k6, "label") <- "BLOQUE (1) Médicos Generales Total"  
attr(df$k7, "label") <- "BLOQUE (1) Médicos Generales 8 horas"  
attr(df$k8, "label") <- "BLOQUE (1) Médicos Generales 6 horas"  
attr(df$k9, "label") <- "BLOQUE (1) Médicos Generales 4 horas"  
attr(df$k10, "label") <- "BLOQUE (1) Médicos Generales eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k11, "label") <- "BLOQUE (1) Cirujanos Generales Total"  
attr(df$k12, "label") <- "BLOQUE (1) Cirujanos Generales 8 horas"  
attr(df$k13, "label") <- "BLOQUE (1) Cirujanos Generales 6 horas"  
attr(df$k14, "label") <- "BLOQUE (1) Cirujanos Generales 4 horas"  
attr(df$k15, "label") <- "BLOQUE (1) Cirujanos Generales eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16, "label") <- "BLOQUE (1) Cirujanos Plásticos y Reconstructivos Total"  
attr(df$k17, "label") <- "BLOQUE (1) Cirujanos Plásticos y Reconstructivos 8 horas"  
attr(df$k18, "label") <- "BLOQUE (1) Cirujanos Plásticos y Reconstructivos 6 horas"  
attr(df$k19, "label") <- "BLOQUE (1) Cirujanos Plásticos y Reconstructivos 4 horas"  
attr(df$k20, "label") <- "BLOQUE (1) Cirujanos Plásticos y Reconstructivos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16a, "label") <- "BLOQUE (1) Cirujanos Cardiacos Total"  
attr(df$k17a, "label") <- "BLOQUE (1) Cirujanos Cardiacos 8 horas"  
attr(df$k18a, "label") <- "BLOQUE (1) Cirujanos Cardiacos 6 horas"  
attr(df$k19a, "label") <- "BLOQUE (1) Cirujanos Cardiacos 4 horas"  
attr(df$k20a, "label") <- "BLOQUE (1) Cirujanos Cardiacos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16b, "label") <- "BLOQUE (1) Cirujanos Cardiotorácicos Total"  
attr(df$k17b, "label") <- "BLOQUE (1) Cirujanos Cardiotorácicos 8 horas"  
attr(df$k18b, "label") <- "BLOQUE (1) Cirujanos Cardiotorácicos 6 horas"  
attr(df$k19b, "label") <- "BLOQUE (1) Cirujanos Cardiotorácicos 4 horas"  
attr(df$k20b, "label") <- "BLOQUE (1) Cirujanos Cardiotorácicos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16c, "label") <- "BLOQUE (1) Cirujanos Cardiovasculares Total"  
attr(df$k17c, "label") <- "BLOQUE (1) Cirujanos Cardiovasculares 8 horas"  
attr(df$k18c, "label") <- "BLOQUE (1) Cirujanos Cardiovasculares 6 horas"  
attr(df$k19c, "label") <- "BLOQUE (1) Cirujanos Cardiovasculares 4 horas"  
attr(df$k20c, "label") <- "BLOQUE (1) Cirujanos Cardiovasculares eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16d, "label") <- "BLOQUE (1) Cirujanos de cabeza y cuello Total"  
attr(df$k17d, "label") <- "BLOQUE (1) Cirujanos de cabeza y cuello 8 horas"  
attr(df$k18d, "label") <- "BLOQUE (1) Cirujanos de cabeza y cuello 6 horas"  
attr(df$k19d, "label") <- "BLOQUE (1) Cirujanos de cabeza y cuello 4 horas"  
attr(df$k20d, "label") <- "BLOQUE (1) Cirujanos de cabeza y cuello eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16e, "label") <- "BLOQUE (1) Cirujanos Pediátricos Total"  
attr(df$k17e, "label") <- "BLOQUE (1) Cirujanos Pediátricos 8 horas"  
attr(df$k18e, "label") <- "BLOQUE (1) Cirujanos Pediátricos 6 horas"  
attr(df$k19e, "label") <- "BLOQUE (1) Cirujanos Pediátricos 4 horas"  
attr(df$k20e, "label") <- "BLOQUE (1) Cirujanos Pediátricos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k16f, "label") <- "BLOQUE (1) Cirujanos Toráxicos Total"  
attr(df$k17f, "label") <- "BLOQUE (1) Cirujanos Toráxicos 8 horas"  
attr(df$k18f, "label") <- "BLOQUE (1) Cirujanos Toráxicos 6 horas"  
attr(df$k19f, "label") <- "BLOQUE (1) Cirujanos Toráxicos 4 horas"  
attr(df$k20f, "label") <- "BLOQUE (1) Cirujanos Toráxicos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k191d, "label") <- "BLOQUE (1) Cirujanos Vasculares y Endovasculares Total"  
attr(df$k192d, "label") <- "BLOQUE (1) Cirujanos Vasculares y Endovasculares 8 horas"  
attr(df$k193d, "label") <- "BLOQUE (1) Cirujanos Vasculares y Endovasculares 6 horas"  
attr(df$k194d, "label") <- "BLOQUE (1) Cirujanos Vasculares y Endovasculares 4 horas"  
attr(df$k195d, "label") <- "BLOQUE (1) Cirujanos Vasculares y Endovasculares eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k41, "label") <- "BLOQUE (1) Cirujanos Ortopédicos y Traumatólogos Total"  
attr(df$k42, "label") <- "BLOQUE (1) Cirujanos Ortopédicos y Traumatólogos 8 horas"  
attr(df$k43, "label") <- "BLOQUE (1) Cirujanos Ortopédicos y Traumatólogos 6 horas"  
attr(df$k44, "label") <- "BLOQUE (1) Cirujanos Ortopédicos y Traumatólogos 4 horas"  
attr(df$k45, "label") <- "BLOQUE (1) Cirujanos Ortopédicos y Traumatólogos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k21, "label") <- "BLOQUE (1) Medicina Interna (Internistas) Total"  
attr(df$k22, "label") <- "BLOQUE (1) Medicina Interna (Internistas) 8 horas"  
attr(df$k23, "label") <- "BLOQUE (1) Medicina Interna (Internistas) 6 horas"  
attr(df$k24, "label") <- "BLOQUE (1) Medicina Interna (Internistas) 4 horas"  
attr(df$k25, "label") <- "BLOQUE (1) Medicina Interna (Internistas) eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k26, "label") <- "BLOQUE (1) Anestesiólogos Total"  
attr(df$k27, "label") <- "BLOQUE (1) Anestesiólogos 8 horas"  
attr(df$k28, "label") <- "BLOQUE (1) Anestesiólogos 6 horas"  
attr(df$k29, "label") <- "BLOQUE (1) Anestesiólogos 4 horas"  
attr(df$k30, "label") <- "BLOQUE (1) Anestesiólogos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k31, "label") <- "BLOQUE (1) Cardiólogos Total"  
attr(df$k32, "label") <- "BLOQUE (1) Cardiólogos 8 horas"  
attr(df$k33, "label") <- "BLOQUE (1) Cardiólogos 6 horas"  
attr(df$k34, "label") <- "BLOQUE (1) Cardiólogos 4 horas"  
attr(df$k35, "label") <- "BLOQUE (1) Cardiólogos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k36, "label") <- "BLOQUE (1) Neurólogos Total"  
attr(df$k37, "label") <- "BLOQUE (1) Neurólogos 8 horas"  
attr(df$k38, "label") <- "BLOQUE (1) Neurólogos 6 horas"  
attr(df$k39, "label") <- "BLOQUE (1) Neurólogos 4 horas"  
attr(df$k40, "label") <- "BLOQUE (1) Neurólogos eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k46, "label") <- "BLOQUE (1) Psiquiatras Total"  
attr(df$k47, "label") <- "BLOQUE (1) Psiquiatras 8 horas"  
attr(df$k48, "label") <- "BLOQUE (1) Psiquiatras 6 horas"  
attr(df$k49, "label") <- "BLOQUE (1) Psiquiatras 4 horas"  
attr(df$k50, "label") <- "BLOQUE (1) Psiquiatras eventuales o de llamada y menos de 4 horas diarias"  
attr(df$k51, "label") <- "BLOQUE (1) Oftalmólogos Total"
attr(df$k52,"label") <- "BLOQUE (1) Oftalmólogos 8 horas"
attr(df$k53,"label") <- "BLOQUE (1) Oftalmólogos 6 horas"
attr(df$k54,"label") <- "BLOQUE (1) Oftalmólogos 4 horas"
attr(df$k55,"label") <- "BLOQUE (1) Oftalmólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k56,"label") <- "BLOQUE (1) Otorrinolaringólogos Total"
attr(df$k57,"label") <- "BLOQUE (1) Otorrinolaringólogos 8 horas"
attr(df$k58,"label") <- "BLOQUE (1) Otorrinolaringólogos 6 horas"
attr(df$k59,"label") <- "BLOQUE (1) Otorrinolaringólogos 4 horas"
attr(df$k60,"label") <- "BLOQUE (1) Otorrinolaringólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k61,"label") <- "BLOQUE (1) Hematólogos Total"
attr(df$k62,"label") <- "BLOQUE (1) Hematólogos 8 horas"
attr(df$k63,"label") <- "BLOQUE (1) Hematólogos 6 horas"
attr(df$k64,"label") <- "BLOQUE (1) Hematólogos 4 horas"
attr(df$k65,"label") <- "BLOQUE (1) Hematólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k66,"label") <- "BLOQUE (1) Intensivistas Total"
attr(df$k67,"label") <- "BLOQUE (1) Intensivistas 8 horas"
attr(df$k68,"label") <- "BLOQUE (1) Intensivistas 6 horas"
attr(df$k69,"label") <- "BLOQUE (1) Intensivistas 4 horas"
attr(df$k70,"label") <- "BLOQUE (1) Intensivistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k71,"label") <- "BLOQUE (1) Nefrólogos Total"
attr(df$k72,"label") <- "BLOQUE (1) Nefrólogos 8 horas"
attr(df$k73,"label") <- "BLOQUE (1) Nefrólogos 6 horas"
attr(df$k74,"label") <- "BLOQUE (1) Nefrólogos 4 horas"
attr(df$k75,"label") <- "BLOQUE (1) Nefrólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k76,"label") <- "BLOQUE (1) Neumólogos Total"
attr(df$k77,"label") <- "BLOQUE (1) Neumólogos 8 horas"
attr(df$k78,"label") <- "BLOQUE (1) Neumólogos 6 horas"
attr(df$k79,"label") <- "BLOQUE (1) Neumólogos 4 horas"
attr(df$k80,"label") <- "BLOQUE (1) Neumólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k81,"label") <- "BLOQUE (1) Gastroenterólogos Total"
attr(df$k82,"label") <- "BLOQUE (1) Gastroenterólogos 8 horas"
attr(df$k83,"label") <- "BLOQUE (1) Gastroenterólogos 6 horas"
attr(df$k84,"label") <- "BLOQUE (1) Gastroenterólogos 4 horas"
attr(df$k85,"label") <- "BLOQUE (1) Gastroenterólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k86,"label") <- "BLOQUE (1) Geriatras y Gerontólogos Total"
attr(df$k87,"label") <- "BLOQUE (1) Geriatras y Gerontólogos 8 horas"
attr(df$k88,"label") <- "BLOQUE (1) Geriatras y Gerontólogos 6 horas"
attr(df$k89,"label") <- "BLOQUE (1) Geriatras y Gerontólogos 4 horas"
attr(df$k90,"label") <- "BLOQUE (1) Geriatras y Gerontólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k91,"label") <- "BLOQUE (1) Oncólogos Total"
attr(df$k92,"label") <- "BLOQUE (1) Oncólogos 8 horas"
attr(df$k93,"label") <- "BLOQUE (1) Oncólogos 6 horas"
attr(df$k94,"label") <- "BLOQUE (1) Oncólogos 4 horas"
attr(df$k95,"label") <- "BLOQUE (1) Oncólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k96,"label") <- "BLOQUE (1) Urólogos Total"
attr(df$k97,"label") <- "BLOQUE (1) Urólogos 8 horas"
attr(df$k98,"label") <- "BLOQUE (1) Urólogos 6 horas"
attr(df$k99,"label") <- "BLOQUE (1) Urólogos 4 horas"
attr(df$k100,"label") <- "BLOQUE (1) Urólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k101,"label") <- "BLOQUE (1) Dermatólogos Total"
attr(df$k102,"label") <- "BLOQUE (1) Dermatólogos 8 horas"
attr(df$k103,"label") <- "BLOQUE (1) Dermatólogos 6 horas"
attr(df$k104,"label") <- "BLOQUE (1) Dermatólogos 4 horas"
attr(df$k105,"label") <- "BLOQUE (1) Dermatólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k106,"label") <- "BLOQUE (1) Infectólogos Total"
attr(df$k107,"label") <- "BLOQUE (1) Infectólogos 8 horas"
attr(df$k108,"label") <- "BLOQUE (1) Infectólogos 6 horas"
attr(df$k109,"label") <- "BLOQUE (1) Infectólogos 4 horas"
attr(df$k110,"label") <- "BLOQUE (1) Infectólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k111,"label") <- "BLOQUE (1) Endocrinólogos Total"
attr(df$k112,"label") <- "BLOQUE (1) Endocrinólogos 8 horas"
attr(df$k113,"label") <- "BLOQUE (1) Endocrinólogos 6 horas"
attr(df$k114,"label") <- "BLOQUE (1) Endocrinólogos 4 horas"
attr(df$k115,"label") <- "BLOQUE (1) Endocrinólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k116,"label") <- "BLOQUE (1) Alergólogos Total"
attr(df$k117,"label") <- "BLOQUE (1) Alergólogos 8 horas"
attr(df$k118,"label") <- "BLOQUE (1) Alergólogos 6 horas"
attr(df$k119,"label") <- "BLOQUE (1) Alergólogos 4 horas"
attr(df$k120,"label") <- "BLOQUE (1) Alergólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k121,"label") <- "BLOQUE (1) Diabetólogos Total"
attr(df$k122,"label") <- "BLOQUE (1) Diabetólogos 8 horas"
attr(df$k123,"label") <- "BLOQUE (1) Diabetólogos 6 horas"
attr(df$k124,"label") <- "BLOQUE (1) Diabetólogos 4 horas"
attr(df$k125,"label") <- "BLOQUE (1) Diabetólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k126,"label") <- "BLOQUE (1) Pediatras Total"
attr(df$k127,"label") <- "BLOQUE (1) Pediatras 8 horas"
attr(df$k128,"label") <- "BLOQUE (1) Pediatras 6 horas"
attr(df$k129,"label") <- "BLOQUE (1) Pediatras 4 horas"
attr(df$k130,"label") <- "BLOQUE (1) Pediatras eventuales o de llamada y menos de 4 horas diarias"
attr(df$k131,"label") <- "BLOQUE (1) Neonatólogos Total"
attr(df$k132,"label") <- "BLOQUE (1) Neonatólogos 8 horas"
attr(df$k133,"label") <- "BLOQUE (1) Neonatólogos 6 horas"
attr(df$k134,"label") <- "BLOQUE (1) Neonatólogos 4 horas"
attr(df$k135,"label") <- "BLOQUE (1) Neonatólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k136,"label") <- "BLOQUE (1) Ginecólogos Total"
attr(df$k137,"label") <- "BLOQUE (1) Ginecólogos 8 horas"
attr(df$k138,"label") <- "BLOQUE (1) Ginecólogos 6 horas"
attr(df$k139,"label") <- "BLOQUE (1) Ginecólogos 4 horas"
attr(df$k140,"label") <- "BLOQUE (1) Ginecólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k141,"label") <- "BLOQUE (1) De Salud Pública (Salubristas) Total"
attr(df$k142,"label") <- "BLOQUE (1) De Salud Pública (Salubristas) 8 horas"
attr(df$k143,"label") <- "BLOQUE (1) De Salud Pública (Salubristas) 6 horas"
attr(df$k144,"label") <- "BLOQUE (1) De Salud Pública (Salubristas) 4 horas"
attr(df$k145,"label") <- "BLOQUE (1) De Salud Pública (Salubristas) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k146,"label") <- "BLOQUE (1) Epidemiólogos Total"
attr(df$k147,"label") <- "BLOQUE (1) Epidemiólogos 8 horas"
attr(df$k148,"label") <- "BLOQUE (1) Epidemiólogos 6 horas"
attr(df$k149,"label") <- "BLOQUE (1) Epidemiólogos 4 horas"
attr(df$k150,"label") <- "BLOQUE (1) Epidemiólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k151,"label") <- "BLOQUE (1) De Salud Familiar y Comunitaria (Medicina familiar) Total"
attr(df$k152,"label") <- "BLOQUE (1) De Salud Familiar y Comunitaria (Medicina familiar) 8 horas"
attr(df$k153,"label") <- "BLOQUE (1) De Salud Familiar y Comunitaria (Medicina familiar) 6 horas"
attr(df$k154,"label") <- "BLOQUE (1) De Salud Familiar y Comunitaria (Medicina familiar) 4 horas"
attr(df$k155,"label") <- "BLOQUE (1) De Salud Familiar y Comunitaria (Medicina familiar) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k156,"label") <- "BLOQUE (1) Patólogo Clínico Total"
attr(df$k157,"label") <- "BLOQUE (1) Patólogo Clínico 8 horas"
attr(df$k158,"label") <- "BLOQUE (1) Patólogo Clínico 6 horas"
attr(df$k159,"label") <- "BLOQUE (1) Patólogo Clínico 4 horas"
attr(df$k160,"label") <- "BLOQUE (1) Patólogo Clínico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k161,"label") <- "BLOQUE (1) Anatomo Patólogo Total"
attr(df$k162,"label") <- "BLOQUE (1) Anatomo Patólogo 8 horas"
attr(df$k163,"label") <- "BLOQUE (1) Anatomo Patólogo 6 horas"
attr(df$k164,"label") <- "BLOQUE (1) Anatomo Patólogo 4 horas"
attr(df$k165,"label") <- "BLOQUE (1) Anatomo Patólogo eventuales o de llamada y menos de 4 horas diarias"
attr(df$k166,"label") <- "BLOQUE (1) Citólogo Total"
attr(df$k167,"label") <- "BLOQUE (1) Citólogo 8 horas"
attr(df$k168,"label") <- "BLOQUE (1) Citólogo 6 horas"
attr(df$k169,"label") <- "BLOQUE (1) Citólogo 4 horas"
attr(df$k170,"label") <- "BLOQUE (1) Citólogo eventuales o de llamada y menos de 4 horas diarias"
attr(df$k171,"label") <- "BLOQUE (1) Radiólogo Total"
attr(df$k172,"label") <- "BLOQUE (1) Radiólogo 8 horas"
attr(df$k173,"label") <- "BLOQUE (1) Radiólogo 6 horas"
attr(df$k174,"label") <- "BLOQUE (1) Radiólogo 4 horas"
attr(df$k175,"label") <- "BLOQUE (1) Radiólogo eventuales o de llamada y menos de 4 horas diarias"
attr(df$k176,"label") <- "BLOQUE (1) Médicos Postgradistas Total"
attr(df$k177,"label") <- "BLOQUE (1) Médicos Postgradistas 8 horas"
attr(df$k178,"label") <- "BLOQUE (1) Médicos Postgradistas 6 horas"
attr(df$k179,"label") <- "BLOQUE (1) Médicos Postgradistas 4 horas"
attr(df$k180,"label") <- "BLOQUE (1) Médicos Postgradistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k181,"label") <- "BLOQUE (1) Médicos Residentes Total"
attr(df$k182,"label") <- "BLOQUE (1) Médicos Residentes 8 horas"
attr(df$k183,"label") <- "BLOQUE (1) Médicos Residentes 6 horas"
attr(df$k184,"label") <- "BLOQUE (1) Médicos Residentes 4 horas"
attr(df$k185,"label") <- "BLOQUE (1) Médicos Residentes eventuales o de llamada y menos de 4 horas diarias"
attr(df$k186,"label") <- "BLOQUE (1) Médicos Rurales Total"
attr(df$k187,"label") <- "BLOQUE (1) Médicos Rurales 8 horas"
attr(df$k188,"label") <- "BLOQUE (1) Médicos Rurales 6 horas"
attr(df$k189,"label") <- "BLOQUE (1) Médicos Rurales 4 horas"
attr(df$k190,"label") <- "BLOQUE (1) Médicos Rurales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191a,"label") <- "BLOQUE (1) Nutriólogos Total"
attr(df$k192a,"label") <- "BLOQUE (1) Nutriólogos 8 horas"
attr(df$k193a,"label") <- "BLOQUE (1) Nutriólogos 6 horas"
attr(df$k194a,"label") <- "BLOQUE (1) Nutriólogos 4 horas"
attr(df$k195a,"label") <- "BLOQUE (1) Nutriólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191b,"label") <- "BLOQUE (1) Reumatólogo Total"
attr(df$k192b,"label") <- "BLOQUE (1) Reumatólogo 8 horas"
attr(df$k193b,"label") <- "BLOQUE (1) Reumatólogo 6 horas"
attr(df$k194b,"label") <- "BLOQUE (1) Reumatólogo 4 horas"
attr(df$k195b,"label") <- "BLOQUE (1) Reumatólogo eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191c,"label") <- "BLOQUE (1) Cardiotorácico Total"
attr(df$k192c,"label") <- "BLOQUE (1) Cardiotorácico 8 horas"
attr(df$k193c,"label") <- "BLOQUE (1) Cardiotorácico 6 horas"
attr(df$k194c,"label") <- "BLOQUE (1) Cardiotorácico 4 horas"
attr(df$k195c,"label") <- "BLOQUE (1) Cardiotorácico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191e,"label") <- "BLOQUE (1) Neurocirujanos Total"
attr(df$k192e,"label") <- "BLOQUE (1) Neurocirujanos 8 horas"
attr(df$k193e,"label") <- "BLOQUE (1) Neurocirujanos 6 horas"
attr(df$k194e,"label") <- "BLOQUE (1) Neurocirujanos 4 horas"
attr(df$k195e,"label") <- "BLOQUE (1) Neurocirujanos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191f,"label") <- "BLOQUE (1) Fisiatras Total"
attr(df$k192f,"label") <- "BLOQUE (1) Fisiatras 8 horas"
attr(df$k193f,"label") <- "BLOQUE (1) Fisiatras 6 horas"
attr(df$k194f,"label") <- "BLOQUE (1) Fisiatras 4 horas"
attr(df$k195f,"label") <- "BLOQUE (1) Fisiatras eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191g,"label") <- "BLOQUE (1) Médicos Acupunturistas Total"
attr(df$k192g,"label") <- "BLOQUE (1) Médicos Acupunturistas 8 horas"
attr(df$k193g,"label") <- "BLOQUE (1) Médicos Acupunturistas 6 horas"
attr(df$k194g,"label") <- "BLOQUE (1) Médicos Acupunturistas 4 horas"
attr(df$k195g,"label") <- "BLOQUE (1) Médicos Acupunturistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191h,"label") <- "BLOQUE (1) Especialistas en Atención Primaria en Salud Total"
attr(df$k192h,"label") <- "BLOQUE (1) Especialistas en Atención Primaria en Salud 8 horas"
attr(df$k193h,"label") <- "BLOQUE (1) Especialistas en Atención Primaria en Salud 6 horas"
attr(df$k194h,"label") <- "BLOQUE (1) Especialistas en Atención Primaria en Salud 4 horas"
attr(df$k195h,"label") <- "BLOQUE (1) Especialistas en Atención Primaria en Salud eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191i,"label") <- "BLOQUE (1) Audiólogos / Foniatras Total"
attr(df$k192i,"label") <- "BLOQUE (1) Audiólogos / Foniatras 8 horas"
attr(df$k193i,"label") <- "BLOQUE (1) Audiólogos / Foniatras 6 horas"
attr(df$k194i,"label") <- "BLOQUE (1) Audiólogos / Foniatras 4 horas"
attr(df$k195i,"label") <- "BLOQUE (1) Audiólogos / Foniatras eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191j,"label") <- "BLOQUE (1) Biólogos Moleculares Total"
attr(df$k192j,"label") <- "BLOQUE (1) Biólogos Moleculares 8 horas"
attr(df$k193j,"label") <- "BLOQUE (1) Biólogos Moleculares 6 horas"
attr(df$k194j,"label") <- "BLOQUE (1) Biólogos Moleculares 4 horas"
attr(df$k195j,"label") <- "BLOQUE (1) Biólogos Moleculares eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191k,"label") <- "BLOQUE (1) Genetistas Clínicos Total"
attr(df$k192k,"label") <- "BLOQUE (1) Genetistas Clínicos 8 horas"
attr(df$k193k,"label") <- "BLOQUE (1) Genetistas Clínicos 6 horas"
attr(df$k194k,"label") <- "BLOQUE (1) Genetistas Clínicos 4 horas"
attr(df$k195k,"label") <- "BLOQUE (1) Genetistas Clínicos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191l,"label") <- "BLOQUE (1) Genetistas Médicos Total"
attr(df$k192l,"label") <- "BLOQUE (1) Genetistas Médicos 8 horas"
attr(df$k193l,"label") <- "BLOQUE (1) Genetistas Médicos 6 horas"
attr(df$k194l,"label") <- "BLOQUE (1) Genetistas Médicos 4 horas"
attr(df$k195l,"label") <- "BLOQUE (1) Genetistas Médicos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191m,"label") <- "BLOQUE (1) Homeópatas Total"
attr(df$k192m,"label") <- "BLOQUE (1) Homeópatas 8 horas"
attr(df$k193m,"label") <- "BLOQUE (1) Homeópatas 6 horas"
attr(df$k194m,"label") <- "BLOQUE (1) Homeópatas 4 horas"
attr(df$k195m,"label") <- "BLOQUE (1) Homeópatas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191n,"label") <- "BLOQUE (1) Imagenólogos Total"
attr(df$k192n,"label") <- "BLOQUE (1) Imagenólogos 8 horas"
attr(df$k193n,"label") <- "BLOQUE (1) Imagenólogos 6 horas"
attr(df$k194n,"label") <- "BLOQUE (1) Imagenólogos 4 horas"
attr(df$k195n,"label") <- "BLOQUE (1) Imagenólogos"
attr(df$k191o,"label") <- "BLOQUE (1) Inmunólogos Total"
attr(df$k192o,"label") <- "BLOQUE (1) Inmunólogos 8 horas"
attr(df$k193o,"label") <- "BLOQUE (1) Inmunólogos 6 horas"
attr(df$k194o,"label") <- "BLOQUE (1) Inmunólogos 4 horas"
attr(df$k195o,"label") <- "BLOQUE (1) Inmunólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191p,"label") <- "BLOQUE (1) Médicos Aeroespaciales Total"
attr(df$k192p,"label") <- "BLOQUE (1) Médicos Aeroespaciales 8 horas"
attr(df$k193p,"label") <- "BLOQUE (1) Médicos Aeroespaciales 6 horas"
attr(df$k194p,"label") <- "BLOQUE (1) Médicos Aeroespaciales 4 horas"
attr(df$k195p,"label") <- "BLOQUE (1) Médicos Aeroespaciales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191q,"label") <- "BLOQUE (1) Médicos Críticos Total"
attr(df$k192q,"label") <- "BLOQUE (1) Médicos Críticos 8 horas"
attr(df$k193q,"label") <- "BLOQUE (1) Médicos Críticos 6 horas"
attr(df$k194q,"label") <- "BLOQUE (1) Médicos Críticos 4 horas"
attr(df$k195q,"label") <- "BLOQUE (1) Médicos Críticos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191r,"label") <- "BLOQUE (1) Médicos de emergencia Total"
attr(df$k192r,"label") <- "BLOQUE (1) Médicos de emergencia 8 horas"
attr(df$k193r,"label") <- "BLOQUE (1) Médicos de emergencia 6 horas"
attr(df$k194r,"label") <- "BLOQUE (1) Médicos de emergencia 4 horas"
attr(df$k195r,"label") <- "BLOQUE (1) Médicos de emergencia eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191s,"label") <- "BLOQUE (1) Médicos del Deporte Total"
attr(df$k192s,"label") <- "BLOQUE (1) Médicos del Deporte 8 horas"
attr(df$k193s,"label") <- "BLOQUE (1) Médicos del Deporte 6 horas"
attr(df$k194s,"label") <- "BLOQUE (1) Médicos del Deporte 4 horas"
attr(df$k195s,"label") <- "BLOQUE (1) Médicos del Deporte eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191t,"label") <- "BLOQUE (1) Médicos Ocupacionales Total"
attr(df$k192t,"label") <- "BLOQUE (1) Médicos Ocupacionales 8 horas"
attr(df$k193t,"label") <- "BLOQUE (1) Médicos Ocupacionales 6 horas"
attr(df$k194t,"label") <- "BLOQUE (1) Médicos Ocupacional 4 horases"
attr(df$k195t,"label") <- "BLOQUE (1) Médicos Ocupacionales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191u,"label") <- "BLOQUE (1) Médicos Nucleares Total"
attr(df$k192u,"label") <- "BLOQUE (1) Médicos Nucleares 8 horas"
attr(df$k193u,"label") <- "BLOQUE (1) Médicos Nucleares 6 horas"
attr(df$k194u,"label") <- "BLOQUE (1) Médicos Nucleares 4 horas"
attr(df$k195u,"label") <- "BLOQUE (1) Médicos Nucleares eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191w,"label") <- "BLOQUE (1) Neurofisiólogo Clínico Total"
attr(df$k192w,"label") <- "BLOQUE (1) Neurofisiólogo Clínico 8 horas"
attr(df$k193w,"label") <- "BLOQUE (1) Neurofisiólogo Clínico 6 horas"
attr(df$k194w,"label") <- "BLOQUE (1) Neurofisiólogo Clínico 4 horas"
attr(df$k195w,"label") <- "BLOQUE (1) Neurofisiólogo Clínico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191x,"label") <- "BLOQUE (1) Neuropsicólogos Total"
attr(df$k192x,"label") <- "BLOQUE (1) Neuropsicólogos 8 horas"
attr(df$k193x,"label") <- "BLOQUE (1) Neuropsicólogos 6 horas"
attr(df$k194x,"label") <- "BLOQUE (1) Neuropsicólogos 4 horas"
attr(df$k195x,"label") <- "BLOQUE (1) Neuropsicólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191y,"label") <- "BLOQUE (1) Parasitólogos Total"
attr(df$k192y,"label") <- "BLOQUE (1) Parasitólogos 8 horas"
attr(df$k193y,"label") <- "BLOQUE (1) Parasitólogos 6 horas"
attr(df$k194y,"label") <- "BLOQUE (1) Parasitólogos 4 horas"
attr(df$k195y,"label") <- "BLOQUE (1) Parasitólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191z,"label") <- "BLOQUE (1) Proctólogos Total"
attr(df$k192z,"label") <- "BLOQUE (1) Proctólogos 8 horas"
attr(df$k193z,"label") <- "BLOQUE (1) Proctólogos 6 horas"
attr(df$k194z,"label") <- "BLOQUE (1) Proctólogos 4 horas"
attr(df$k195z,"label") <- "BLOQUE (1) Proctólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191aa,"label") <- "BLOQUE (1) Psiquiatras Infantiles Total"
attr(df$k192aa,"label") <- "BLOQUE (1) Psiquiatras Infantiles 8 horas"
attr(df$k193aa,"label") <- "BLOQUE (1) Psiquiatras Infantiles 6 horas"
attr(df$k194aa,"label") <- "BLOQUE (1) Psiquiatras Infantiles 4 horas"
attr(df$k195aa,"label") <- "BLOQUE (1) Psiquiatras Infantiles eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191cc,"label") <- "BLOQUE (1) Subespecialistas Total"
attr(df$k192cc,"label") <- "BLOQUE (1) Subespecialistas 8 horas"
attr(df$k193cc,"label") <- "BLOQUE (1) Subespecialistas 6 horas"
attr(df$k194cc,"label") <- "BLOQUE (1) Subespecialistas 4 horas"
attr(df$k195cc,"label") <- "BLOQUE (1) Subespecialistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191dd,"label") <- "BLOQUE (1) Terapistas Neural Total"
attr(df$k192dd,"label") <- "BLOQUE (1) Terapistas Neural 8 horas"
attr(df$k193dd,"label") <- "BLOQUE (1) Terapistas Neural 6 horas"
attr(df$k194dd,"label") <- "BLOQUE (1) Terapistas Neural 4 horas"
attr(df$k195dd,"label") <- "BLOQUE (1) Terapistas Neural eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191ee,"label") <- "BLOQUE (1) Especialista en Ultrasonido Total"
attr(df$k192ee,"label") <- "BLOQUE (1) Especialista en Ultrasonido 8 horas"
attr(df$k193ee,"label") <- "BLOQUE (1) Especialista en Ultrasonido 6 horas"
attr(df$k194ee,"label") <- "BLOQUE (1) Especialista en Ultrasonido 4 horas"
attr(df$k195ee,"label") <- "BLOQUE (1) Especialista en Ultrasonido eventuales o de llamada y menos de 4 horas diarias"
attr(df$k191,"label") <- "BLOQUE (1) Otros (especifique): Total"
attr(df$k192,"label") <- "BLOQUE (1) Otros (especifique): 8 horas"
attr(df$k193,"label") <- "BLOQUE (1) Otros (especifique): 6 horas"
attr(df$k194,"label") <- "BLOQUE (1) Otros (especifique): 4 horas"
attr(df$k195,"label") <- "BLOQUE (1) Otros (especifique aqui): eventuales o de llamada y menos de 4 horas diarias"
attr(df$k196,"label") <- "BLOQUE (1) OTROS PROFESIONALES DE LA SALUD CON TÍTULO UNIVERSITARIO (USO INEC) Total"
attr(df$k197,"label") <- "BLOQUE (1) OTROS PROFESIONALES DE LA SALUD CON TÍTULO UNIVERSITARIO (USO INEC) 8 horas"
attr(df$k198,"label") <- "BLOQUE (1) OTROS PROFESIONALES DE LA SALUD CON TÍTULO UNIVERSITARIO (USO INEC) 6 horas"
attr(df$k199,"label") <- "BLOQUE (1) OTROS PROFESIONALES DE LA SALUD CON TÍTULO UNIVERSITARIO (USO INEC) 4 horas"
attr(df$k200,"label") <- "BLOQUE (1) OTROS PROFESIONALES DE LA SALUD CON TÍTULO UNIVERSITARIO (USO INEC) eventuales o de llamada"
attr(df$k201,"label") <- "BLOQUE (1) Obstetrices/Obstetras Total"
attr(df$k202,"label") <- "BLOQUE (1) Obstetrices/Obstetras 8 horas"
attr(df$k203,"label") <- "BLOQUE (1) Obstetrices/Obstetras 6 horas"
attr(df$k204,"label") <- "BLOQUE (1) Obstetrices/Obstetras 4 horas"
attr(df$k205,"label") <- "BLOQUE (1) Obstetrices/Obstetras eventuales o de llamada y menos de 4 horas diarias"
attr(df$k206,"label") <- "BLOQUE (1) Obstetrices Rurales Total"
attr(df$k207,"label") <- "BLOQUE (1) Obstetrices Rurales 8 horas"
attr(df$k208,"label") <- "BLOQUE (1) Obstetrices Rurales 6 horas"
attr(df$k209,"label") <- "BLOQUE (1) Obstetrices Rurales 4 horas"
attr(df$k210,"label") <- "BLOQUE (1) Obstetrices Rurales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k211,"label") <- "BLOQUE (1) Enfermeras Total"
attr(df$k212,"label") <- "BLOQUE (1) Enfermeras 8 horas"
attr(df$k213,"label") <- "BLOQUE (1) Enfermeras 6 horas"
attr(df$k214,"label") <- "BLOQUE (1) Enfermeras 4 horas"
attr(df$k215,"label") <- "BLOQUE (1) Enfermeras eventuales o de llamada y menos de 4 horas diarias"
attr(df$k216,"label") <- "BLOQUE (1) Enfermeras Rurales Total"
attr(df$k217,"label") <- "BLOQUE (1) Enfermeras Rurales 8 horas"
attr(df$k218,"label") <- "BLOQUE (1) Enfermeras Rurales 6 horas"
attr(df$k219,"label") <- "BLOQUE (1) Enfermeras Rurales 4 horas"
attr(df$k220,"label") <- "BLOQUE (1) Enfermeras Rurales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k221,"label") <- "BLOQUE (1) Nutricionistas Total"
attr(df$k222,"label") <- "BLOQUE (1) Nutricionistas 8 horas"
attr(df$k223,"label") <- "BLOQUE (1) Nutricionistas 6 horas"
attr(df$k224,"label") <- "BLOQUE (1) Nutricionistas 4 horas"
attr(df$k225,"label") <- "BLOQUE (1) Nutricionistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k226,"label") <- "BLOQUE (1) Psicólogos Total"
attr(df$k227,"label") <- "BLOQUE (1) Psicólogos 8 horas"
attr(df$k228,"label") <- "BLOQUE (1) Psicólogos 6 horas"
attr(df$k229,"label") <- "BLOQUE (1) Psicólogos 4 horas"
attr(df$k230,"label") <- "BLOQUE (1) Psicólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k261a,"label") <- "BLOQUE (1) Psicólogos Clínicos Total"
attr(df$k262a,"label") <- "BLOQUE (1) Psicólogos Clínicos 8 horas"
attr(df$k263a,"label") <- "BLOQUE (1) Psicólogos Clínicos 6 horas"
attr(df$k264a,"label") <- "BLOQUE (1) Psicólogos Clínicos 4 horas"
attr(df$k265a,"label") <- "BLOQUE (1) Psicólogos Clínicos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k261b,"label") <- "BLOQUE (1) Psicorehabilitador Total"
attr(df$k262b,"label") <- "BLOQUE (1) Psicorehabilitador 8 horas"
attr(df$k263b,"label") <- "BLOQUE (1) Psicorehabilitador 6 horas"
attr(df$k264b,"label") <- "BLOQUE (1) Psicorehabilitador 4 horas"
attr(df$k265b,"label") <- "BLOQUE (1) Psicorehabilitador eventuales o de llamada y menos de 4 horas diarias"
attr(df$k231,"label") <- "BLOQUE (1) Educadores para la Salud Total"
attr(df$k232,"label") <- "BLOQUE (1) Educadores para la Salud 8 horas"
attr(df$k233,"label") <- "BLOQUE (1) Educadores para la Salud 6 horas"
attr(df$k234,"label") <- "BLOQUE (1) Educadores para la Salud 4 horas"
attr(df$k235,"label") <- "BLOQUE (1) Educadores para la Salud eventuales o de llamada y menos de 4 horas diarias"
attr(df$k236,"label") <- "BLOQUE (1) Ingenieros Sanitarios Total"
attr(df$k237,"label") <- "BLOQUE (1) Ingenieros Sanitarios 8 horas"
attr(df$k238,"label") <- "BLOQUE (1) Ingenieros Sanitarios 6 horas"
attr(df$k239,"label") <- "BLOQUE (1) Ingenieros Sanitarios 4 horas"
attr(df$k240,"label") <- "BLOQUE (1) Ingenieros Sanitarios eventuales o de llamada y menos de 4 horas diarias"
attr(df$k241,"label") <- "BLOQUE (1) Bioquímico Clínico Total"
attr(df$k242,"label") <- "BLOQUE (1) Bioquímico Clínico 8 horas"
attr(df$k243,"label") <- "BLOQUE (1) Bioquímico Clínico 6 horas"
attr(df$k244,"label") <- "BLOQUE (1) Bioquímico Clínico 4 horas"
attr(df$k245,"label") <- "BLOQUE (1) Bioquímico Clínico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k246,"label") <- "BLOQUE (1) Bioquímico Farmacéutico / Químico Farmacéutico Total"
attr(df$k247,"label") <- "BLOQUE (1) Bioquímico Farmacéutico / Químico Farmacéutico 8 horas"
attr(df$k248,"label") <- "BLOQUE (1) Bioquímico Farmacéutico / Químico Farmacéutico 6 horas"
attr(df$k249,"label") <- "BLOQUE (1) Bioquímico Farmacéutico / Químico Farmacéutico 4 horas"
attr(df$k250,"label") <- "BLOQUE (1) Bioquímico Farmacéutico / Químico Farmacéutico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k261c,"label") <- "BLOQUE (1) Microbiólogos Total"
attr(df$k262c,"label") <- "BLOQUE (1) Microbiólogos 8 horas"
attr(df$k263c,"label") <- "BLOQUE (1) Microbiólogos 6 horas"
attr(df$k264c,"label") <- "BLOQUE (1) Microbiólogos 4 horas"
attr(df$k265c,"label") <- "BLOQUE (1) Microbiólogos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k251,"label") <- "BLOQUE (1) Trabajadora Social Total"
attr(df$k252,"label") <- "BLOQUE (1) Trabajadora Social 8 horas"
attr(df$k253,"label") <- "BLOQUE (1) Trabajadora Social 6 horas"
attr(df$k254,"label") <- "BLOQUE (1) Trabajadora Social 4 horas"
attr(df$k255,"label") <- "BLOQUE (1) Trabajadora Social eventuales o de llamada y menos de 4 horas diarias"
attr(df$k256,"label") <- "BLOQUE (1) Ingenieros Ambientales Total"
attr(df$k257,"label") <- "BLOQUE (1) Ingenieros Ambientales 8 horas"
attr(df$k258,"label") <- "BLOQUE (1) Ingenieros Ambientales 6 horas"
attr(df$k259,"label") <- "BLOQUE (1) Ingenieros Ambientales 4 horas"
attr(df$k260,"label") <- "BLOQUE (1) Ingenieros Ambientales eventuales o de llamada y menos de 4 horas diarias"
attr(df$k261,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k262,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k263,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k264,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k265,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k266,"label") <- "BLOQUE (1) LICENCIADOS Y/O TECNÓLOGOS Total"
attr(df$k267,"label") <- "BLOQUE (1) LICENCIADOS Y/O TECNÓLOGOS 8 horas"
attr(df$k268,"label") <- "BLOQUE (1) LICENCIADOS Y/O TECNÓLOGOS 6 horas"
attr(df$k269,"label") <- "BLOQUE (1) LICENCIADOS Y/O TECNÓLOGOS 4 horas"
attr(df$k270,"label") <- "BLOQUE (1) LICENCIADOS Y/O TECNÓLOGOS eventuales o de llamada y menos de 4 horas diarias"
attr(df$k271,"label") <- "BLOQUE (1) En Fisioterapia Total"
attr(df$k272,"label") <- "BLOQUE (1) En Fisioterapia 8 horas"
attr(df$k273,"label") <- "BLOQUE (1) En Fisioterapia 6 horas"
attr(df$k274,"label") <- "BLOQUE (1) En Fisioterapia 4 horas"
attr(df$k275,"label") <- "BLOQUE (1) En Fisioterapia eventuales o de llamada y menos de 4 horas diarias"
attr(df$k276,"label") <- "BLOQUE (1) En Anestesiología Total"
attr(df$k277,"label") <- "BLOQUE (1) En Anestesiología 8 horas"
attr(df$k278,"label") <- "BLOQUE (1) En Anestesiologí 6 horasa"
attr(df$k279,"label") <- "BLOQUE (1) En Anestesiología 4 horas"
attr(df$k280,"label") <- "BLOQUE (1) En Anestesiología eventuales o de llamada y menos de 4 horas diarias"
attr(df$k281,"label") <- "BLOQUE (1) En Laboratorio Clínico Total"
attr(df$k282,"label") <- "BLOQUE (1) En Laboratorio Clínico 8 horas"
attr(df$k283,"label") <- "BLOQUE (1) En Laboratorio Clínico 6 horas"
attr(df$k284,"label") <- "BLOQUE (1) En Laboratorio Clínico 4 horas"
attr(df$k285,"label") <- "BLOQUE (1) En Laboratorio Clínico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k286,"label") <- "BLOQUE (1) En Laboratorio Histopatológico Total"
attr(df$k287,"label") <- "BLOQUE (1) En Laboratorio Histopatológico 8 horas"
attr(df$k288,"label") <- "BLOQUE (1) En Laboratorio Histopatológico 6 horas"
attr(df$k289,"label") <- "BLOQUE (1) En Laboratorio Histopatológico 4 horas"
attr(df$k290,"label") <- "BLOQUE (1) En Laboratorio Histopatológico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k291,"label") <- "BLOQUE (1) En Radiología Total"
attr(df$k292,"label") <- "BLOQUE (1) En Radiología 8 horas"
attr(df$k293,"label") <- "BLOQUE (1) En Radiología 6 horas"
attr(df$k294,"label") <- "BLOQUE (1) En Radiología 4 horas"
attr(df$k295,"label") <- "BLOQUE (1) En Radiología eventuales o de llamada y menos de 4 horas diarias"
attr(df$k296,"label") <- "BLOQUE (1) En Saneamiento Ambiental Total"
attr(df$k297,"label") <- "BLOQUE (1) En Saneamiento Ambiental 8 horas"
attr(df$k298,"label") <- "BLOQUE (1) En Saneamiento Ambiental 6 horas"
attr(df$k299,"label") <- "BLOQUE (1) En Saneamiento Ambiental 4 horas"
attr(df$k300,"label") <- "BLOQUE (1) En Saneamiento Ambiental eventuales o de llamada y menos de 4 horas diarias"
attr(df$k301,"label") <- "BLOQUE (1) En Alimentos Total"
attr(df$k302,"label") <- "BLOQUE (1) En Alimentos 8 horas"
attr(df$k303,"label") <- "BLOQUE (1) En Alimentos 6 horas"
attr(df$k304,"label") <- "BLOQUE (1) En Alimentos 4 horas"
attr(df$k305,"label") <- "BLOQUE (1) En Alimentos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k301a,"label") <- "BLOQUE (1) En Paramédicos Total"
attr(df$k302a,"label") <- "BLOQUE (1) En Paramédicos 8 horas"
attr(df$k303a,"label") <- "BLOQUE (1) En Paramédicos 6 horas"
attr(df$k304a,"label") <- "BLOQUE (1) En Paramédicos 4 horas"
attr(df$k305a,"label") <- "BLOQUE (1) En Paramédicos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k306,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k307,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k308,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k309,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k310,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k311,"label") <- "BLOQUE (1) AUXILIARES DE ENFERMERÍA Total"
attr(df$k312,"label") <- "BLOQUE (1) AUXILIARES DE ENFERMERÍA 8 horas"
attr(df$k313,"label") <- "BLOQUE (1) AUXILIARES DE ENFERMERÍA 6 horas"
attr(df$k314,"label") <- "BLOQUE (1) AUXILIARES DE ENFERMERÍA 4 horas"
attr(df$k315,"label") <- "BLOQUE (1) AUXILIARES DE ENFERMERÍA eventuales o de llamada y menos de 4 horas diarias"
attr(df$k316,"label") <- "BLOQUE (1) Auxiliares de enfermería con Certificado Total"
attr(df$k317,"label") <- "BLOQUE (1) Auxiliares de enfermería con Certificado 8 horas"
attr(df$k318,"label") <- "BLOQUE (1) Auxiliares de enfermería con Certificado 6 horas"
attr(df$k319,"label") <- "BLOQUE (1) Auxiliares de enfermería con Certificado 4 horas"
attr(df$k320,"label") <- "BLOQUE (1) Auxiliares de enfermería con Certificado eventuales o de llamada y menos de 4 horas diarias"
attr(df$k321,"label") <- "BLOQUE (1) Auxiliares de enfermería sin Certificado Total"
attr(df$k322,"label") <- "BLOQUE (1) Auxiliares de enfermería sin Certificado 8 horas"
attr(df$k323,"label") <- "BLOQUE (1) Auxiliares de enfermería sin Certificado 6 horas"
attr(df$k324,"label") <- "BLOQUE (1) Auxiliares de enfermería sin Certificado 4 horas"
attr(df$k325,"label") <- "BLOQUE (1) Auxiliares de enfermería sin Certificado eventuales o de llamada y menos de 4 horas diarias"
attr(df$k326,"label") <- "BLOQUE (1) OTROS AUXILIARES Total"
attr(df$k327,"label") <- "BLOQUE (1) OTROS AUXILIARES 8 horas"
attr(df$k328,"label") <- "BLOQUE (1) OTROS AUXILIARES 6 horas"
attr(df$k329,"label") <- "BLOQUE (1) OTROS AUXILIARES 4 horas"
attr(df$k330,"label") <- "BLOQUE (1) OTROS AUXILIARES eventuales o de llamada y menos de 4 horas diarias"
attr(df$k331,"label") <- "BLOQUE (1) De Fisioterapia Total"
attr(df$k332,"label") <- "BLOQUE (1) De Fisioterapia 8 horas"
attr(df$k333,"label") <- "BLOQUE (1) De Fisioterapia 6 horas"
attr(df$k334,"label") <- "BLOQUE (1) De Fisioterapia 4 horas"
attr(df$k335,"label") <- "BLOQUE (1) De Fisioterapia eventuales o de llamada y menos de 4 horas diarias"
attr(df$k336,"label") <- "BLOQUE (1) De Radiología Total"
attr(df$k337,"label") <- "BLOQUE (1) De Radiología 8 horas"
attr(df$k338,"label") <- "BLOQUE (1) De Radiología 6 horas"
attr(df$k339,"label") <- "BLOQUE (1) De Radiología 4 horas"
attr(df$k340,"label") <- "BLOQUE (1) De Radiología eventuales o de llamada y menos de 4 horas diarias"
attr(df$k341,"label") <- "BLOQUE (1) De Farmacia Total"
attr(df$k342,"label") <- "BLOQUE (1) De Farmacia 8 horas"
attr(df$k343,"label") <- "BLOQUE (1) De Farmacia 6 horas"
attr(df$k344,"label") <- "BLOQUE (1) De Farmacia 4 horas"
attr(df$k345,"label") <- "BLOQUE (1) De Farmacia eventuales o de llamada y menos de 4 horas diarias"
attr(df$k346,"label") <- "BLOQUE (1) De Laboratorio Total"
attr(df$k347,"label") <- "BLOQUE (1) De Laboratorio 8 horas"
attr(df$k348,"label") <- "BLOQUE (1) De Laboratorio 6 horas"
attr(df$k349,"label") <- "BLOQUE (1) De Laboratorio 4 horas"
attr(df$k350,"label") <- "BLOQUE (1) De Laboratorio eventuales o de llamada y menos de 4 horas diarias"
attr(df$k351,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k352,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k353,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k354,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k355,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k356,"label") <- "BLOQUE (1) PERSONAL ADMINISTRATIVO Total"
attr(df$k357,"label") <- "BLOQUE (1) PERSONAL ADMINISTRATIVO 8 horas"
attr(df$k358,"label") <- "BLOQUE (1) PERSONAL ADMINISTRATIVO 6 horas"
attr(df$k359,"label") <- "BLOQUE (1) PERSONAL ADMINISTRATIVO 4 horas"
attr(df$k360,"label") <- "BLOQUE (1) PERSONAL ADMINISTRATIVO eventuales o de llamada y menos de 4 horas diarias"
attr(df$k361,"label") <- "BLOQUE (1) Directivos y/o Gerentes y/o Administradores Total"
attr(df$k362,"label") <- "BLOQUE (1) Directivos y/o Gerentes y/o Administradores 8 horas"
attr(df$k363,"label") <- "BLOQUE (1) Directivos y/o Gerentes y/o Administradores 6 horas"
attr(df$k364,"label") <- "BLOQUE (1) Directivos y/o Gerentes y/o Administradores 4 horas"
attr(df$k365,"label") <- "BLOQUE (1) Directivos y/o Gerentes y/o Administradores eventuales o de llamada y menos de 4 horas diarias"
attr(df$k366,"label") <- "BLOQUE (1) De Talento humano Total"
attr(df$k367,"label") <- "BLOQUE (1) De Talento humano 8 horas"
attr(df$k368,"label") <- "BLOQUE (1) De Talento humano 6 horas"
attr(df$k369,"label") <- "BLOQUE (1) De Talento humano 4 horas"
attr(df$k370,"label") <- "BLOQUE (1) De Talento humano eventuales o de llamada y menos de 4 horas diarias"
attr(df$k371,"label") <- "BLOQUE (1) De Estadística y Admisión Total"
attr(df$k372,"label") <- "BLOQUE (1) De Estadística y Admisión 8 horas"
attr(df$k373,"label") <- "BLOQUE (1) De Estadística y Admisión 6 horas"
attr(df$k374,"label") <- "BLOQUE (1) De Estadística y Admisión 4 horas"
attr(df$k375,"label") <- "BLOQUE (1) De Estadística y Admisión eventuales o de llamada y menos de 4 horas diarias"
attr(df$k376,"label") <- "BLOQUE (1) De Recursos Financieros Total"
attr(df$k377,"label") <- "BLOQUE (1) De Recursos Financieros 8 horas"
attr(df$k378,"label") <- "BLOQUE (1) De Recursos Financieros 6 horas"
attr(df$k379,"label") <- "BLOQUE (1) De Recursos Financieros 4 horas"
attr(df$k380,"label") <- "BLOQUE (1) De Recursos Financieros eventuales o de llamada y menos de 4 horas diarias"
attr(df$k381,"label") <- "BLOQUE (1) De Secretaría- Recepcionistas Total"
attr(df$k382,"label") <- "BLOQUE (1) De Secretaría- Recepcionistas 8 horas"
attr(df$k383,"label") <- "BLOQUE (1) De Secretaría- Recepcionistas 6 horas"
attr(df$k384,"label") <- "BLOQUE (1) De Secretaría- Recepcionistas 4 horas"
attr(df$k385,"label") <- "BLOQUE (1) De Secretaría- Recepcionistas eventuales o de llamada y menos de 4 horas diarias"
attr(df$k386,"label") <- "BLOQUE (1) De Servicios Institucionales: (Bodegueros, guardalmacén, etc) Total"
attr(df$k387,"label") <- "BLOQUE (1) De Servicios Institucionales: (Bodegueros, guardalmacén, etc) 8 horas"
attr(df$k388,"label") <- "BLOQUE (1) De Servicios Institucionales: (Bodegueros, guardalmacén, etc) 6 horas"
attr(df$k389,"label") <- "BLOQUE (1) De Servicios Institucionales: (Bodegueros, guardalmacén, etc) 4 horas"
attr(df$k390,"label") <- "BLOQUE (1) De Servicios Institucionales: (Bodegueros, guardalmacén, etc) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391a,"label") <- "BLOQUE (1) De Calidad Total"
attr(df$k392a,"label") <- "BLOQUE (1) De Calidad 8 horas"
attr(df$k393a,"label") <- "BLOQUE (1) De Calidad 6 horas"
attr(df$k394a,"label") <- "BLOQUE (1) De Calidad 4 horas"
attr(df$k395a,"label") <- "BLOQUE (1) De Calidad eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391b,"label") <- "BLOQUE (1) De Comunicación Social Total"
attr(df$k392b,"label") <- "BLOQUE (1) De Comunicación Social 8 horas"
attr(df$k393b,"label") <- "BLOQUE (1) De Comunicación Socia 6 horasl"
attr(df$k394b,"label") <- "BLOQUE (1) De Comunicación Social 4 horas"
attr(df$k395b,"label") <- "BLOQUE (1) De Comunicación Social eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391c,"label") <- "BLOQUE (1) De Planificación Total"
attr(df$k392c,"label") <- "BLOQUE (1) De Planificación 8 horas"
attr(df$k393c,"label") <- "BLOQUE (1) De Planificación 6 horas"
attr(df$k394c,"label") <- "BLOQUE (1) De Planificación 4 horas"
attr(df$k395c,"label") <- "BLOQUE (1) De Planificación eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391d,"label") <- "BLOQUE (1) De Jurídico Total"
attr(df$k392d,"label") <- "BLOQUE (1) De Jurídico 8 horas"
attr(df$k393d,"label") <- "BLOQUE (1) De Jurídico 6 horas"
attr(df$k394d,"label") <- "BLOQUE (1) De Jurídico 4 horas"
attr(df$k395d,"label") <- "BLOQUE (1) De Jurídico eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391e,"label") <- "BLOQUE (1) De Informáticos Total"
attr(df$k392e,"label") <- "BLOQUE (1) De Informáticos 8 horas"
attr(df$k393e,"label") <- "BLOQUE (1) De Informáticos 6 horas"
attr(df$k394e,"label") <- "BLOQUE (1) De Informáticos 4 horas"
attr(df$k395e,"label") <- "BLOQUE (1) De Informáticos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391f,"label") <- "BLOQUE (1) De Atención al Usuario Total"
attr(df$k392f,"label") <- "BLOQUE (1) De Atención al Usuario 8 horas"
attr(df$k393f,"label") <- "BLOQUE (1) De Atención al Usuario 6 horas"
attr(df$k394f,"label") <- "BLOQUE (1) De Atención al Usuario 4 horas"
attr(df$k395f,"label") <- "BLOQUE (1) De Atención al Usuario eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391g,"label") <- "BLOQUE (1) De Riesgos Total"
attr(df$k392g,"label") <- "BLOQUE (1) De Riesgos 8 horas"
attr(df$k393g,"label") <- "BLOQUE (1) De Riesgos 6 horas"
attr(df$k394g,"label") <- "BLOQUE (1) De Riesgos 4 horas"
attr(df$k395g,"label") <- "BLOQUE (1) De Riesgos eventuales o de llamada y menos de 4 horas diarias"
attr(df$k391,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k392,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k393,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k394,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k395,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k396,"label") <- "BLOQUE (1) PERSONAL SANITARIO DE APOYO Total"
attr(df$k397,"label") <- "BLOQUE (1) PERSONAL SANITARIO DE APOYO 8 horas"
attr(df$k398,"label") <- "BLOQUE (1) PERSONAL SANITARIO DE APOYO 6 horas"
attr(df$k399,"label") <- "BLOQUE (1) PERSONAL SANITARIO DE APOYO 4 horas"
attr(df$k400,"label") <- "BLOQUE (1) PERSONAL SANITARIO DE APOYO eventuales o de llamada y menos de 4 horas diarias"
attr(df$k401,"label") <- "BLOQUE (1) Inspector Sanitario Total"
attr(df$k402,"label") <- "BLOQUE (1) Inspector Sanitario 8 horas"
attr(df$k403,"label") <- "BLOQUE (1) Inspector Sanitario 6 horas"
attr(df$k404,"label") <- "BLOQUE (1) Inspector Sanitario 4 horas"
attr(df$k405,"label") <- "BLOQUE (1) Inspector Sanitario eventuales o de llamada y menos de 4 horas diarias"
attr(df$k406,"label") <- "BLOQUE (1) Empleado Sanitario Total"
attr(df$k407,"label") <- "BLOQUE (1) Empleado Sanitario 8 horas"
attr(df$k408,"label") <- "BLOQUE (1) Empleado Sanitario 6 horas"
attr(df$k409,"label") <- "BLOQUE (1) Empleado Sanitario 4 horas"
attr(df$k410,"label") <- "BLOQUE (1) Empleado Sanitario eventuales o de llamada y menos de 4 horas diarias"
attr(df$k411,"label") <- "BLOQUE (1) Técnico de Atención Primaria de Salud (TAPS) Total"
attr(df$k412,"label") <- "BLOQUE (1) Técnico de Atención Primaria de Salud (TAPS) 8 horas"
attr(df$k413,"label") <- "BLOQUE (1) Técnico de Atención Primaria de Salud (TAPS) 6 horas"
attr(df$k414,"label") <- "BLOQUE (1) Técnico de Atención Primaria de Salud (TAPS) 4 horas"
attr(df$k415,"label") <- "BLOQUE (1) Técnico de Atención Primaria de Salud (TAPS) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k416a,"label") <- "BLOQUE (1) Saneamiento Ambiental Total"
attr(df$k417a,"label") <- "BLOQUE (1) Saneamiento Ambiental 8 horas"
attr(df$k418a,"label") <- "BLOQUE (1) Saneamiento Ambiental 6 horas"
attr(df$k419a,"label") <- "BLOQUE (1) Saneamiento Ambiental 4 horas"
attr(df$k420a,"label") <- "BLOQUE (1) Saneamiento Ambiental eventuales o de llamada y menos de 4 horas diarias"
attr(df$k416,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k417,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k418,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k419,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k420,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k421,"label") <- "BLOQUE (1) PERSONAL DE SERVICIOS Total"
attr(df$k422,"label") <- "BLOQUE (1) PERSONAL DE SERVICIOS 8 horas"
attr(df$k423,"label") <- "BLOQUE (1) PERSONAL DE SERVICIOS 6 horas"
attr(df$k424,"label") <- "BLOQUE (1) PERSONAL DE SERVICIOS 4 horas"
attr(df$k425,"label") <- "BLOQUE (1) PERSONAL DE SERVICIOS eventuales o de llamada y menos de 4 horas diarias"
attr(df$k426,"label") <- "BLOQUE (1) De Alimentación y Dietética Total"
attr(df$k427,"label") <- "BLOQUE (1) De Alimentación y Dietética 8 horas"
attr(df$k428,"label") <- "BLOQUE (1) De Alimentación y Dietética 6 horas"
attr(df$k429,"label") <- "BLOQUE (1) De Alimentación y Dietética 4 horas"
attr(df$k430,"label") <- "BLOQUE (1) De Alimentación y Dietética eventuales o de llamada y menos de 4 horas diarias"
attr(df$k431,"label") <- "BLOQUE (1) De lavandería, Ropería y Costura Total"
attr(df$k432,"label") <- "BLOQUE (1) De lavandería, Ropería y Costura 8 horas"
attr(df$k433,"label") <- "BLOQUE (1) De lavandería, Ropería y Costura 6 horas"
attr(df$k434,"label") <- "BLOQUE (1) De lavandería, Ropería y Costura 4 horas"
attr(df$k435,"label") <- "BLOQUE (1) De lavandería, Ropería y Costura eventuales o de llamada y menos de 4 horas diarias"
attr(df$k436,"label") <- "BLOQUE (1) De limpieza Total"
attr(df$k437,"label") <- "BLOQUE (1) De limpieza 8 horas"
attr(df$k438,"label") <- "BLOQUE (1) De limpieza 6 horas"
attr(df$k439,"label") <- "BLOQUE (1) De limpieza 4 horas"
attr(df$k440,"label") <- "BLOQUE (1) De limpieza eventuales o de llamada y menos de 4 horas diarias"
attr(df$k441,"label") <- "BLOQUE (1) Conserjes, Choferes, Guardianes Total"
attr(df$k442,"label") <- "BLOQUE (1) Conserjes, Choferes, Guardianes 8 horas"
attr(df$k443,"label") <- "BLOQUE (1) Conserjes, Choferes, Guardianes 6 horas"
attr(df$k444,"label") <- "BLOQUE (1) Conserjes, Choferes, Guardianes 4 horas"
attr(df$k445,"label") <- "BLOQUE (1) Conserjes, Choferes, Guardianes eventuales o de llamada y menos de 4 horas diarias"
attr(df$k446,"label") <- "BLOQUE (1) De Mantenimiento Total"
attr(df$k447,"label") <- "BLOQUE (1) De Mantenimiento 8 horas"
attr(df$k448,"label") <- "BLOQUE (1) De Mantenimiento 6 horas"
attr(df$k449,"label") <- "BLOQUE (1) De Mantenimiento 4 horas"
attr(df$k450,"label") <- "BLOQUE (1) De Mantenimiento eventuales o de llamada y menos de 4 horas diarias"
attr(df$k451,"label") <- "BLOQUE (1) Camilleros Total"
attr(df$k452,"label") <- "BLOQUE (1) Camilleros 8 horas"
attr(df$k453,"label") <- "BLOQUE (1) Camilleros 6 horas"
attr(df$k454,"label") <- "BLOQUE (1) Camilleros 4 horas"
attr(df$k455,"label") <- "BLOQUE (1) Camilleros eventuales o de llamada y menos de 4 horas diarias"
attr(df$k456,"label") <- "BLOQUE (1) Otros (especifique) Total"
attr(df$k457,"label") <- "BLOQUE (1) Otros (especifique) 8 horas"
attr(df$k458,"label") <- "BLOQUE (1) Otros (especifique) 6 horas"
attr(df$k459,"label") <- "BLOQUE (1) Otros (especifique) 4 horas"
attr(df$k460,"label") <- "BLOQUE (1) Otros (especifique) eventuales o de llamada y menos de 4 horas diarias"
attr(df$k461,"label") <- "BLOQUE (1) Promotores de la Salud en la Comunidad Total"
attr(df$k462,"label") <- "BLOQUE (1) Promotores de la Salud en la Comunidad 8 horas"
attr(df$k463,"label") <- "BLOQUE (1) Promotores de la Salud en la Comunidad 6 horas"
attr(df$k464,"label") <- "BLOQUE (1) Promotores de la Salud en la Comunidad 4 horas"
attr(df$k465,"label") <- "BLOQUE (1) Promotores de la Salud en la Comunidad eventuales o de llamada y menos de 4 horas diarias"
attr(df$k466,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Menos de 1 mes - Atención por Médico"
attr(df$k467,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Menos de 1 mes - Actividades de enfermería"
attr(df$k468,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 11 meses - Atención por Médico"
attr(df$k469,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 11 meses - Atención por Psicólogo"
attr(df$k470,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 11 meses - Actividades de enfermería"
attr(df$k471,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 4 años - Atención por Médico"
attr(df$k472,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 4 años - Atención por Psicólogo"
attr(df$k473,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 1 a 4 años - Actividades de enfermería"
attr(df$k474,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 5 a 9 años - Atención por Médico"
attr(df$k475,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 5 a 9 años - Atención por Psicólogo"
attr(df$k476,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 5 a 9 años - Actividades de enfermería"
attr(df$k477,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 10 a 14 años - Atención por Médico"
attr(df$k478,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 10 a 14 años - Atención por Obstetriz"
attr(df$k479,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 10 a 14 año - Atención por Psicólogos"
attr(df$k480,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 10 a 14 años - Actividades de enfermería"
attr(df$k481,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 15 a 19 años - Atención por Médico"
attr(df$k482,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 15 a 19 años - Atención por Obstetriz"
attr(df$k483,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 15 a 19 años - Atención por Psicólogo"
attr(df$k484,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 15 a 19 años - Actividades  Enfermería"
attr(df$k485,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 20 a 35 años - Atención por Médico"
attr(df$k486,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 20 a 35 años - Atención por Obstetriz"
attr(df$k487,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 20 a 35 años - Atención por Psicólogo"
attr(df$k488,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 20 a 35 años - Actividades de enfermería"
attr(df$k489,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 36 a 49 años - Atención por Médico"
attr(df$k490,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 36 a 49 años - Atención por Obstetriz"
attr(df$k491,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 36 a 49 años - Atención por Psicólogo"
attr(df$k492,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 36 a 49 años - Actividades de enfermería"
attr(df$k493,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 50 a 64 años - Atención por Médico"
attr(df$k494,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 50 a 64 años - Atención por Obstetriz"
attr(df$k495,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 50 a 64 años - Atención por Psicólogo"
attr(df$k496,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 50 a 64 años - Actividades de enfermería"
attr(df$k497,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 65 y más años - Atención por Médico"
attr(df$k498,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 65 y más años - Atención por Obstetriz"
attr(df$k499,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 65 y más años - Atención por Psicólogo"
attr(df$k500,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) 65 y más años - Actividades de enfermería"
attr(df$k501,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Edad no especificada - Atención por Médico"
attr(df$k502,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Edad no especificada - Atención por Obstetriz"
attr(df$k503,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Edad no especificada - Atención por Psicólogo"
attr(df$k504,"label") <- "BLOQUE (2) Total consultas de morbilidad - Mujeres (suma de primeras y subsecuentes) Edad no especificada - Actividades de enfermería"
attr(df$k505,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Mujeres) - Atención por Médico"
attr(df$k506,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Mujeres) - Atención por Obstetriz"
attr(df$k507,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Mujeres) - Atención por Psicólogo"
attr(df$k508,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Mujeres) Actividades  Enfermería"
attr(df$k509,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Mujeres (Morbilidad) - Atención por Médico"
attr(df$k510,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Mujeres (Morbilidad) - Atención por Obstetriz"
attr(df$k511,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Mujeres (Morbilidad) - Atención por Psicólogo"
attr(df$k512,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Mujeres (Morbilidad) - Actividades de enfermería"
attr(df$k513,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Mujeres (Morbilidad) - Atención por Médico"
attr(df$k514,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Mujeres (Morbilidad) - Atención por Obstetriz"
attr(df$k515,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Mujeres (Morbilidad) - Atención por Psicólogo"
attr(df$k516,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Mujeres (Morbilidad) - Actividades de enfermería"
attr(df$k517,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) Menos de 1 mes - Atención por Médico"
attr(df$k518,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) Menos de 1 mes - Actividades de enfermería"
attr(df$k519,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 11 meses - Atención por Médico"
attr(df$k520,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 11 meses - Atención por Psicólogo"
attr(df$k521,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 11 meses - Actividades de enfermería"
attr(df$k522,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 4 años - Atención por Médico"
attr(df$k523,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 4 años - Atención por Psicólogo"
attr(df$k524,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 1 a 4 años - Actividades de enfermería"
attr(df$k525,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 5 a 9 años - Atención por Médico"
attr(df$k526,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 5 a 9 años - Atención por Psicólogo"
attr(df$k527,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 5 a 9 años - Actividades de enfermería"
attr(df$k528,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 10 a 14 años - Atención por Médico"
attr(df$k529,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 10 a 14 años - Atención por Psicólogo"
attr(df$k530,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 10 a 14 años - Actividades de enfermería"
attr(df$k531,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 15 a 19 años - Atención por Médico"
attr(df$k532,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 15 a 19 años - Atención por Psicólogo"
attr(df$k533,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 15 a 19 años - Actividades de enfermería"
attr(df$k534,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 20 a 35 años - Atención por Médico"
attr(df$k535,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 20 a 35 años - Atención por Psicólogo"
attr(df$k536,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 20 a 35 años - Actividades de enfermería"
attr(df$k537,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 36 a 49 años - Atención por Médico"
attr(df$k538,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 36 a 49 años - Atención por Psicólogo"
attr(df$k539,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 36 a 49 años - Actividades de enfermería"
attr(df$k540,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 50 a 64 años - Atención por Médico"
attr(df$k541,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 50 a 64 años - Atención por Psicólogo"
attr(df$k542,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 50 a 64 años - Actividades de enfermería"
attr(df$k543,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 65 y más años - Atención por Médico"
attr(df$k544,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 65 y más años - Atención por Psicólogo"
attr(df$k545,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) 65 y más años - Actividades de enfermería"
attr(df$k546,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) Edad no especificada - Atención por Médico"
attr(df$k547,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) Edad no especificada - Atención por Psicólogo"
attr(df$k548,"label") <- "BLOQUE (2) Total de consultas de morbilidad - Hombres (suma de primeras y subsecuentes) Edad no especificada - Actividades de enfermería"
attr(df$k549,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Hombres) - Atención por Médico"
attr(df$k550,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Hombres) - Atención por Psicólogo"
attr(df$k551,"label") <- "BLOQUE (2) USO INEC (Total Morbilidad Hombres) - Actividades de enfermería"
attr(df$k552,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Hombres (Morbilidad) - Atención por Médico"
attr(df$k553,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Hombres (Morbilidad) - Atención por Psicólogo"
attr(df$k554,"label") <- "BLOQUE (2) TOTALES DE PRIMERAS CONSULTAS - Hombres (Morbilidad) - Actividades de enfermería"
attr(df$k555,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Hombres  - Atención por Médico"
attr(df$k556,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Hombres  - Atención por Psicólogo"
attr(df$k557,"label") <- "BLOQUE (2) TOTALES DE CONSULTAS SUBSECUENTES - Hombres  - Actividades de enfermería"
attr(df$k558,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k559,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k560,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k561,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k562,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k563,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k564,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k565,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k566,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k567,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k568,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k569,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k570,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k571,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k572,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k573,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k574,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k575,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k576,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Código CIE-10)"
attr(df$k577,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Mujeres (Número de casos)"
attr(df$k580,"label") <- "BLOQUE (3) Total Principales Causas De Morbilidad Ambulatoria - Mujeres (Número de casos)"
attr(df$k581,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k582,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k583,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k584,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k585,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k586,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k587,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k588,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k589,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k590,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k591,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k592,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k593,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k594,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k595,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k596,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k597,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k598,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k599,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Código CIE-10)"
attr(df$k600,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Hombres (Número de casos)"
attr(df$k603,"label") <- "BLOQUE (3) Total Principales Causas De Morbilidad Ambulatoria - Hombres (Número de casos)"
attr(df$k604,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k605,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k606,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k607,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k608,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k609,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k610,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k611,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k612,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k613,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k614,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k615,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k616,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k617,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k618,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k619,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k620,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k621,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k622,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Código CIE-10)"
attr(df$k623,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - Infantil menores de un año (Número de casos)"
attr(df$k626,"label") <- "BLOQUE (3) Total Principales Causas De Morbilidad Ambulatoria - Infantil menores de un año (Número de casos)"
attr(df$k627,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k628,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k629,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k630,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k631,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k632,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k633,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k634,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k635,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k636,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k637,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k638,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k639,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k640,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k641,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k642,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k643,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k644,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k645,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Código CIE-10)"
attr(df$k646,"label") <- "BLOQUE (3) Principales Causas De Morbilidad Ambulatoria (consulta externa) - de 1 hasta 4 años (Número de casos)"
attr(df$k649,"label") <- "BLOQUE (3) Total Principales Causas De Morbilidad Ambulatoria - de 1 hasta 4 años (Número de casos)"
attr(df$k650,"label") <- "BLOQUE (4) Primeras consultas ambulatorias anuales de prevención en Niños menores de 1 año - Atención por Médico"
attr(df$k651,"label") <- "BLOQUE (4) Primeras consultas ambulatorias anuales de prevención en Niños menores de 1 año - Actividades de Enfermería"
attr(df$k652,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 1 - 4 años - Atención por Médico"
attr(df$k653,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 1 a 4 años - Atención por Psicólogo"
attr(df$k654,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 1 - 4 años - Actividades de Enfermería"
attr(df$k655,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 5 a 9 años - Atención por Médico"
attr(df$k656,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 5 a 9 años - Atención por Psicólogo"
attr(df$k657,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Niños de 5 a 9 años - Actividades de Enfermería"
attr(df$k658,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 10 a 14 años - Atención por Médico"
attr(df$k659,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 10 a 14 años - Atención por Obstetriz"
attr(df$k660,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 10 a 14 años - Atención por Psicólogo"
attr(df$k661,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 10 a 14 años - Actividades de Enfermería"
attr(df$k662,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 15 a 19 años - Atención por Médico"
attr(df$k663,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 15 a 19 años - Atención por Obstetriz"
attr(df$k664,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 15 a 19 años - Atención por Psicólogo"
attr(df$k665,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 15 a 19 años - Actividades de Enfermería"
attr(df$k672,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20 a 35 años - Atención por Médico"
attr(df$k673,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20 a 35 años - Atención por Obstetriz"
attr(df$k674,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20 a 35 años - Atención por Psicólogo"
attr(df$k675,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20 a 35 años - Actividades de Enfermería"
attr(df$k676,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 36 a 49 años - Atención por Médico"
attr(df$k677,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 36 a 49 años - Atención por Obstetriz"
attr(df$k678,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 36 a 49 años - Atención por Psicólogo"
attr(df$k679,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 36 a 49 años - Actividades de Enfermería"
attr(df$k680,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 50 a 64 años - Atención por Médico"
attr(df$k681,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 50 a 64 años - Atención por Obstetriz"
attr(df$k682,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 50 a 64 años - Atención por Psicólogo"
attr(df$k683,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 50 a 64 años - Actividades de Enfermería"
attr(df$k684,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 65 años y más - Atención por Médico"
attr(df$k685,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 65 años y más - Atención por Obstetriz"
attr(df$k686,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 65 años y más - Atención por Psicólogo"
attr(df$k687,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto)  de 65 años y más - Actividades de Enfermería"
attr(df$k684a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Médico"
attr(df$k685a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Obstetriz"
attr(df$k686a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Psicólogo"
attr(df$k687a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Actividades de Enfermería"
attr(df$k666,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 10 a 14 años - Atención por Médico"
attr(df$k667,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 10 a 14 años - Atención por Psicólogo"
attr(df$k668,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 10 a 14 años - Actividades de Enfermería"
attr(df$k669,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 15 a 19 años - Atención por Médico"
attr(df$k670,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 15 a 19 años - Atención por Psicólogo"
attr(df$k671,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 15 a 19 años - Actividades de Enfermería"
attr(df$k688,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 20 - 35 años - Atención por Médico"
attr(df$k690,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 20 - 35 años - Atención por Psicólogo"
attr(df$k691,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 20 - 35 años - Actividades de Enfermería"
attr(df$k692,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 36 - 49 años - Atención por Médico"
attr(df$k694,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 36 - 49 años - Atención por Psicólogo"
attr(df$k695,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 36 - 49 años - Actividades de Enfermería"
attr(df$k696,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 50 - 64 años - Atención por Médico"
attr(df$k698,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 50 - 64 años - Atención por Psicólogo"
attr(df$k699,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 50 - 64 años - Actividades de Enfermería"
attr(df$k700,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 65 años y más - Atención por Médico"
attr(df$k702,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 65 años y más - Atención por Psicólogo"
attr(df$k703,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de 65 años y más - Actividades de Enfermería"
attr(df$k700a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de Edad no especificada - Atención por Médico"
attr(df$k702a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de Edad no especificada - Atención por Psicólogo"
attr(df$k703a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Hombres de Edad no especificada - Actividades de Enfermería"
attr(df$k704,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Prenatal - Atención por Médico"
attr(df$k705,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Prenatal - Atención por Obstetriz"
attr(df$k706,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Prenatal - Actividades de Enfermería"
attr(df$k707,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Parto*Atención de partos - Atención por Médico"
attr(df$k708,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Parto*Atención de partos - Atención por Obstetriz"
attr(df$k709,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Parto*Atención de partos - Actividades de Enfermería"
attr(df$k710,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Post-Parto - Atención por Médico"
attr(df$k711,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Post-Parto - Atención por Obstetriz"
attr(df$k712,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 10-19 años Post-Parto - Actividades de Enfermería"
attr(df$k713,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Prenatal - Atención por Médico"
attr(df$k714,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Prenatal - Atención por Obstetriz"
attr(df$k715,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Prenatal - Actividades de Enfermería"
attr(df$k716,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Parto*Atención de partos - Atención por Médico"
attr(df$k717,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Parto*Atención de partos - Atención por Obstetriz"
attr(df$k718,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Parto*Atención de partos - Actividades de Enfermería"
attr(df$k719,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Post-Parto - Atención por Médico"
attr(df$k720,"label") <- "BLOQUE(4)Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Post-Parto - Atención por Obstetriz"
attr(df$k721,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención en Mujeres de 20-50 años Post-Parto - Actividades de Enfermería"
attr(df$k722,"label") <- "BLOQUE(4) Total de primeras consultas ambulatorias anuales de prevención Uso Inec - Atención por Médico"
attr(df$k723,"label") <- "BLOQUE(4) Total de primeras consultas ambulatorias anuales de prevención Uso Inec - Atención por Obstetriz"
attr(df$k724,"label") <- "BLOQUE(4) Total de primeras consultas ambulatorias anuales de prevención Uso Inec - Atención por Psicólogo"
attr(df$k725,"label") <- "BLOQUE(4) Total de primeras consultas ambulatorias anuales de prevención Uso Inec - Actividades de Enfermería"
attr(df$k726,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k727,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k728,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k728aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Edad no especificada) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k729a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k730a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k731a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k731aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k732a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k733a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k734a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k734aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k729b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k730b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k731b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k731bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k732b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k733b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k734b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k734bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k729c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k730c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k731c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k731cc,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k732c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales de emergencia - Atención por Médico"
attr(df$k733c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales de emergencia - Atención por Médico"
attr(df$k734c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales de emergencia - Atención por Médico"
attr(df$k734cc,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Anticonceptivos Orales de emergencia - Atención por Médico"
attr(df$k735,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Inyectable - Atención por Médico"
attr(df$k736,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Inyectable - Atención por Médico"
attr(df$k737,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Inyectable - Atención por Médico"
attr(df$k737aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Inyectable - Atención por Médico"
attr(df$k738,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Inyectable - Atención por Médico"
attr(df$k739,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Inyectable - Atención por Médico"
attr(df$k740,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Inyectable - Atención por Médico"
attr(df$k740aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Inyectable - Atención por Médico"
attr(df$k741,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Preservativos - Atención por Médico"
attr(df$k742,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Preservativos - Atención por Médico"
attr(df$k743,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Preservativos - Atención por Médico"
attr(df$k743aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Preservativos - Atención por Médico"
attr(df$k744,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Preservativos - Atención por Médico"
attr(df$k745,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Preservativos - Atención por Médico"
attr(df$k746,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Preservativos - Atención por Médico"
attr(df$k746aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Preservativos - Atención por Médico"
attr(df$k747,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Implantes - Atención por Médico"
attr(df$k748,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Implantes - Atención por Médico"
attr(df$k749,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Implantes - Atención por Médico"
attr(df$k749aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Implantes - Atención por Médico"
attr(df$k751,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Vasectomía - Atención por Médico"
attr(df$k752,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Vasectomía - Atención por Médico"
attr(df$k752aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Vasectomía - Atención por Médico"
attr(df$k754,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Salpingectomía - Atención por Médico"
attr(df$k755,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Salpingectomía - Atención por Médico"
attr(df$k755aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Salpingectomía - Atención por Médico"
attr(df$k756a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anillo Vaginal - Atención por Médico"
attr(df$k757a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anillo Vaginal - Atención por Médico"
attr(df$k758a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anillo Vaginal - Atención por Médico"
attr(df$k758aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anillo Vaginal - Atención por Médico"
attr(df$k756b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Parche Trandérmico - Atención por Médico"
attr(df$k757b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Parche Trandérmico - Atención por Médico"
attr(df$k758b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Parche Trandérmico - Atención por Médico"
attr(df$k758bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Parche Trandérmico - Atención por Médico"
attr(df$k756,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Otros - Atención por Médico"
attr(df$k757,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Otros - Atención por Médico"
attr(df$k758,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Otros - Atención por Médico"
attr(df$k758aaa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Otros - Atención por Médico"
attr(df$k759,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Otros - Atención por Médico"
attr(df$k760,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Otros - Atención por Médico"
attr(df$k761,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Otros - Atención por Médico"
attr(df$k761aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Otros - Atención por Médico"
attr(df$k762,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k763,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k764,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k764aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k765,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k766,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k767,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k767aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k762t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Total* - Atención por Médico"
attr(df$k763t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Total* - Atención por Médico"
attr(df$k764t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Total* - Atención por Médico"
attr(df$k764tt,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Total* - Atención por Médico"
attr(df$k765t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Total* - Atención por Médico"
attr(df$k766t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Total* - Atención por Médico"
attr(df$k767t,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Total* - Atención por Médico"
attr(df$k767tt,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Total* - Atención por Médico"
attr(df$k768,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k769,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k770,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k770aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k771a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k772a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k773a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k773aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k774a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k775a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k776a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k776aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k771b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k772b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k773b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k773bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k774b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k775b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k776b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k776bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k771c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k772c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k773c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k773cc,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k774c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k775c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k776c,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k776cc,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k777,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Inyectable - Atención por Obstetriz"
attr(df$k778,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Inyectable - Atención por Obstetriz"
attr(df$k779,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Inyectable - Atención por Obstetriz"
attr(df$k779aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Inyectable - Atención por Obstetriz"
attr(df$k780,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Inyectable - Atención por Obstetriz"
attr(df$k781,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Inyectable - Atención por Obstetriz"
attr(df$k782,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Inyectable - Atención por Obstetriz"
attr(df$k782aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Inyectable - Atención por Obstetriz"
attr(df$k783,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Preservativos - Atención por Obstetriz"
attr(df$k784,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Preservativos - Atención por Obstetriz"
attr(df$k785,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Preservativos - Atención por Obstetriz"
attr(df$k785aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Preservativos - Atención por Obstetriz"
attr(df$k786,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Preservativos - Atención por Obstetriz"
attr(df$k787,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Preservativos - Atención por Obstetriz"
attr(df$k788,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Preservativos - Atención por Obstetriz"
attr(df$k788aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Preservativos - Atención por Obstetriz"
attr(df$k789,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Implantes - Atención por Obstetriz"
attr(df$k790,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Implantes - Atención por Obstetriz"
attr(df$k791,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Implantes - Atención por Obstetriz"
attr(df$k791aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Implantes - Atención por Obstetriz"
attr(df$k796,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Salpingectomía - Atención por Obstetriz"
attr(df$k797,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Salpingectomía - Atención por Obstetriz"
attr(df$k797aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Salpingectomía - Atención por Obstetriz"
attr(df$k798a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k799a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k800a,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k800aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Anillo Vaginal - Atención por Obstetriz"
attr(df$k798b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Parche Transdérmico - Atención por Obstetriz"
attr(df$k799b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Parche Transdérmico - Atención por Obstetriz"
attr(df$k800b,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Parche Transdérmico - Atención por Obstetriz"
attr(df$k800bb,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Parche Transdérmico - Atención por Obstetriz"
attr(df$k798,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Otros - Atención por Obstetriz"
attr(df$k799,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Otros - Atención por Obstetriz"
attr(df$k800,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Otros - Atención por Obstetriz"
attr(df$k800aaa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Otros - Atención por Obstetriz"
attr(df$k801,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Otros - Atención por Obstetriz"
attr(df$k802,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Otros - Atención por Obstetriz"
attr(df$k803,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Otros - Atención por Obstetriz"
attr(df$k803aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Otros - Atención por Obstetriz"
attr(df$k804,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k805,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k806,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k806aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k807,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k808,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k809,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k809aa,"label") <- "BLOQUE(4) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Total: Si no dispone por metodos de planificación desglosados* - Atención por Obstetriz"
attr(df$k804t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) - Atención por Obstetriz"
attr(df$k805t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) - Atención por Obstetriz"
attr(df$k806t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) - Atención por Obstetriz"
attr(df$k806tt,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) - Atención por Obstetriz"
attr(df$k807t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) - Atención por Obstetriz"
attr(df$k808t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) - Atención por Obstetriz"
attr(df$k809t,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) - Atención por Obstetriz"
attr(df$k809tt,"label") <- "BLOQUE(4) Total (USO INEC) Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) - Atención por Obstetriz"
attr(df$k810,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) - Atención Médico + Atención Obstetriz"
attr(df$k811,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k812,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k812aa,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Mujeres Edad no especificada) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k813,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k814,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k815,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k815aa,"label") <- "BLOQUE(4) USO INEC (Planificación Primeras) Total Primeras consultas ambulatorias anuales de prevención Planificación Familiar (Hombres Edad no especificada) Uso Inec - Atención Médico + Atención Obstetriz"
attr(df$k816,"label") <- "BLOQUE(4) Detección oportuna del cáncer cérvicouterino en Mujeres - Atención por Médico"
attr(df$k817,"label") <- "BLOQUE(4) Detección oportuna del cáncer cérvicouterino en Mujeres por - Atención por Obstetriz"
attr(df$k818,"label") <- "BLOQUE(4) Detección oportuna del cáncer mamario en Mujeres - Atención por Médico"
attr(df$k819,"label") <- "BLOQUE(4) Detección oportuna del cáncer mamario en Mujeres por - Atención por Obstetriz"
attr(df$k820,"label") <- "BLOQUE(4) Detección oportuna del cáncer pulmonar en Mujeres - Atención por Médico"
attr(df$k821,"label") <- "BLOQUE(4) Detección oportuna del cáncer gástrico en Mujeres - Atención por Médico"
attr(df$k822,"label") <- "BLOQUE(4) Detección oportuna del cáncer hepático en Mujeres - Atención por Médico"
attr(df$k823,"label") <- "BLOQUE(4) Detección oportuna del cáncer colorrectal en Mujeres - Atención por Médico"
attr(df$k825,"label") <- "BLOQUE(4) Detección oportuna del cáncer de piel en Mujeres - Atención por Médico"
attr(df$k825a,"label") <- "BLOQUE(4) Detección oportuna del cáncer de tiroides en Mujeres - Atención por Médico"
attr(df$k825b,"label") <- "BLOQUE(4) Detección oportuna del cáncer otros (especifique) en Mujeres - Atención por Médico "
attr(df$k826,"label") <- "BLOQUE(4) USO INEC (Detección de Cáncer / Mujeres) Total - Atención por Médico"
attr(df$k827,"label") <- "BLOQUE(4) USO INEC (Detección de Cáncer / Mujeres) Total - Atención por Obstetriz"
attr(df$k828,"label") <- "BLOQUE(4) Detección oportuna del cáncer de prostata en Hombres - Atención por Médico"
attr(df$k829,"label") <- "BLOQUE(4) Detección oportuna del cáncer mamario en Hombres - Atención por Médico"
attr(df$k830,"label") <- "BLOQUE(4) Detección oportuna del cáncer pulmonar en Hombres - Atención por Médico"
attr(df$k831,"label") <- "BLOQUE(4) Detección oportuna del cáncer gástrico en Hombres - Atención por Médico"
attr(df$k832,"label") <- "BLOQUE(4) Detección oportuna del cáncer hepático en Hombres - Atención por Médico"
attr(df$k833,"label") <- "BLOQUE(4) Detección oportuna del cáncer colorrectal en Hombres - Atención por Médico"
attr(df$k834,"label") <- "BLOQUE(4) Detección oportuna del cáncer de piel en Hombres - Atención por Médico"
attr(df$k834a,"label") <- "BLOQUE(4) Detección oportuna del cáncer de tiroides en Hombres - Atención por Médico"
attr(df$k834b,"label") <- "BLOQUE(4) Detección oportuna del cáncer otros (especifique) en Hombres - Atención por Médico"
attr(df$k834c,"label") <- "BLOQUE(4) Detección oportuna del cáncer otros (especifique)  - Atención por Obstetriz"
attr(df$k835,"label") <- "BLOQUE(4) USO INEC (Detección de Cáncer / Hombres) Total - Atención por Médico"
attr(df$k836,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños menores de un año - Atención por Médico"
attr(df$k837,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños menores de 1 año - Actividades de enfermería"
attr(df$k838,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 1-4 años - Atención por Médico"
attr(df$k839,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 1-4 años - Atención por Psicólogo"
attr(df$k840,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 1-4 años - Actividades de enfermería"
attr(df$k841,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 5-9 años - Atención por Médico"
attr(df$k842,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 5-9 años - Atención por Psicólogo"
attr(df$k843,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en niños de 5-9 años - Actividades de enfermería"
attr(df$k844,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 10-14 años - Atención por Médico"
attr(df$k845,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 10-14 años - Atención por Obstetriz"
attr(df$k846,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 10-14 años - Atención por Psicólogo"
attr(df$k847,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 10-14 años - Actividades de enfermería"
attr(df$k848,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 15-19 años - Atención por Médico"
attr(df$k849,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 15-19 años - Atención por Obstetriz"
attr(df$k850,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 15-19 años - Atención por Psicólogo"
attr(df$k851,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 15-19 años - Actividades de enfermería"
attr(df$k858,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20-35 años - Atención por Médico"
attr(df$k859,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 20-35 años - Atención por Obstetriz"
attr(df$k860,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20-35 años - Atención por Psicólogo"
attr(df$k861,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 20-35 años - Actividades de enfermería"
attr(df$k862,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 36-49 años - Atención por Médico"
attr(df$k863,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 36-49 años - Atención por Obstetriz"
attr(df$k864,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 36-49 años - Atención por Psicólogo"
attr(df$k865,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 36-49 años - Actividades de enfermería"
attr(df$k866,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 50-64 años - Atención por Médico"
attr(df$k867,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 50-64 años - Atención por Obstetriz"
attr(df$k868,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 50-64 años - Atención por Psicólogo"
attr(df$k869,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 50-64 años - Actividades de enfermería"
attr(df$k870,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 65 años y más - Atención por Médico"
attr(df$k871,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) 65 años y más - Atención por Obstetriz"
attr(df$k872,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 65 años y más - Atención por Psicólogo"
attr(df$k873,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) de 65 años y más - Actividades de enfermería"
attr(df$k870a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Médico"
attr(df$k871a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Obstetriz"
attr(df$k872a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Atención por Psicólogo"
attr(df$k873a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres (Excepto consultas en el periodo Prenatal, Parto y Post-parto) Edad no especificada - Actividades de enfermería"
attr(df$k852,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 10-14 años - Atención por Médico"
attr(df$k853,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 10-14 años - Atención por Psicólogo"
attr(df$k854,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 10-14 años - Actividades de enfermería"
attr(df$k855,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 15-19 años - Atención por Médico"
attr(df$k856,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 15-19 años - Atención por Psicólogo"
attr(df$k857,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 15-19 años - Actividades de enfermería"
attr(df$k874,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 20-35 años - Atención por Médico"
attr(df$k875,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 20-35 años - Atención por Psicólogo"
attr(df$k876,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 20-35 años - Actividades de enfermería"
attr(df$k877,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 36-49 años - Atención por Médico"
attr(df$k878,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 36-49 años - Atención por Psicólogo"
attr(df$k879,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 36-49 años - Actividades de enfermería"
attr(df$k880,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en  Hombres de 50-64 años - Atención por Médico"
attr(df$k881,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 50-64 años - Atención por Psicólogo"
attr(df$k882,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 50-64 años - Actividades de enfermería"
attr(df$k883,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 65 años y más - Atención por Médico"
attr(df$k884,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 65 años y más - Atención por Psicólogo"
attr(df$k885,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres de 65 años y más - Actividades de enfermería"
attr(df$k883a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres edad no especificada - Atención por Médico"
attr(df$k884a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres edad no especificada - Atención por Psicólogo"
attr(df$k885a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Hombres edad no especificada - Actividades de enfermería"
attr(df$k886,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres de 10-19 años Prenatal - Atención por Médico"
attr(df$k887,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres 10-19 años Prenatal - Atención por Obstetriz"
attr(df$k888,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres 20-50 años Prenatal - Atención por Médico"
attr(df$k889,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención en Mujeres 20-50 años Prenatal - Atención por Obstetriz"
attr(df$k890,"label") <- "BLOQUE(4) USO INEC (Prevención Subsecuentes) total consultas - Atención por Médico"
attr(df$k891,"label") <- "BLOQUE(4) USO INEC (Prevención Subsecuentes) total consultas - Atención por Obstetriz"
attr(df$k892,"label") <- "BLOQUE(4) USO INEC (Prevención Subsecuentes) total consultas - Atención por Psicólogo"
attr(df$k893,"label") <- "BLOQUE(4) USO INEC (Prevención Subsecuentes) total consultas - Actividades de enfermería"
attr(df$k894,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k895,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k896,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k896aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Dispositivo Intrauterino (DIU) - Atención por Médico"
attr(df$k897a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k898a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k899a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k899aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k900a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k901a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k902a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k902aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales Combinados - Atención por Médico"
attr(df$k897b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k898b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k899b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k899bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k900b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k901b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k902b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k902bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Médico"
attr(df$k897c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k898c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k899c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k899cc,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k900c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k901c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k902c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k902cc,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivo Oral de emergencia - Atención por Médico"
attr(df$k903,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Inyectable - Atención por Médico"
attr(df$k904,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Inyectable - Atención por Médico"
attr(df$k905,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Inyectable - Atención por Médico"
attr(df$k905aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Inyectable - Atención por Médico"
attr(df$k906,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Inyectable - Atención por Médico"
attr(df$k907,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Inyectable - Atención por Médico"
attr(df$k908,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Inyectable - Atención por Médico"
attr(df$k908aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Inyectable - Atención por Médico"
attr(df$k909,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Preservativos - Atención por Médico"
attr(df$k910,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Preservativos - Atención por Médico"
attr(df$k911,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Preservativos - Atención por Médico"
attr(df$k911aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Preservativos - Atención por Médico"
attr(df$k912,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Preservativos - Atención por Médico"
attr(df$k913,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Preservativos - Atención por Médico"
attr(df$k914,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Preservativos - Atención por Médico"
attr(df$k914aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Preservativos - Atención por Médico"
attr(df$k915,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Implantes - Atención por Médico"
attr(df$k916,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Implantes - Atención por Médico"
attr(df$k917,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Implantes - Atención por Médico"
attr(df$k917aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Implantes - Atención por Médico"
attr(df$k913a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Vasectomía - Atención por Médico"
attr(df$k913b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Vasectomía - Atención por Médico"
attr(df$k913c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Vasectomía - Atención por Médico"
attr(df$k916a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Salpingectomía - Atención por Médico"
attr(df$k917a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Salpingectomía - Atención por Médico"
attr(df$k917aaa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Salpingectomía - Atención por Médico"
attr(df$k918a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anillo Vaginal - Atención por Médico"
attr(df$k919a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anillo Vaginal - Atención por Médico"
attr(df$k920a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anillo Vaginal - Atención por Médico"
attr(df$k920aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anillo Vaginal - Atención por Médico"
attr(df$k918b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Parche Transdérmico - Atención por Médico"
attr(df$k919b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Parche Transdérmico - Atención por Médico"
attr(df$k920b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Parche Transdérmico - Atención por Médico"
attr(df$k920bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Parche Transdérmico - Atención por Médico"
attr(df$k918,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Otros - Atención por Médico"
attr(df$k919,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Otros - Atención por Médico"
attr(df$k920,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Otros - Atención por Médico"
attr(df$k920aaa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Otros - Atención por Médico"
attr(df$k921,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Otros - Atención por Médico"
attr(df$k922,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Otros - Atención por Médico"
attr(df$k923,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Otros - Atención por Médico"
attr(df$k923aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Otros - Atención por Médico"
attr(df$k924,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k925,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k926,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k926aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k927,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k928,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k929,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k929aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Médico"
attr(df$k924t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) - Atención por Médico"
attr(df$k925t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) - Atención por Médico"
attr(df$k926t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) - Atención por Médico"
attr(df$k926tt,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) - Atención por Médico"
attr(df$k927t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) - Atención por Médico"
attr(df$k928t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) - Atención por Médico"
attr(df$k929t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) - Atención por Médico"
attr(df$k929tt,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) - Atención por Médico"
attr(df$k930,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k931,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k932,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k932aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Dispositivo Intrauterino (DIU) - Atención por Obstetriz"
attr(df$k933a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k934a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k935a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k935aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k936a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k937a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k938a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k938aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales Combinados - Atención por Obstetriz"
attr(df$k933b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k934b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k935b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k935bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k936b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k937b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k938b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k938bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales sólo progesterona - Atención por Obstetriz"
attr(df$k933c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k934c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k935c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k935cc,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anticonceptivo Oral de emergencia - Atención por Obstetriz"
attr(df$k936c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Anticonceptivos Orales de emergencia - Atención por Obstetriz"
attr(df$k937c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Anticonceptivos Orales de emergencia - Atención por Obstetriz"
attr(df$k938c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Anticonceptivos Orales de emergencia - Atención por Obstetriz"
attr(df$k938cc,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Anticonceptivos Orales de emergencia - Atención por Obstetriz"
attr(df$k939,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Inyectable - Atención por Obstetriz"
attr(df$k940,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Inyectable - Atención por Obstetriz"
attr(df$k941,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Inyectable - Atención por Obstetriz"
attr(df$k941aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Inyectable - Atención por Obstetriz"
attr(df$k942,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Inyectable - Atención por Obstetriz"
attr(df$k943,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Inyectable - Atención por Obstetriz"
attr(df$k944,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Inyectable - Atención por Obstetriz"
attr(df$k944aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Inyectable - Atención por Obstetriz"
attr(df$k945,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Preservativos - Atención por Obstetriz"
attr(df$k946,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Preservativos - Atención por Obstetriz"
attr(df$k947,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Preservativos - Atención por Obstetriz"
attr(df$k947aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Preservativos - Atención por Obstetriz"
attr(df$k948,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Preservativos - Atención por Obstetriz"
attr(df$k949,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Preservativos - Atención por Obstetriz"
attr(df$k950,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Preservativos - Atención por Obstetriz"
attr(df$k950aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Preservativos - Atención por Obstetriz"
attr(df$k951,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Implantes - Atención por Obstetriz"
attr(df$k952,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Implantes - Atención por Obstetriz"
attr(df$k953,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Implantes - Atención por Obstetriz"
attr(df$k953aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Implantes - Atención por Obstetriz"
attr(df$k955a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Salpingectomía - Atención por Obstetriz"
attr(df$k956a,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Salpingectomía - Atención por Obstetriz"
attr(df$k956aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Salpingectomía - Atención por Obstetriz"
attr(df$k954b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k955b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k956b,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Anillo Vaginal - Atención por Obstetriz"
attr(df$k956bb,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Anillo Vaginal - Atención por Obstetriz"
attr(df$k954c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Parche Trandérmico - Atención por Obstetriz"
attr(df$k955c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Parche Trandérmico - Atención por Obstetriz"
attr(df$k956c,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Parche Trandérmico - Atención por Obstetriz"
attr(df$k956cc,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Parche Trandérmico - Atención por Obstetriz"
attr(df$k954,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Otros - Atención por Obstetriz"
attr(df$k955,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Otros - Atención por Obstetriz"
attr(df$k956,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Otros - Atención por Obstetriz"
attr(df$k956aaa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Otros - Atención por Obstetriz"
attr(df$k957,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Otros - Atención por Obstetriz"
attr(df$k958,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Otros - Atención por Obstetriz"
attr(df$k959,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Otros - Atención por Obstetriz"
attr(df$k959aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Otros - Atención por Obstetriz"
attr(df$k960,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k961,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k962,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k962aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k963,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k964,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k965,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k965aa,"label") <- "BLOQUE(4) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada) Total: Si no dispone por metodos de planificación desglosados - Atención por Obstetriz"
attr(df$k966t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años)"
attr(df$k967t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años)"
attr(df$k968t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años)"
attr(df$k968tt,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada)"
attr(df$k969t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años)"
attr(df$k970t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años)"
attr(df$k971t,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años)"
attr(df$k971tt,"label") <- "BLOQUE(4) TOTAL (USO INEC) Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada)"
attr(df$k966,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 10-19 años)"
attr(df$k967,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 20-49 años)"
attr(df$k968,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres 50 y más años)"
attr(df$k968aa,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Mujeres edad no especificada)"
attr(df$k969,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 10-19 años)"
attr(df$k970,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 20-49 años)"
attr(df$k971,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres 50 y más años)"
attr(df$k971aa,"label") <- "BLOQUE(4) USO INEC (Planificación Subsecuentes) Total Consultas subsecuentes ambulatorias anuales de prevención Planificación Familiar (Hombres edad no especificada)"
attr(df$k972,"label") <- "BLOQUE(5) Número de Visitas Domiciliarias Realizadas (Por Médico, Obstetriz y Enfermera)"
attr(df$k973,"label") <- "BLOQUE(5) Número de Certificados Medicos Otorgados"
attr(df$k974,"label") <- "BLOQUE(5) Número de Urgencias"
attr(df$k975,"label") <- "BLOQUE(5) Servicio de emergencia - Número de Atenciones (urgencias)"
attr(df$k976,"label") <- "BLOQUE(5) Servicio de emergencia - Número de Ingresos / emergencias"
attr(df$k977,"label") <- "BLOQUE(5) Servicio de emergencia - Total de Atenciones e ingresos"
attr(df$k977c,"label") <- "BLOQUE(5) Servicio de Intervención quirúrgica - Número de intervenciones quirúrgicas en el servicio de hospitalización"
attr(df$k978,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo computador completo pc/computador portátil"
attr(df$k979,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo odontológico portátil"
attr(df$k980,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo compresor de odontología"
attr(df$k981,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo esterilizador y/o autoclave"
attr(df$k982,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo ultrasonido(cavitrón)"
attr(df$k983,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo taburete giratorio dental"
attr(df$k984,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo instrumental para operatoria dental"
attr(df$k985,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo negatoscopio"
attr(df$k986,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo instrumental de cirugía dental"
attr(df$k987,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo instrumental de diagnóstico dental"
attr(df$k988,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo instrumental de profilaxís dental"
attr(df$k989,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología set de desechos"
attr(df$k990,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología fregadero mas escurridor"
attr(df$k991,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología equipo rayos x de odontología"
attr(df$k992a,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología Micromotor"
attr(df$k992b,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología Turbina"
attr(df$k992c,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología lámpara halógena"
attr(df$k992d,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología sillón dental"
attr(df$k992,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología otros (especifique)"
attr(df$k993,"label") <- "BLOQUE(6) USO INEC (Equipo) Total equipo"
attr(df$k994,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal total odontólogos generales"
attr(df$k995,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos generales 8 horas"
attr(df$k996,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos generales 6 horas"
attr(df$k997,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos generales 4 horas"
attr(df$k998,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos generales eventual o de llamada y menos de 4 horas diarias"
attr(df$k999,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total odontólogos rurales"
attr(df$k1000,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos rurales 8 horas"
attr(df$k1001,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos rurales 6 horas"
attr(df$k1002,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos rurales 4 horas"
attr(df$k1003,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontológos rurales eventual o de llamada y menos de 4 horas diarias"
attr(df$k1004,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total cirujanos maxilofaciales"
attr(df$k1005,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal cirujanos maxilofaciales 8 horas"
attr(df$k1006,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal cirujanos maxilofaciales 6 horas"
attr(df$k1007,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal cirujanos maxilofaciales 4 horas"
attr(df$k1008,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal cirujanos maxilofaciales eventual o de llamada y menos de 4 horas diarias"
attr(df$k1009,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total implantólogos"
attr(df$k1010,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal implantólogos 8 horas"
attr(df$k1011,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal implantólogos 6 horas"
attr(df$k1012,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal implantólogos 4 horas"
attr(df$k1013,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal implantólogos eventual o de llamada y menos de 4 horas diarias"
attr(df$k1014,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total odontopediatras"
attr(df$k1015,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontopediatras 8 horas"
attr(df$k1016,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontopediatras 6 horas"
attr(df$k1017,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontopediatras 4 horas"
attr(df$k1018,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal odontopediatras eventual o de llamada y menos de 4 horas diarias"
attr(df$k1019,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total endodoncistas"
attr(df$k1020,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal endodoncistas 8 horas"
attr(df$k1021,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal endodoncistas 6 horas"
attr(df$k1022,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal endodoncistas 4 horas"
attr(df$k1023,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal endodoncistas eventual o de llamada y menos de 4 horas diarias"
attr(df$k1024,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total periodoncistas"
attr(df$k1025,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal periodoncistas 8 horas"
attr(df$k1026,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal periodoncistas 6 horas"
attr(df$k1027,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal periodoncistas 4 horas"
attr(df$k1028,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal periodoncistas eventual o de llamada y menos de 4 horas diarias"
attr(df$k1029,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total ortodoncistas"
attr(df$k1030,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal ortodoncistas 8 horas"
attr(df$k1031,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal ortodoncistas 6 horas"
attr(df$k1032,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal ortodoncistas 4 horas"
attr(df$k1033,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal ortodoncistas eventual o de llamada y menos de 4 horas diarias"
attr(df$k1034,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total rehabilitadores orales"
attr(df$k1035,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal rehabilitadores orales 8 horas"
attr(df$k1036,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal rehabilitadores orales 6 horas"
attr(df$k1037,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal rehabilitadores orales 4 horas"
attr(df$k1038,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal rehabilitadores orales eventual o de llamada y menos de 4 horas diarias"
attr(df$k1039,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total asistentes dentales"
attr(df$k1040,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal asistentes dentales 8 horas"
attr(df$k1041,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal asistentes dentales 6 horas"
attr(df$k1042,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal asistentes dentales 4 horas"
attr(df$k1043,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal asistentes dentales eventual o de llamada y menos de 4 horas diarias"
attr(df$k1044,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total auxiliar de odontología"
attr(df$k1045,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal auxiliar odontología 8 horas"
attr(df$k1046,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal auxiliar odontología 6 horas"
attr(df$k1047,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal auxiliar odontología 4 horas"
attr(df$k1048,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal auxiliar odontología eventual o de llamada y menos de 4 horas diarias"
attr(df$k1049,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total mecánico dental"
attr(df$k1050,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal mecánico dental 8 horas"
attr(df$k1051,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal mecánico dental 6 horas"
attr(df$k1052,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal mecánico dental 4 horas"
attr(df$k1053,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal mecánico dental eventual o de llamada y menos de 4 horas diarias"
attr(df$k1054,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total exodoncista"
attr(df$k1055,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal exodoncista 8 horas"
attr(df$k1056,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal exodoncista 6 horas"
attr(df$k1057,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal exodoncista 4 horas"
attr(df$k1058,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal exodoncista eventual o de llamada y menos de 4 horas diarias"
attr(df$k1059,"label") <- "BLOQUE(6) Total Servicio de estomatología y/o odontología personal total otros (especifique)"
attr(df$k1060,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal otros (especifique) 8 horas"
attr(df$k1061,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal otros (especifique) 6 horas"
attr(df$k1062,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal otros (especifique) 4 horas"
attr(df$k1063,"label") <- "BLOQUE(6) Servicio de estomatología y/o odontología personal otros (especifique) eventual o de llamada y menos de 4 horas diarias"
attr(df$k1064,"label") <- "BLOQUE(6) USO INEC (Personal Estomatología) Total Personal"
attr(df$k1065,"label") <- "BLOQUE(6) USO INEC (Personal Estomatología) Total Personal 8 horas diarias"
attr(df$k1066,"label") <- "BLOQUE(6) USO INEC (Personal Estomatología) Total Personal 6 horas diarias"
attr(df$k1067,"label") <- "BLOQUE(6) USO INEC (Personal Estomatología) Total Personal 4 horas diarias"
attr(df$k1068,"label") <- "BLOQUE(6) USO INEC (Personal Estomatología) Total Personal Eventual o de llamada y menos de 4 horas diarias"
attr(df$k1069,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología en menores de 1 año"
attr(df$k1070,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología en menores de 1 año"
attr(df$k1071,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología en menores de 1 año"
attr(df$k1072,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 1-4 años"
attr(df$k1073,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 1-4 años"
attr(df$k1074,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 1-4 años"
attr(df$k1075,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 5-9 años programados"
attr(df$k1076,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 5-9 años programados"
attr(df$k1077,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 5-9 años programados"
attr(df$k1078,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 10-14 años programados"
attr(df$k1079,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 10-14 años programados"
attr(df$k1080,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 10-14 años programados"
attr(df$k1081,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 5-14 años no programados"
attr(df$k1082,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 5-14 años no programados"
attr(df$k1083,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 5-14 años no programados"
attr(df$k1084,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 15-19 años"
attr(df$k1085,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 15-19 años"
attr(df$k1086,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 15-19 años"
attr(df$k1087,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 20-35 años"
attr(df$k1088,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 20-35 años"
attr(df$k1089,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 20-35 años"
attr(df$k1090,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 36-49 años"
attr(df$k1091,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 36-49 años"
attr(df$k1092,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 36-49 años"
attr(df$k1093,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 50-64 años"
attr(df$k1094,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 50-64 años"
attr(df$k1095,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 50-64 años"
attr(df$k1096,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología de 65 años y más"
attr(df$k1097,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología de 65 años y más"
attr(df$k1098,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología de 65 años y más"
attr(df$k1099,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología embarazadas"
attr(df$k1100,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología embarazadas"
attr(df$k1101,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología embarazadas"
attr(df$k1102a,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología edad no especificada"
attr(df$k1103a,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología edad no especificada"
attr(df$k1104a,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología edad no especificada"
attr(df$k1102,"label") <- "BLOQUE(6) Consultas de morbilidad de estomatología y/o odontología Total: Si no dispone por grupos programáticos desglosados"
attr(df$k1103,"label") <- "BLOQUE(6) Consultas primeras de prevención de estomatología y/o odontología Total: Si no dispone por grupos programáticos desglosados"
attr(df$k1104,"label") <- "BLOQUE(6) Consultas subsecuentes de prevención de estomatología y/o odontología Total: Si no dispone por grupos programáticos desglosados"
attr(df$k1105,"label") <- "BLOQUE(6) USO INEC (Morbilidad Prevención Estomatología) Total consultas de estomatología y/o odontología morbilidad"
attr(df$k1106,"label") <- "BLOQUE(6) USO INEC (Morbilidad Prevención Estomatología) Total consultas de estomatología y/o odontología prevención primeras"
attr(df$k1107,"label") <- "BLOQUE(6) USO INEC (Morbilidad Prevención Estomatología) Total consultas de estomatología y/o odontología prevención subsecuentes"
attr(df$k1108,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - obturación"
attr(df$k1109,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - restauración"
attr(df$k1110,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - endodoncias"
attr(df$k1111,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - exodoncias"
attr(df$k1112,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - periodoncias"
attr(df$k1113,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - cirugia menor"
attr(df$k1114,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - ortodoncia/ortopedia"
attr(df$k1114a,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de morbilidad - Total: Si no dispone de las actividades desagregadas"
attr(df$k1115,"label") <- "BLOQUE(6) USO INEC (Actividades de morbilidad Estomatología) Total actividades de morbilidad"
attr(df$k1116,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de prevención - profilaxis"
attr(df$k1117,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de prevención - aplicación de fluor"
attr(df$k1118,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología - Actividades de prevención - sellantes"
attr(df$k1118a,"label") <- "BLOQUE(6) Actividades de estomatología y/o odontología  - Actividades de prevención - Total: Si no dispone de las actividades desagregadas"
attr(df$k1119,"label") <- "BLOQUE(6) USO INEC (Actividades de morbilidad Estomatología) Total actividades de prevención"
attr(df$k1120,"label") <- "BLOQUE(6) Número de radiografías dentales"
attr(df$k1121,"label") <- "BLOQUE(6) Número de certificados odontológicos"
attr(df$k1121a,"label") <- "BLOQUE(6) USO INEC (Radiografías y certificados) Total radiografías y certificados"
attr(df$klcl,"label") <- "Laboratorio Clínico"
attr(df$klhs,"label") <- "Laboratorio Histopatológico"
attr(df$kotl,"label") <- "Otros Laboratorios"
attr(df$k1122,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio flebotomía"
attr(df$k1123,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio flebotomía consulta externa"
attr(df$k1124,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio flebotomía hospitalización"
attr(df$k1125,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio flebotomía emergencia"
attr(df$k1126,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hematología"
attr(df$k1127,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hematología consulta externa"
attr(df$k1128,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hematología hospitalización"
attr(df$k1129,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hematología emergencia"
attr(df$k1130,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio quimica sanguínea"
attr(df$k1131,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio quimica sanguínea consulta externa"
attr(df$k1132,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio quimica sanguínea hospitalización"
attr(df$k1133,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio quimica sanguínea emergencia"
attr(df$k1134,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio inmunología"
attr(df$k1135,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio inmunología consulta externa"
attr(df$k1136,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio inmunología hospitalización"
attr(df$k1137,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio inmunología emergencia"
attr(df$k1138,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio uroanálisis"
attr(df$k1139,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio uroanálisis consulta externa"
attr(df$k1140,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio uroanálisis hospitalización"
attr(df$k1141,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio uroanálisis emergencia"
attr(df$k1142,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio coproanálisis"
attr(df$k1143,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio coproanálisis consulta externa"
attr(df$k1144,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio coproanálisis hospitalización"
attr(df$k1145,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio coproanálisis emergencia"
attr(df$k1146,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio microbiología"
attr(df$k1147,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio microbiología consulta externa"
attr(df$k1148,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio microbiología hospitalización"
attr(df$k1149,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio microbiología emergencia"
attr(df$k1150,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio serología"
attr(df$k1151,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio serología consulta externa"
attr(df$k1152,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio serología hospitalización"
attr(df$k1153,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio serología emergencia"
attr(df$k1154,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hormonas"
attr(df$k1155,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hormonas consulta externa"
attr(df$k1156,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hormonas hospitalización"
attr(df$k1157,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio hormonas emergencia"
attr(df$k1158,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio tuberculosis"
attr(df$k1159,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio tuberculosis consulta externa"
attr(df$k1160,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio tuberculosis hospitalización"
attr(df$k1161,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio tuberculosis emergencia"
attr(df$k1162,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio biología molecular"
attr(df$k1163,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio biología molecular consulta externa"
attr(df$k1164,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio biología molecular hospitalización"
attr(df$k1165,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio biología molecular emergencia"
attr(df$k1166,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio toxicología"
attr(df$k1167,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio toxicología consulta externa"
attr(df$k1168,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio toxicología hospitalización"
attr(df$k1169,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio toxicología emergencia"
attr(df$k1170,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio genética"
attr(df$k1171,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio genética consulta externa"
attr(df$k1172,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio genética hospitalización"
attr(df$k1173,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio genética emergencia"
attr(df$k1174a,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH postivas"
attr(df$k1175a,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH postivas consulta externa"
attr(df$k1176a,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH postivas Hospitalizacion"
attr(df$k1177a,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH postivas emergencia"
attr(df$k1174b,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH negativas"
attr(df$k1175b,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH negativas consulta externa"
attr(df$k1176b,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH negativas Hospitalizacion"
attr(df$k1177b,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas VIH negativas emergencia"
attr(df$k1174c,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID negativas"
attr(df$k1175c,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID negativas consulta externa"
attr(df$k1176c,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID negativas Hospitalizacion"
attr(df$k1177c,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID negativas emergencia"
attr(df$k1174d,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID positivas"
attr(df$k1175d,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID positivas consulta externa"
attr(df$k1176d,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID positivas Hospitalizacion"
attr(df$k1177d,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio pruebas COVID positivas emergencia"
attr(df$k1174,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio otros (especifique)"
attr(df$k1175,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio otros (especifique) consulta externa"
attr(df$k1176,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio otros (especifique) hospitalización"
attr(df$k1177,"label") <- "BLOQUE(7) Número de determinaciones de laboratorio otros (especifique) emergencia"
attr(df$k1178,"label") <- "BLOQUE(7) USO INEC (Laboratorio) Total de determinaciones de laboratorio "
attr(df$k1179,"label") <- "BLOQUE(7) USO INEC (Laboratorio) Total de determinaciones de laboratorio consulta externa"
attr(df$k1180,"label") <- "BLOQUE(7) USO INEC (Laboratorio) Total de determinaciones de laboratorio hospitalización"
attr(df$k1181,"label") <- "BLOQUE(7) USO INEC (Laboratorio) Total de determinaciones de laboratorio emergencia"
attr(df$k1182,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica exámenes histopatológicos"
attr(df$k1183,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica exámenes histopatológicos consulta externa"
attr(df$k1184,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica exámenes histopatológicos hospitalización"
attr(df$k1185,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica citológicos"
attr(df$k1186,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica citológicos consulta externa"
attr(df$k1187,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica citológicos hospitalización"
attr(df$k1188,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica autopsias clínicas"
attr(df$k1189,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica autopsias clínicas hospitalización"
attr(df$k1190,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica otros(especifique)"
attr(df$k1191,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica otros(especifique) consulta externa"
attr(df$k1192,"label") <- "BLOQUE(7) Laboratorio de anatomía patológica otros(especifique) hospitalización"
attr(df$k1193,"label") <- "BLOQUE(7) USO INEC (ANATOMÍA Patológica) Total exámenes de anatomía patológica"
attr(df$k1194,"label") <- "BLOQUE(7) USO INEC (ANATOMÍA Patológica) Total exámenes de anatomía patológica consulta externa"
attr(df$k1195,"label") <- "BLOQUE(7) USO INEC (ANATOMÍA Patológica) Total exámenes de anatomía patológica hospitalización"
attr(df$kfar,"label") <- "Farmacia"
attr(df$kbotq,"label") <- "Botiquín (NO de Primeros Auxilios NO muestras médicas)"
attr(df$kbcosan,"label") <- "Banco de Sangre"
attr(df$kbcolec,"label") <- "Banco de Leche Materna"
attr(df$k1196,"label") <- "BLOQUE(8) Número de recetas despachadas consulta externa"
attr(df$k1197,"label") <- "BLOQUE(8) Número de recetas despachadas hospitalización"
attr(df$k1198,"label") <- "BLOQUE(8) Número de recetas despachadas emergencia"
attr(df$k1199,"label") <- "BLOQUE(8) USO INEC (Recetas despachadas) Total recetas despachadas"
attr(df$k1200,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Rayos X (Fijo)"
attr(df$k1201,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Rayos X (Portátil)"
attr(df$k1201aa,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Arco en C (Fijo o Portátil)"
attr(df$k1202,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Tomógrafos"
attr(df$k1203,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Ecógrafos (convencional o portátil)"
attr(df$k1273,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Ecógrafo doppler color"
attr(df$k1204,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Fluoroscopios"
attr(df$k1205,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Mamógrafos"
attr(df$k1206,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Resonancia Magnética"
attr(df$k1206b,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Desintómetros"
attr(df$k1207,"label") <- "BLOQUE(9) Servicio de imagenología Número de Equipos Otros (especifique)"
attr(df$k1208,"label") <- "BLOQUE(9) USO INEC (Equipos Imagenología) Total Equipos"
attr(df$k1209,"label") <- "BLOQUE(9) Número de exámenes rayos x para diagnóstico médico fijo y portatil"
attr(df$k1210,"label") <- "BLOQUE(9) Número de exámenes rayos x para diagnóstico médico fijo y portatil consulta externa"
attr(df$k1211,"label") <- "BLOQUE(9) Número de exámenes rayos x para diagnóstico médico fijo y portatil hospitalización"
attr(df$k1212,"label") <- "BLOQUE(9) Número de exámenes rayos x para diagnóstico médico fijo y portatil emergencia"
attr(df$k1213,"label") <- "BLOQUE(9) Número de exámenes ecografías convencionales"
attr(df$k1214,"label") <- "BLOQUE(9) Número de exámenes ecografías convencionales consulta externa"
attr(df$k1215,"label") <- "BLOQUE(9) Número de exámenes ecografías convencionales hospitalización"
attr(df$k1216,"label") <- "BLOQUE(9) Número de exámenes ecografías convencionales emergencia"
attr(df$k1217,"label") <- "BLOQUE(9) Número de exámenes fluoroscopía"
attr(df$k1218,"label") <- "BLOQUE(9) Número de exámenes fluoroscopía consulta externa"
attr(df$k1219,"label") <- "BLOQUE(9) Número de exámenes fluoroscopía hospitalización"
attr(df$k1220,"label") <- "BLOQUE(9) Número de exámenes fluoroscopía emergencia"
attr(df$k1221,"label") <- "BLOQUE(9) Número de exámenes tomografía axial computarizada"
attr(df$k1222,"label") <- "BLOQUE(9) Número de exámenes tomografía axial computarizada consulta externa"
attr(df$k1223,"label") <- "BLOQUE(9) Número de exámenes tomografía axial computarizada hospitalización"
attr(df$k1224,"label") <- "BLOQUE(9) Número de exámenes tomografía axial computarizada emergencia"
attr(df$k1225,"label") <- "BLOQUE(9) Número de exámenes mamografías"
attr(df$k1226,"label") <- "BLOQUE(9) Número de exámenes mamografías consulta externa"
attr(df$k1227,"label") <- "BLOQUE(9) Número de exámenes mamografías hospitalización"
attr(df$k1228,"label") <- "BLOQUE(9) Número de exámenes mamografías emergencia"
attr(df$k1229,"label") <- "BLOQUE(9) Número de exámenes radiología especial con intensificador de imagen"
attr(df$k1230,"label") <- "BLOQUE(9) Número de exámenes radiología especial con intensificador de imagen consulta externa"
attr(df$k1231,"label") <- "BLOQUE(9) Número de exámenes radiología especial con intensificador de imagen hospitalización"
attr(df$k1232,"label") <- "BLOQUE(9) Número de exámenes radiología especial con intensificador de imagen emergencia"
attr(df$k1233,"label") <- "BLOQUE(9) Número de exámenes desintometría osea"
attr(df$k1234,"label") <- "BLOQUE(9) Número de exámenes desintometría osea consulta externa"
attr(df$k1235,"label") <- "BLOQUE(9) Número de exámenes desintometría osea hospitalización"
attr(df$k1236,"label") <- "BLOQUE(9) Número de exámenes desintometría osea emergencia"
attr(df$k1237,"label") <- "BLOQUE(9) Número de exámenes resonancia magnética nuclear e intervencionismo"
attr(df$k1238,"label") <- "BLOQUE(9) Número de exámenes resonancia magnética nuclear e intervencionismo consulta externa"
attr(df$k1239,"label") <- "BLOQUE(9) Número de exámenes resonancia magnética nuclear e intervencionismo hospitalización"
attr(df$k1240,"label") <- "BLOQUE(9) Número de exámenes resonancia magnética nuclear e intervencionismo emergencia"
attr(df$k1241,"label") <- "BLOQUE(9) Número de exámenes radiología computada y digital para diagnóstico medico fijo y portatil  y telemando digital"
attr(df$k1242,"label") <- "BLOQUE(9) Número de exámenes radiología computada y digital para diagnóstico medico fijo y portatil  y telemando digital consulta externa"
attr(df$k1243,"label") <- "BLOQUE(9) Número de exámenes radiología computada y digital para diagnóstico medico fijo y portatil  y telemando digital hospitalización"
attr(df$k1244,"label") <- "BLOQUE(9) Número de exámenes radiología computada y digital para diagnóstico medico fijo y portatil  y telemando digital emergencia"
attr(df$k1245,"label") <- "BLOQUE(9) Número de exámenes tomografía multicorte de 16 en adelante"
attr(df$k1246,"label") <- "BLOQUE(9) Número de exámenes tomografía multicorte de 16 en adelante consulta externa"
attr(df$k1247,"label") <- "BLOQUE(9) Número de exámenes tomografía multicorte de 16 en adelante hospitalización"
attr(df$k1248,"label") <- "BLOQUE(9) Número de exámenes tomografía multicorte de 16 en adelante emergencia"
attr(df$k1249,"label") <- "BLOQUE(9) Número de exámenes mamografía digitalizada"
attr(df$k1250,"label") <- "BLOQUE(9) Número de exámenes mamografía digitalizada consulta externa"
attr(df$k1251,"label") <- "BLOQUE(9) Número de exámenes mamografía digitalizada hospitalizada"
attr(df$k1252,"label") <- "BLOQUE(9) Número de exámenes mamografía digitalizada emergencia"
attr(df$k1253,"label") <- "BLOQUE(9) Número de exámenes ecografía especializada"
attr(df$k1254,"label") <- "BLOQUE(9) Número de exámenes ecografía especializada consulta externa"
attr(df$k1255,"label") <- "BLOQUE(9) Número de exámenes ecografía especializada hospitalización"
attr(df$k1256,"label") <- "BLOQUE(9) Número de exámenes ecografía especializada emergencia"
attr(df$k1257,"label") <- "BLOQUE(9) Número de exámenes otros (especifique)"
attr(df$k1258,"label") <- "BLOQUE(9) Número de exámenes otros (especifique) consulta externa"
attr(df$k1259,"label") <- "BLOQUE(9) Número de exámenes otros (especifique) hospitalización"
attr(df$k1260,"label") <- "BLOQUE(9) Número de exámenes otros (especifique) emergencia"
attr(df$k1261,"label") <- "BLOQUE(9) USO INEC (Exámenes de imagenología) Total de exámenes"
attr(df$k1262,"label") <- "BLOQUE(9) USO INEC (Exámenes de imagenología) Total de exámenes consulta externa"
attr(df$k1263,"label") <- "BLOQUE(9) USO INEC (Exámenes de imagenología) Total de exámenes hospitalización"
attr(df$k1264,"label") <- "BLOQUE(9) USO INEC (Exámenes de imagenología) Total de exámenes emergencia"
attr(df$k1265,"label") <- "BLOQUE(10) Equipo de Diagnótico Electroencefalógrafo"
attr(df$k1266,"label") <- "BLOQUE(10) Equipo de Diagnótico Electro Cardiógrafo"
attr(df$k1267,"label") <- "BLOQUE(10) Equipo de Diagnótico Ecocardiógrafo"
attr(df$k1268,"label") <- "BLOQUE(10) Equipo de Diagnótico Angiógrafo"
attr(df$k1269,"label") <- "BLOQUE(10) Equipo de Diagnótico Espirómetro"
attr(df$k1270,"label") <- "BLOQUE(10) Equipo de Diagnótico Ergonómetro"
attr(df$k1271,"label") <- "BLOQUE(10) Equipo de Diagnótico Endoscopio"
attr(df$k1272,"label") <- "BLOQUE(10) Equipo de Diagnótico Colonoscopio"
attr(df$k1274,"label") <- "BLOQUE(10) Equipo de Diagnótico Audiómetros"
attr(df$k1275,"label") <- "BLOQUE(10) Equipo de Diagnótico Electromiógrafo"
attr(df$k1276,"label") <- "BLOQUE(10) Equipo de Diagnótico Gamma-Cámara"
attr(df$k1277,"label") <- "BLOQUE(10) Equipo de Diagnótico Otros (especifique)"
attr(df$k1278,"label") <- "BLOQUE(10) USO INEC (Equipo de Diagnóstico) Total Equipos de Diagnótico"
attr(df$k1279,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctroencefalogramas"
attr(df$k1280,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctroencefalogramas consulta externa"
attr(df$k1281,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctroencefalogramas hospitalización"
attr(df$k1282,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctroencefalogramas emergencia"
attr(df$k1283,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctrocardiogramas"
attr(df$k1284,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctrocardiogramas consulta externa"
attr(df$k1285,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctrocardiogramas hospitalización"
attr(df$k1286,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico eléctrocardiogramas emergencia"
attr(df$k1287,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ecocardiogramas"
attr(df$k1288,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ecocardiogramas consulta externa"
attr(df$k1289,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ecocardiogramas hospitalización"
attr(df$k1290,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ecocardiogramas emergencia"
attr(df$k1291,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico angiografías"
attr(df$k1292,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico angiografías consulta externa"
attr(df$k1293,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico angiografías hospitalización"
attr(df$k1294,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico angiografías emergencia"
attr(df$k1295,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico espirometrías"
attr(df$k1296,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico espirometrías consulta externa"
attr(df$k1297,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico espirometrías hospitalización"
attr(df$k1298,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico espirometrías emergencia"
attr(df$k1299,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ergonometrías"
attr(df$k1300,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ergonometrías consulta externa"
attr(df$k1301,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ergonometrías hospitalización"
attr(df$k1302,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico ergonometrías emergencia"
attr(df$k1303,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico endoscopias"
attr(df$k1304,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico endoscopias consulta externa"
attr(df$k1305,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico endoscopias hospitalización"
attr(df$k1306,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico endoscopias emergencia"
attr(df$k1307,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico colonoscopias"
attr(df$k1308,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico colonoscopias consulta externa"
attr(df$k1309,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico colonoscopias hospitalización"
attr(df$k1310,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico colonoscopias emergencia"
attr(df$k1315,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico audiometrías"
attr(df$k1316,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico audiometrías consulta externa"
attr(df$k1317,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico audiometrías hospitalización"
attr(df$k1318,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico audiometrías emergencia"
attr(df$k1319,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico electromiogramas"
attr(df$k1320,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico electromiogramas consulta externa"
attr(df$k1321,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico electromiogramas hospitalización"
attr(df$k1322,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico electromiogramas emergencia"
attr(df$k1323,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía tiroidea"
attr(df$k1324,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía tiroidea consulta externa"
attr(df$k1325,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía tiroidea hospitalización"
attr(df$k1326,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía ósea"
attr(df$k1327,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía ósea consulta externa"
attr(df$k1328,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía ósea hospitalización"
attr(df$k1329,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía renal"
attr(df$k1330,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía renal consulta externa"
attr(df$k1331,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía renal hospitalización"
attr(df$k1332,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía de otros órganos"
attr(df$k1333,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía de otros órganos consulta externa"
attr(df$k1334,"label") <- "BLOQUE(12) Número de pruebas de diagnóstico gammagrafía de otros órganos hospitalización"
attr(df$k1335,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico otros (especifique)"
attr(df$k1336,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico otros (especifique) consulta externa"
attr(df$k1337,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico otros (especifique) hospitalización"
attr(df$k1338,"label") <- "BLOQUE(10) Número de pruebas de diagnóstico otros (especifique) emergencia"
attr(df$k1339,"label") <- "BLOQUE(10) USO INEC (Pruebas de diagnóstico) Total pruebas de diagnóstico"
attr(df$k1340,"label") <- "BLOQUE(10) USO INEC (Pruebas de diagnóstico) Total pruebas de diagnóstico consulta externa"
attr(df$k1341,"label") <- "BLOQUE(10) USO INEC (Pruebas de diagnóstico) Total pruebas de diagnóstico hospitalización"
attr(df$k1342,"label") <- "BLOQUE(10) USO INEC (Pruebas de diagnóstico) Total pruebas de diagnóstico emergencia"
attr(df$k1343,"label") <- "BLOQUE(11) Equipos de Tratamiento Fisioterapia"
attr(df$k1344,"label") <- "BLOQUE(11) Equipos de tratamiento electroshock"
attr(df$k1344c,"label") <- "BLOQUE(11) Equipos de tratamiento equipo para eléctroterapia"
attr(df$k1345,"label") <- "BLOQUE(11) Equipos de Tratamiento Equipo de Diálisis"
attr(df$k1346,"label") <- "BLOQUE(11) Equipos de tratamiento equipo de litotriptor"
attr(df$k1346d,"label") <- "BLOQUE(11) Equipos de tratamiento equipo para quimioterapia"
attr(df$k1347,"label") <- "BLOQUE(11) USO INEC (Equipo de tratamiento) Total Equipos de Tratamiento"
attr(df$k1348,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - electroterapia"
attr(df$k1349,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - electroterapia consulta externa"
attr(df$k1350,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - electroterapia hospitalización"
attr(df$k1351,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - hidroterapia"
attr(df$k1352,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - hidroterapia consulta externa"
attr(df$k1353,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - hidroterapia hospitalización"
attr(df$k1354,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - ejercicios terapeúticos"
attr(df$k1355,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - ejercicios terapeúticos consulta externa"
attr(df$k1356,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - ejercicios terapeúticos hospitalización"
attr(df$k1357,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - parafina"
attr(df$k1358,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - parafina consulta externa"
attr(df$k1359,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - parafina hospitalización"
attr(df$k1360,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - compresas químicas"
attr(df$k1361,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - compresas químicas consulta externa"
attr(df$k1362,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - compresas químicas hospitalización"
attr(df$k1363,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - termoterapia"
attr(df$k1363a,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - litotricia"
attr(df$k1364a,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - litotricia consulta externa"
attr(df$k1365a,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - litotricia hospitalización"
attr(df$k1364,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - termoterapia consulta externa"
attr(df$k1365,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - termoterapia hospitalización"
attr(df$k1366,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - otros (especifique)"
attr(df$k1367,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - otros (especifique) consulta externa"
attr(df$k1368,"label") <- "BLOQUE(11) Número de tratamientos fisioterapia - otros (especifique) hospitalización"
attr(df$k1369,"label") <- "BLOQUE(11) USO INEC (Tratamientos Fisioterapia) Total de tratamientos Fisioterapia"
attr(df$k1370,"label") <- "BLOQUE(11) USO INEC (Tratamientos Fisioterapia) Total de tratamientos Fisioterapia consulta externa"
attr(df$k1371,"label") <- "BLOQUE(11) USO INEC (Tratamientos Fisioterapia) Total de tratamientos Fisioterapia hospitalización"
attr(df$k1372,"label") <- "BLOQUE(11) Número de Otros Tratamientos - Terapia del Lenguaje"
attr(df$k1373,"label") <- "BLOQUE(11) Número de Otros Tratamientos - Terapia Respiratoria"
attr(df$k1374,"label") <- "BLOQUE(11) Número de Otros Tratamientos - Terapia Ocupacional"
attr(df$k1375,"label") <- "BLOQUE(11) USO INEC  (Otros tratamientos) Total de Otros Tratamientos"
attr(df$k1376a,"label") <- "BLOQUE(11) Número de tratamientos de diálisis y hemodialisis"
attr(df$k1377a,"label") <- "BLOQUE(11) Número de tratamientos de diálisis y hemodialisis consulta externa"
attr(df$k1378a,"label") <- "BLOQUE(11) Número de tratamientos de diálisis y hemodialisis hospitalización"
attr(df$k1376b,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias"
attr(df$k1377b,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias consulta externa"
attr(df$k1378b,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias hospitalización"
attr(df$k1376bb,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias tópicos"
attr(df$k1377bb,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias tópicos consulta externa"
attr(df$k1378bb,"label") <- "BLOQUE(11) Número de tratamientos de quimioterapias tópicos hospitalización"
attr(df$k1376c,"label") <- "BLOQUE(11) Número de tratamientos de radioterapía"
attr(df$k1377c,"label") <- "BLOQUE(11) Número de tratamientos de radioterapía consulta externa"
attr(df$k1378c,"label") <- "BLOQUE(11) Número de tratamientos de radioterapía hospitalización"
attr(df$k1376e,"label") <- "BLOQUE(11) Número de diálisis y quimioterapia - otros (especifique)"
attr(df$k1377e,"label") <- "BLOQUE(11) Número de diálisis y quimioterapia - otros (especifique) consulta externa"
attr(df$k1378e,"label") <- "BLOQUE(11) Número de diálisis y quimioterapia - otros (especifique) hospitalización"
attr(df$k1376d,"label") <- "BLOQUE(11) Número de tratamientos de diálisis, hemodiaisis, quimioterapia y radioterapía otros (especifique)"
attr(df$k1377d,"label") <- "BLOQUE(11) Número de tratamientos de diálisis, hemodiaisis, quimioterapia y radioterapía otros (especifique) consulta externa"
attr(df$k1378d,"label") <- "BLOQUE(11) Número de tratamientos de diálisis, hemodiaisis, quimioterapia y radioterapía otros (especifique) hospitalización"
attr(df$k1376,"label") <- "BLOQUE(11) USO INEC (Tratamientos de diálisis y quimioterapia) Total de tratamientos de diálisis y quimioterapias"
attr(df$k1377,"label") <- "BLOQUE(11) USO INEC (Tratamientos de diálisis y quimioterapia) Total de tratamientos de diálisis y quimioterapias consulta externa"
attr(df$k1378,"label") <- "BLOQUE(11) USO INEC (Tratamientos de diálisis y quimioterapia) Total de tratamientos de diálisis y quimioterapias hospitalización"
attr(df$k1379,"label") <- "BLOQUE(12) Número Ambientes Físicos - Salas de Operaciones  (Quirófanos generales y de emergencia)"
attr(df$k1380,"label") <- "BLOQUE(12) Número Ambientes Físicos - Salas de Cuidados Intensivos"
attr(df$k1381,"label") <- "BLOQUE(12) Número Ambientes Físicos - Salas de Cuidados Intermedios"
attr(df$k1382,"label") <- "BLOQUE(12) Número Ambientes Físicos - Salas de Partos"
attr(df$k1383,"label") <- "BLOQUE(12) USO INEC (Ambientes Físicos) Total de Ambientes Fisicos"
attr(df$k1384,"label") <- "BLOQUE(12) Número de Equipos - Mesas de Operaciones"
attr(df$k1385,"label") <- "BLOQUE(12) Número de Equipos - Equipos de anestesia"
attr(df$k1386,"label") <- "BLOQUE(12) Número de Equipos - monitores"
attr(df$k1387,"label") <- "BLOQUE(12) Número de Equipos - electrobisturí"
attr(df$k1388,"label") <- "BLOQUE(12) Número de Equipos - electrocauterio"
attr(df$k1389,"label") <- "BLOQUE(12) Número de Equipos - lámpara cielítica"
attr(df$k1390,"label") <- "BLOQUE(12) Número de Equipos - coche de paro"
attr(df$k1391,"label") <- "BLOQUE(12) Número de Equipos - coche de cardioreanimación"
attr(df$k1392,"label") <- "BLOQUE(12) Número de Equipos - equipo de desfibrilación"
attr(df$k1393,"label") <- "BLOQUE(12) Número de Equipos - torre de laparoscopía"
attr(df$k1394,"label") <- "BLOQUE(12) Número de Equipos - equipo de laser"
attr(df$k1395,"label") <- "BLOQUE(12) Número de Equipos - respirador"
attr(df$k1396,"label") <- "BLOQUE(12) Número de Equipos - succionador"
attr(df$k1397,"label") <- "BLOQUE(12) Número de Equipos - mesas ginecológicas"
attr(df$k1398,"label") <- "BLOQUE(12) Número de Equipos - Cunas de Calor Radiante"
attr(df$k1399,"label") <- "BLOQUE(12) Número de Equipos - Termocunas"
attr(df$k1400,"label") <- "BLOQUE(12) Número de Equipos - Incubadoras Normales"
attr(df$k1401,"label") <- "BLOQUE(12) Número de Equipos - Incubadoras de Transporte"
attr(df$k1402,"label") <- "BLOQUE(12) Número de Equipos - otros (especifique)"
attr(df$k1403,"label") <- "BLOQUE(12) USO INEC (Equipos cirugía y Obstetricia) Total de Equipos"
attr(df$k1404,"label") <- "BLOQUE(12) Número de equipos de esterilización - esterilizador en seco"
attr(df$k1405,"label") <- "BLOQUE(12) Número de equipos de esterilización - autoclaves"
attr(df$k1406,"label") <- "BLOQUE(12) Número de equipos de esterilización - otros (especifique)"
attr(df$k1407,"label") <- "BLOQUE(12) USO INEC (Equipos de Esterilización) Total equipos de esterilización"
attr(df$k1408,"label") <- "BLOQUE(12) Número de otros equipos del establecimiento - Ambulancias"
attr(df$k1409,"label") <- "BLOQUE(12) Número de otros equipos del establecimiento - Vehículos de Transporte"
attr(df$k1410d,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Camas de recuperación"
attr(df$k1410e,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Camas de emergencia"
attr(df$k1410f,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Sillones (Quimioterapias, diálisis, Número de otros)"
attr(df$k1410g,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Camillas"
attr(df$k1410h,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Sillas para nebulizaciones"
attr(df$k1410i,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Balanzas de recién nacidos"
attr(df$k1410j,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Balanzas de pedestal"
attr(df$k1410k,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Tensiometros de pedestal"
attr(df$k1410l,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Tensiometros de pared"
attr(df$k1410m,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Fonendoscopio"
attr(df$k1410n,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Refrigeradoras (uso de medicamento)"
attr(df$k1410o,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Vaporizador"
attr(df$k1410p,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Tensiometro digital"
attr(df$k1410q,"label") <- "BLOQUE (12) Número de otros equipos del establecimiento - Shailon"
attr(df$k1410,"label") <- "BLOQUE(12) Número de otros equipos del establecimiento - otros (especifique)"
attr(df$k1411,"label") <- "BLOQUE(12) USO INEC (Otros Equipos) Total de otros equipos"
attr(df$k1412,"label") <- "BLOQUE(13) Número de actividades de vigilancia sanitaria - inspecciones a viviendas"
attr(df$k1413,"label") <- "BLOQUE(13) Número de actividades de vigilancia sanitaria - inspecciones a establecimientos educacionales"
attr(df$k1414,"label") <- "BLOQUE(13) Número de actividades de vigilancia sanitaria - inspecciones a establecimientos públicos en general"
attr(df$k1415,"label") <- "BLOQUE(13) Número de actividades de vigilancia sanitaria - inspecciones a establecimientos expendio de alimentos"
attr(df$k1416,"label") <- "BLOQUE(13) Número de actividades de vigilancia sanitaria - inspecciones a otros (especifique)"
attr(df$k1417,"label") <- "BLOQUE(13) USO INEC (Actividades de Vigilancia Sanitaria) Total de actividades vigilancia Sanitaria"
attr(df$k1418,"label") <- "BLOQUE(14) Número de actividades de trabajo social - entrevistas"
attr(df$k1419,"label") <- "BLOQUE(14) Número de actividades de trabajo social - visitas domiciliarias efectivas"
attr(df$k1420,"label") <- "BLOQUE(14) Número de actividades de trabajo social - visitas domiciliarias inefectivas"
attr(df$k1421,"label") <- "BLOQUE(14) Número de actividades de trabajo social - gestiones intra institucionales"
attr(df$k1422,"label") <- "BLOQUE(14) Número de actividades de trabajo social - gestiones extra institucionales"
attr(df$k1423,"label") <- "BLOQUE(14) Número de actividades de trabajo social - servicio social a la comunidad"
attr(df$k1424,"label") <- "BLOQUE(14) USO INEC (Actividades de Trabajo Social) Total de actividades de trabajo social"


df <- df %>%
  mutate(estcsi = if_else(
    ((clase >= "01" & clase <= "17") | (clase == "32")),
    "1",
    "2"
  )) %>%
  mutate(estcsi = factor(estcsi,
                         levels = c("1", "2"),
                         labels = c("Con Internación", "Sin Internación"),
                         ordered = TRUE))



# Generador de área_1  

df$area1 <- substr(df$parr_ubi, 5, 6)  

df$area2 <- NA  # Inicializar la variable area  

# Condiciones para asignar el área  

df$area2[df$area1 == '00'] <- 1  
df$area2[df$area1 >= '01' & df$area1 <= '50'] <- 1  
df$area2[df$area1 >= '51' & df$area1 <= '86'] <- 2  

# Etiquetado de variables

labelled::var_label(df$area1) <- "Parroquia"  
labelled::var_label(df$area2) <- "Área"  
df$area2 <- factor(df$area2, levels = c(1, 2), labels = c("Urbano", "Rural"))  

df$area <- factor(df$area,
                  levels = c(1,2),
                  labels = c("Urbano", "Rural")) 

# Recodificación de regiones  

df$region1 <- NA  # Inicializar la variable region  

df$region1[((df$prov_ubi >= "01" & df$prov_ubi <= "06") |   
              df$prov_ubi %in% c("10", "11", "17", "18", "23"))] <- 1  
df$region1[((df$prov_ubi >= "07" & df$prov_ubi <= "09") |   
              df$prov_ubi %in% c("12", "13", "24"))] <- 2  
df$region1[((df$prov_ubi >= "14" & df$prov_ubi <= "16") |   
              (df$prov_ubi >= "21" & df$prov_ubi <= "22") |   
              df$prov_ubi == "19")] <- 3  
df$region1[df$prov_ubi == "20"] <- 4  
df$region1[df$prov_ubi == "90"] <- 5  

# Etiquetado de la región

labelled::var_label(df$region1) <- "Región"  
df$region1 <- factor(df$region1, levels = c(1, 2, 3, 4, 5),   
                     labels = c("Región Sierra", "Región Costa",   
                                "Región Amazónica", "Región Insular",   
                                "Zonas No Delimitadas"))  

df$region <- factor(df$region,
                    levels = c(1,2,3,4,5),
                    labels = c("Región Sierra","Región Costa",
                               "Región Amazónica","Región Insular",
                               "Zonas no Delimitadas"))

# Categoría  DPA Provincias

df$prov_ubi = factor(df$prov_ubi,
                     levels = c("01", "02", "03", "04", "05", "06", "07", "08",   
                                "09", "10", "11", "12", "13", "14", "15", "16",   
                                "17", "18", "19", "20", "21", "22", "23", "24",   
                                "90"),   
                     labels = c("Azuay", "Bolívar", "Cañar", "Carchi", "Cotopaxi",   
                                "Chimborazo", "El Oro", "Esmeraldas", "Guayas",   
                                "Imbabura", "Loja", "Los Ríos", "Manabí",   
                                "Morona Santiago", "Napo", "Pastaza", "Pichincha",   
                                "Tungurahua", "Zamora Chinchipe", "Galápagos",   
                                "Sucumbíos", "Orellana", "Santo Domingo de los Tsáchilas",   
                                "Santa Elena", "Zona de estudio"),
                     ordered = FALSE)

# Categoría DPA Cantones

df$cant_ubi = factor(df$cant_ubi,
                     levels = c("0101", "0102", "0103", "0104", "0105", "0106", "0107", "0108", 
                                 "0109", "0110", "0111", "0112", "0113", "0114", "0115", "0201", 
                                 "0202", "0203", "0204", "0205", "0206", "0207", "0301", "0302", 
                                 "0303", "0304", "0305", "0306", "0307", "0401", "0402", "0403", 
                                 "0404", "0405", "0406", "0501", "0502", "0503", "0504", "0505", 
                                 "0506", "0507", "0601", "0602", "0603", "0604", "0605", "0606", 
                                 "0607", "0608", "0609", "0610", "0701", "0702", "0703", "0704", 
                                 "0705", "0706", "0707", "0708", "0709", "0710", "0711", "0712", 
                                 "0713", "0714", "0801", "0802", "0803", "0804", "0805", "0806", 
                                 "0807", "0901", "0902", "0903", "0904", "0905", "0906", "0907", 
                                 "0908", "0909", "0910", "0911", "0912", "0913", "0914", "0916", 
                                 "0918", "0919", "0920", "0921", "0922", "0923", "0924", "0925", 
                                 "0927", "0928", "1001", "1002", "1003", "1004", "1005", "1006", 
                                 "1101", "1102", "1103", "1104", "1105", "1106", "1107", "1108", 
                                 "1109", "1110", "1111", "1112", "1113", "1114", "1115", "1116", 
                                 "1201", "1202", "1203", "1204", "1205", "1206", "1207", "1208", 
                                 "1209", "1210", "1211", "1212", "1213", "1301", "1302", "1303", 
                                 "1304", "1305", "1306", "1307", "1308", "1309", "1310", "1311", 
                                 "1312", "1313", "1314", "1315", "1316", "1317", "1318", "1319", 
                                 "1320", "1321", "1322", "1401", "1402", "1403", "1404", "1405", 
                                 "1406", "1407", "1408", "1409", "1410", "1411", "1412", "1413", 
                                 "1501", "1503", "1504", "1507", "1509", "1601", "1602", "1603", 
                                 "1604", "1701", "1702", "1703", "1704", "1705", "1707", "1708", 
                                 "1709", "1801", "1802", "1803", "1804", "1805", "1806", "1807", 
                                 "1808", "1809", "1901", "1902", "1903", "1904", "1905", "1906", 
                                 "1907", "1908", "1909", "2001", "2002", "2003", "2101", "2102", 
                                 "2103", "2104", "2105", "2106", "2107", "2201", "2202", "2203", 
                                 "2204", "2301", "2302", "2401", "2402", "2403", "9006"),
                     labels = c("Cuenca", "Girón", "Gualaceo", "Nabón", "Paute", "Pucará", 
                                "San Fernando", "Santa Isabel", "Sígsig", "Oña", "Chordeleg", 
                                "El Pan", "Sevilla De Oro", "Guachapala", 
                                "Camilo Ponce Enríquez", "Guaranda", "Chillanes", "Chimbo", 
                                "Echeandía", "San Miguel", "Caluma", "Las Naves", "Azogues", 
                                "Biblián", "Cañar", "La Troncal", "El Tambo", "Déleg", "Suscal", 
                                "Tulcán", "Bolívar", "Espejo", "Mira", "Montúfar", 
                                "San Pedro De Huaca", "Latacunga", "La Maná", "Pangua", 
                                "Pujilí", "Salcedo", "Saquisilí", "Sigchos", "Riobamba", 
                                "Alausí", "Colta", "Chambo", "Chunchi", "Guamote", "Guano", 
                                "Pallatanga", "Penipe", "Cumandá", "Machala", "Arenillas", 
                                "Atahualpa", "Balsas", "Chilla", "El Guabo", "Huaquillas", 
                                "Marcabelí", "Pasaje", "Piñas", "Portovelo", "Santa Rosa", 
                                "Zaruma", "Las Lajas", "Esmeraldas", "Eloy Alfaro", "Muisne", 
                                "Quinindé", "San Lorenzo", "Atacames", "Rioverde", "Guayaquil", 
                                "Alfredo Baquerizo Moreno (Juján)", "Balao", "Balzar", 
                                "Colimes", "Daule", "Durán", "El Empalme", "El Triunfo", 
                                "Milagro", "Naranjal", "Naranjito", "Palestina", "Pedro Carbo", 
                                "Samborondón", "Santa Lucía", "Salitre", "San Jacinto De Yaguachi", 
                                "Playas", "Simón Bolívar", "Coronel Marcelino Maridueña", 
                                "Lomas De Sargentillo", "Nobol", "General Antonio Elizalde", 
                                "Isidro Ayora", "Ibarra", "Antonio Ante", "Cotacachi", 
                                "Otavalo", "Pimampiro", "San Miguel De Urcuquí", "Loja", 
                                "Calvas", "Catamayo", "Celica", "Chaguarpamba", "Espíndola", 
                                "Gonzanamá", "Macará", "Paltas", "Puyango", "Saraguro", 
                                "Sozoranga", "Zapotillo", "Pindal", "Quilanga", "Olmedo", 
                                "Babahoyo", "Baba", "Montalvo", "Puebloviejo", "Quevedo", 
                                "Urdaneta", "Ventanas", "Vinces", "Palenque", "Buena Fe", 
                                "Valencia", "Mocache", "Quinsaloma", "Portoviejo", "Bolívar", 
                                "Chone", "El Carmen", "Flavio Alfaro", "Jipijapa", "Junín", 
                                "Manta", "Montecristi", "Paján", "Pichincha", "Rocafuerte", 
                                "Santa Ana", "Sucre", "Tosagua", "24 De Mayo", "Pedernales", 
                                "Olmedo", "Puerto López", "Jama", "Jaramijó", "San Vicente", 
                                "Morona", "Gualaquiza", "Limón Indanza", "Palora", "Santiago", 
                                "Sucúa", "Huamboya", "San Juan Bosco", "Taisha", "Logroño", 
                                "Pablo Sexto", "Tiwintza", "Sevilla Don Bosco", "Tena", 
                                "Archidona", "El Chaco", "Quijos", "Carlos Julio Arosemena Tola", 
                                "Pastaza", "Mera", "Santa Clara", "Arajuno", 
                                "Distrito Metropolitano De Quito", "Cayambe", "Mejía", 
                                "Pedro Moncayo", "Rumiñahui", "San Miguel De Los Bancos", 
                                "Pedro Vicente Maldonado", "Puerto Quito", "Ambato", 
                                "Baños De Agua Santa", "Cevallos", "Mocha", "Patate", "Quero", 
                                "San Pedro De Pelileo", "Santiago De Píllaro", "Tisaleo", 
                                "Zamora", "Chinchipe", "Nangaritza", "Yacuambi", "Yantzaza", 
                                "El Pangui", "Centinela Del Cóndor", "Palanda", "Paquisha", 
                                "San Cristóbal", "Isabela", "Santa Cruz", "Lago Agrio", 
                                "Gonzalo Pizarro", "Putumayo", "Shushufindi", "Sucumbíos", 
                                "Cascales", "Cuyabeno", "Francisco De Orellana", "Aguarico", 
                                "La Joya De Los Sachas", "Loreto", "Santo Domingo", 
                                "La Concordia", "Santa Elena", "La Libertad", "Salinas", 
                                "Juval"),
                              ordered = FALSE)

# Categorías DPA Parroquias:

df$parr_ubi = factor(df$parr_ubi,
                     levels = c("10150", "10151", "10152",
                                "10153",
                                "10154",
                                "10155",
                                "10156",
                                "10157",
                                "10158",
                                "10159",
                                "10160",
                                "10161",
                                "10162",
                                "10163",
                                "10164",
                                "10165",
                                "10166",
                                "10167",
                                "10168",
                                "10169",
                                "10170",
                                "10171",
                                "10250",
                                "10251",
                                "10252",
                                "10350",
                                "10352",
                                "10353",
                                "10354",
                                "10356",
                                "10357",
                                "10358",
                                "10359",
                                "10360",
                                "10450",
                                "10451",
                                "10452",
                                "10453",
                                "10550",
                                "10552",
                                "10553",
                                "10554",
                                "10556",
                                "10559",
                                "10561",
                                "10562",
                                "10650",
                                "10652",
                                "10750",
                                "10751",
                                "10850",
                                "10851",
                                "10852",
                                "10853",
                                "10854",
                                "10950",
                                "10951",
                                "10952",
                                "10953",
                                "10954",
                                "10955",
                                "10956",
                                "11050",
                                "11051",
                                "11150",
                                "11151",
                                "11152",
                                "11153",
                                "11154",
                                "11250",
                                "11253",
                                "11350",
                                "11351",
                                "11352",
                                "11450",
                                "11550",
                                "20150",
                                "20151",
                                "20153",
                                "20155",
                                "20156",
                                "20157",
                                "20158",
                                "20159",
                                "20160",
                                "20250",
                                "20251",
                                "20350",
                                "20351",
                                "20353",
                                "20354",
                                "20355",
                                "20450",
                                "20550",
                                "20551",
                                "20552",
                                "20553",
                                "20554",
                                "20555",
                                "20556",
                                "20650",
                                "20750",
                                "30150",
                                "30151",
                                "30153",
                                "30154",
                                "30155",
                                "30156",
                                "30157",
                                "30158",
                                "30160",
                                "30250",
                                "30251",
                                "30252",
                                "30253",
                                "30254",
                                "30350",
                                "30351",
                                "30352",
                                "30353",
                                "30354",
                                "30355",
                                "30356",
                                "30357",
                                "30358",
                                "30361",
                                "30362",
                                "30363",
                                "30450",
                                "30451",
                                "30452",
                                "30550",
                                "30650",
                                "30651",
                                "30750",
                                "40150",
                                "40151",
                                "40153",
                                "40154",
                                "40155",
                                "40156",
                                "40157",
                                "40158",
                                "40159",
                                "40161",
                                "40250",
                                "40251",
                                "40252",
                                "40253",
                                "40254",
                                "40255",
                                "40350",
                                "40351",
                                "40352",
                                "40353",
                                "40450",
                                "40451",
                                "40452",
                                "40453",
                                "40550",
                                "40551",
                                "40552",
                                "40553",
                                "40554",
                                "40555",
                                "40650",
                                "40651",
                                "50150",
                                "50151",
                                "50152",
                                "50153",
                                "50154",
                                "50156",
                                "50157",
                                "50158",
                                "50159",
                                "50161",
                                "50162",
                                "50250",
                                "50251",
                                "50252",
                                "50350",
                                "50351",
                                "50352",
                                "50353",
                                "50450",
                                "50451",
                                "50453",
                                "50455",
                                "50456",
                                "50457",
                                "50458",
                                "50550",
                                "50551",
                                "50552",
                                "50553",
                                "50554",
                                "50555",
                                "50650",
                                "50651",
                                "50652",
                                "50653",
                                "50750",
                                "50751",
                                "50752",
                                "50753",
                                "50754",
                                "60150",
                                "60151",
                                "60152",
                                "60153",
                                "60154",
                                "60155",
                                "60156",
                                "60157",
                                "60158",
                                "60159",
                                "60160",
                                "60161",
                                "60250",
                                "60251",
                                "60253",
                                "60254",
                                "60255",
                                "60256",
                                "60257",
                                "60258",
                                "60259",
                                "60260",
                                "60350",
                                "60351",
                                "60352",
                                "60353",
                                "60354",
                                "60450",
                                "60550",
                                "60551",
                                "60552",
                                "60553",
                                "60554",
                                "60650",
                                "60651",
                                "60652",
                                "60750",
                                "60751",
                                "60752",
                                "60753",
                                "60754",
                                "60755",
                                "60756",
                                "60757",
                                "60758",
                                "60759",
                                "60850",
                                "60950",
                                "60951",
                                "60952",
                                "60953",
                                "60954",
                                "60955",
                                "60956",
                                "61050",
                                "70150",
                                "70152",
                                "70250",
                                "70251",
                                "70254",
                                "70255",
                                "70256",
                                "70350",
                                "70351",
                                "70352",
                                "70353",
                                "70354",
                                "70355",
                                "70450",
                                "70451",
                                "70550",
                                "70650",
                                "70651",
                                "70652",
                                "70653",
                                "70654",
                                "70750",
                                "70850",
                                "70851",
                                "70950",
                                "70951",
                                "70952",
                                "70953",
                                "70954",
                                "70955",
                                "70956",
                                "71050",
                                "71051",
                                "71052",
                                "71053",
                                "71054",
                                "71055",
                                "71056",
                                "71150",
                                "71151",
                                "71152",
                                "71153",
                                "71250",
                                "71251",
                                "71252",
                                "71253",
                                "71254",
                                "71255",
                                "71256",
                                "71257",
                                "71350",
                                "71351",
                                "71352",
                                "71353",
                                "71354",
                                "71355",
                                "71356",
                                "71357",
                                "71358",
                                "71359",
                                "71450",
                                "71451",
                                "71452",
                                "71453",
                                "80150",
                                "80152",
                                "80153",
                                "80154",
                                "80159",
                                "80163",
                                "80165",
                                "80166",
                                "80168",
                                "80250",
                                "80251",
                                "80252",
                                "80253",
                                "80254",
                                "80255",
                                "80256",
                                "80257",
                                "80258",
                                "80259",
                                "80260",
                                "80261",
                                "80262",
                                "80263",
                                "80264",
                                "80265",
                                "80350",
                                "80351",
                                "80352",
                                "80353",
                                "80354",
                                "80355",
                                "80356",
                                "80357",
                                "80358",
                                "80450",
                                "80451",
                                "80452",
                                "80453",
                                "80454",
                                "80455",
                                "80550",
                                "80551",
                                "80552",
                                "80553",
                                "80554",
                                "80555",
                                "80556",
                                "80557",
                                "80558",
                                "80559",
                                "80560",
                                "80561",
                                "80562",
                                "80650",
                                "80651",
                                "80652",
                                "80653",
                                "80654",
                                "80750",
                                "80751",
                                "80752",
                                "80753",
                                "80754",
                                "80755",
                                "90150",
                                "90152",
                                "90153",
                                "90156",
                                "90157",
                                "90158",
                                "90250",
                                "90350",
                                "90450",
                                "90550",
                                "90551",
                                "90650",
                                "90652",
                                "90653",
                                "90654",
                                "90656",
                                "90750",
                                "90850",
                                "90851",
                                "90852",
                                "90950",
                                "91050",
                                "91051",
                                "91053",
                                "91054",
                                "91150",
                                "91151",
                                "91152",
                                "91153",
                                "91154",
                                "91250",
                                "91350",
                                "91450",
                                "91451",
                                "91452",
                                "91650",
                                "91651",
                                "91850",
                                "91950",
                                "91951",
                                "91952",
                                "91953",
                                "92050",
                                "92053",
                                "92055",
                                "92056",
                                "92150",
                                "92250",
                                "92251",
                                "92350",
                                "92450",
                                "92550",
                                "92750",
                                "92850",
                                "100150",
                                "100151",
                                "100152",
                                "100153",
                                "100154",
                                "100155",
                                "100156",
                                "100157",
                                "100250",
                                "100251",
                                "100252",
                                "100253",
                                "100254",
                                "100350",
                                "100351",
                                "100352",
                                "100353",
                                "100354",
                                "100355",
                                "100356",
                                "100357",
                                "100358",
                                "100450",
                                "100451",
                                "100452",
                                "100453",
                                "100454",
                                "100455",
                                "100456",
                                "100457",
                                "100458",
                                "100459",
                                "100550",
                                "100551",
                                "100552",
                                "100553",
                                "100650",
                                "100651",
                                "100652",
                                "100653",
                                "100654",
                                "100655",
                                "110150",
                                "110151",
                                "110152",
                                "110153",
                                "110154",
                                "110155",
                                "110156",
                                "110157",
                                "110158",
                                "110159",
                                "110160",
                                "110161",
                                "110162",
                                "110163",
                                "110250",
                                "110251",
                                "110252",
                                "110253",
                                "110254",
                                "110350",
                                "110351",
                                "110352",
                                "110353",
                                "110354",
                                "110450",
                                "110451",
                                "110455",
                                "110456",
                                "110457",
                                "110550",
                                "110551",
                                "110552",
                                "110553",
                                "110554",
                                "110650",
                                "110651",
                                "110652",
                                "110653",
                                "110654",
                                "110655",
                                "110656",
                                "110750",
                                "110751",
                                "110753",
                                "110754",
                                "110756",
                                "110850",
                                "110851",
                                "110852",
                                "110853",
                                "110950",
                                "110951",
                                "110952",
                                "110954",
                                "110956",
                                "110957",
                                "110958",
                                "110959",
                                "111050",
                                "111051",
                                "111052",
                                "111053",
                                "111054",
                                "111055",
                                "111150",
                                "111151",
                                "111152",
                                "111153",
                                "111154",
                                "111155",
                                "111156",
                                "111157",
                                "111158",
                                "111159",
                                "111160",
                                "111250",
                                "111251",
                                "111252",
                                "111350",
                                "111351",
                                "111352",
                                "111353",
                                "111354",
                                "111355",
                                "111356",
                                "111450",
                                "111451",
                                "111452",
                                "111453",
                                "111550",
                                "111551",
                                "111552",
                                "111650",
                                "111651",
                                "120150",
                                "120152",
                                "120153",
                                "120154",
                                "120155",
                                "120250",
                                "120251",
                                "120252",
                                "120350",
                                "120351",
                                "120450",
                                "120451",
                                "120452",
                                "120550",
                                "120553",
                                "120555",
                                "120650",
                                "120651",
                                "120750",
                                "120752",
                                "120753",
                                "120754",
                                "120850",
                                "120851",
                                "120950",
                                "121050",
                                "121051",
                                "121150",
                                "121250",
                                "121350",
                                "130150",
                                "130151",
                                "130152",
                                "130153",
                                "130154",
                                "130155",
                                "130156",
                                "130157",
                                "130250",
                                "130251",
                                "130252",
                                "130350",
                                "130351",
                                "130352",
                                "130353",
                                "130354",
                                "130355",
                                "130356",
                                "130357",
                                "130450",
                                "130451",
                                "130452",
                                "130453",
                                "130454",
                                "130550",
                                "130551",
                                "130552",
                                "130650",
                                "130651",
                                "130652",
                                "130653",
                                "130654",
                                "130656",
                                "130657",
                                "130658",
                                "130750",
                                "130850",
                                "130851",
                                "130852",
                                "130950",
                                "130952",
                                "131050",
                                "131051",
                                "131052",
                                "131053",
                                "131054",
                                "131150",
                                "131151",
                                "131152",
                                "131250",
                                "131350",
                                "131351",
                                "131352",
                                "131353",
                                "131355",
                                "131450",
                                "131453",
                                "131457",
                                "131550",
                                "131551",
                                "131552",
                                "131650",
                                "131651",
                                "131652",
                                "131653",
                                "131750",
                                "131751",
                                "131752",
                                "131753",
                                "131850",
                                "131950",
                                "131951",
                                "131952",
                                "132050",
                                "132150",
                                "132250",
                                "132251",
                                "140150",
                                "140151",
                                "140153",
                                "140156",
                                "140157",
                                "140158",
                                "140160",
                                "140162",
                                "140164",
                                "140250",
                                "140251",
                                "140252",
                                "140253",
                                "140254",
                                "140255",
                                "140256",
                                "140257",
                                "140258",
                                "140350",
                                "140351",
                                "140353",
                                "140356",
                                "140357",
                                "140358",
                                "140450",
                                "140451",
                                "140452",
                                "140454",
                                "140455",
                                "140550",
                                "140551",
                                "140552",
                                "140553",
                                "140554",
                                "140556",
                                "140557",
                                "140650",
                                "140651",
                                "140652",
                                "140655",
                                "140750",
                                "140751",
                                "140850",
                                "140851",
                                "140852",
                                "140853",
                                "140854",
                                "140950",
                                "140951",
                                "140952",
                                "140953",
                                "140954",
                                "141050",
                                "141051",
                                "141052",
                                "141150",
                                "141250",
                                "141251",
                                "150150",
                                "150151",
                                "150153",
                                "150154",
                                "150155",
                                "150156",
                                "150157",
                                "150158",
                                "150350",
                                "150352",
                                "150354",
                                "150356",
                                "150450",
                                "150451",
                                "150452",
                                "150453",
                                "150454",
                                "150455",
                                "150750",
                                "150751",
                                "150752",
                                "150753",
                                "150754",
                                "150756",
                                "150950",
                                "160150",
                                "160152",
                                "160154",
                                "160155",
                                "160156",
                                "160157",
                                "160158",
                                "160159",
                                "160161",
                                "160162",
                                "160163",
                                "160164",
                                "160165",
                                "160166",
                                "160250",
                                "160251",
                                "160252",
                                "160350",
                                "160351",
                                "160450",
                                "160451",
                                "170150",
                                "170151",
                                "170152",
                                "170153",
                                "170154",
                                "170155",
                                "170156",
                                "170157",
                                "170158",
                                "170159",
                                "170160",
                                "170161",
                                "170162",
                                "170163",
                                "170164",
                                "170165",
                                "170166",
                                "170168",
                                "170169",
                                "170170",
                                "170171",
                                "170172",
                                "170174",
                                "170175",
                                "170176",
                                "170177",
                                "170178",
                                "170179",
                                "170180",
                                "170181",
                                "170183",
                                "170184",
                                "170185",
                                "170186",
                                "170250",
                                "170251",
                                "170252",
                                "170253",
                                "170254",
                                "170255",
                                "170256",
                                "170350",
                                "170351",
                                "170352",
                                "170353",
                                "170354",
                                "170355",
                                "170356",
                                "170357",
                                "170450",
                                "170451",
                                "170452",
                                "170453",
                                "170454",
                                "170550",
                                "170551",
                                "170552",
                                "170750",
                                "170751",
                                "170850",
                                "170950",
                                "180150",
                                "180151",
                                "180152",
                                "180153",
                                "180154",
                                "180155",
                                "180156",
                                "180157",
                                "180158",
                                "180159",
                                "180160",
                                "180161",
                                "180162",
                                "180163",
                                "180164",
                                "180165",
                                "180166",
                                "180167",
                                "180168",
                                "180250",
                                "180251",
                                "180252",
                                "180253",
                                "180254",
                                "180350",
                                "180450",
                                "180451",
                                "180550",
                                "180551",
                                "180552",
                                "180553",
                                "180650",
                                "180651",
                                "180652",
                                "180750",
                                "180751",
                                "180752",
                                "180753",
                                "180754",
                                "180755",
                                "180756",
                                "180757",
                                "180758",
                                "180850",
                                "180851",
                                "180852",
                                "180853",
                                "180854",
                                "180855",
                                "180856",
                                "180857",
                                "180950",
                                "180951",
                                "190150",
                                "190151",
                                "190152",
                                "190153",
                                "190155",
                                "190156",
                                "190158",
                                "190250",
                                "190251",
                                "190252",
                                "190254",
                                "190256",
                                "190259",
                                "190350",
                                "190351",
                                "190352",
                                "190353",
                                "190450",
                                "190451",
                                "190452",
                                "190550",
                                "190551",
                                "190553",
                                "190650",
                                "190651",
                                "190652",
                                "190653",
                                "190750",
                                "190752",
                                "190753",
                                "190850",
                                "190851",
                                "190852",
                                "190853",
                                "190854",
                                "190950",
                                "190951",
                                "190952",
                                "200150",
                                "200151",
                                "200152",
                                "200250",
                                "200251",
                                "200350",
                                "200351",
                                "200352",
                                "210150",
                                "210152",
                                "210153",
                                "210155",
                                "210156",
                                "210157",
                                "210158",
                                "210160",
                                "210250",
                                "210251",
                                "210252",
                                "210254",
                                "210350",
                                "210351",
                                "210352",
                                "210353",
                                "210354",
                                "210355",
                                "210450",
                                "210451",
                                "210452",
                                "210453",
                                "210454",
                                "210455",
                                "210550",
                                "210551",
                                "210552",
                                "210553",
                                "210554",
                                "210650",
                                "210651",
                                "210652",
                                "210653",
                                "210750",
                                "210751",
                                "210752",
                                "220150",
                                "220151",
                                "220152",
                                "220153",
                                "220154",
                                "220155",
                                "220156",
                                "220157",
                                "220158",
                                "220159",
                                "220160",
                                "220161",
                                "220250",
                                "220251",
                                "220252",
                                "220253",
                                "220255",
                                "220350",
                                "220351",
                                "220352",
                                "220353",
                                "220354",
                                "220355",
                                "220356",
                                "220357",
                                "220358",
                                "220450",
                                "220451",
                                "220452",
                                "220453",
                                "220454",
                                "220455",
                                "230150",
                                "230151",
                                "230152",
                                "230153",
                                "230154",
                                "230155",
                                "230156",
                                "230157",
                                "230250",
                                "230251",
                                "230252",
                                "230253",
                                "240150",
                                "240151",
                                "240152",
                                "240153",
                                "240154",
                                "240155",
                                "240156",
                                "240250",
                                "240350",
                                "240351",
                                "240352",
                                "900651",
                                "10101",
                                "10102",
                                "10103",
                                "10104",
                                "10105",
                                "10106",
                                "10107",
                                "10108",
                                "10109",
                                "10110",
                                "10111",
                                "10112",
                                "10113",
                                "10114",
                                "10115",
                                "20101",
                                "20102",
                                "20103",
                                "20701",
                                "20702",
                                "30101",
                                "30102",
                                "30103",
                                "30104",
                                "40101",
                                "40102",
                                "40301",
                                "40302",
                                "40501",
                                "40502",
                                "50101",
                                "50102",
                                "50103",
                                "50104",
                                "50105",
                                "50201",
                                "50202",
                                "50203",
                                "60101",
                                "60102",
                                "60103",
                                "60104",
                                "60105",
                                "60301",
                                "60302",
                                "60701",
                                "60702",
                                "70101",
                                "70102",
                                "70103",
                                "70104",
                                "70105",
                                "70701",
                                "70702",
                                "70703",
                                "70704",
                                "70705",
                                "70901",
                                "70902",
                                "70903",
                                "70904",
                                "71001",
                                "71002",
                                "71003",
                                "71201",
                                "71202",
                                "71203",
                                "71204",
                                "71205",
                                "71401",
                                "71402",
                                "71403",
                                "80101",
                                "80102",
                                "80103",
                                "80104",
                                "80105",
                                "90101",
                                "90102",
                                "90103",
                                "90104",
                                "90105",
                                "90106",
                                "90107",
                                "90108",
                                "90109",
                                "90110",
                                "90111",
                                "90112",
                                "90113",
                                "90114",
                                "90115",
                                "90601",
                                "90602",
                                "90603",
                                "90604",
                                "90605",
                                "90606",
                                "90607",
                                "90608",
                                "90701",
                                "90702",
                                "90703",
                                "91001",
                                "91002",
                                "91003",
                                "91004",
                                "91005",
                                "91006",
                                "91007",
                                "91008",
                                "91009",
                                "91601",
                                "91602",
                                "91901",
                                "91902",
                                "91903",
                                "91904",
                                "91905",
                                "100101",
                                "100102",
                                "100103",
                                "100104",
                                "100105",
                                "100201",
                                "100202",
                                "100301",
                                "100302",
                                "100401",
                                "100402",
                                "110101",
                                "110102",
                                "110103",
                                "110104",
                                "110105",
                                "110106",
                                "110201",
                                "110202",
                                "110203",
                                "110301",
                                "110302",
                                "110801",
                                "110802",
                                "110901",
                                "110902",
                                "120101",
                                "120102",
                                "120103",
                                "120104",
                                "120501",
                                "120502",
                                "120504",
                                "120505",
                                "120506",
                                "120507",
                                "120508",
                                "120509",
                                "120510",
                                "120701",
                                "120702",
                                "120801",
                                "120802",
                                "120803",
                                "121001",
                                "121002",
                                "121003",
                                "121101",
                                "121102",
                                "121103",
                                "130101",
                                "130102",
                                "130103",
                                "130104",
                                "130105",
                                "130106",
                                "130107",
                                "130108",
                                "130109",
                                "130301",
                                "130302",
                                "130401",
                                "130402",
                                "130601",
                                "130602",
                                "130603",
                                "130801",
                                "130802",
                                "130803",
                                "130804",
                                "130805",
                                "130901",
                                "130902",
                                "130903",
                                "130904",
                                "130905",
                                "130906",
                                "131301",
                                "131302",
                                "131401",
                                "131402",
                                "140201",
                                "140202",
                                "170101",
                                "170102",
                                "170103",
                                "170104",
                                "170105",
                                "170106",
                                "170107",
                                "170108",
                                "170109",
                                "170110",
                                "170111",
                                "170112",
                                "170113",
                                "170114",
                                "170115",
                                "170116",
                                "170117",
                                "170118",
                                "170119",
                                "170120",
                                "170121",
                                "170122",
                                "170123",
                                "170124",
                                "170125",
                                "170126",
                                "170127",
                                "170128",
                                "170129",
                                "170130",
                                "170131",
                                "170132",
                                "170202",
                                "170203",
                                "170501",
                                "170502",
                                "170503",
                                "170504",
                                "180101",
                                "180102",
                                "180103",
                                "180104",
                                "180105",
                                "180106",
                                "180107",
                                "180108",
                                "180109",
                                "180701",
                                "180702",
                                "180801",
                                "180802",
                                "190101",
                                "190102",
                                "220201",
                                "220202",
                                "230101",
                                "230102",
                                "230103",
                                "230104",
                                "230105",
                                "230106",
                                "230107",
                                "240101",
                                "240102",
                                "240301",
                                "240302",
                                "240303",
                                "240304",
                                "880000",
                                "900151",
                                "900451",
                                "900551",
                                "900751",
                                "900851"),
                     labels = c("Cuenca, Cabecera Cantonal ", 
                                "Baños ", 
                                "Cumbe ", 
                                "Chaucha ", 
                                "Checa ", 
                                "Chiquintad ", 
                                "Llacao ", 
                                "Molleturo ", 
                                "Nulti ", 
                                "Octavio Cordero Palacios ", 
                                "Paccha ", 
                                "Quingeo ", 
                                "Ricaurte ", 
                                "San Joaquín ", 
                                "Santa Ana ", 
                                "Sayausí ", 
                                "Sidcay ", 
                                "Sinincay ", 
                                "Tarqui ", 
                                "Turi ", 
                                "Valle ", 
                                "Victoria Del Portete ", 
                                "Girón, Cabecera Cantonal ", 
                                "La Asunción ", 
                                "San Gerardo ", 
                                "Gualaceo, Cabecera Cantonal ", 
                                "Daniel Córdova Toral ", 
                                "Jadán ", 
                                "Mariano Moreno ", 
                                "Remigio Crespo Toral ", 
                                "San Juan ", 
                                "Zhidmad ", 
                                "Luis Cordero Vega ", 
                                "Simón Bolívar ", 
                                "Nabón, Cabecera Cantonal ", 
                                "Cochapata ", 
                                "El Progreso ", 
                                "Las Nieves ", 
                                "Paute, Cabecera Cantonal ", 
                                "Bulán ", 
                                "Chicán ", 
                                "El Cabo ", 
                                "Guarainag ", 
                                "San Cristóbal ", 
                                "Tomebamba ", 
                                "Dug Dug ", 
                                "Pucará, Cabecera Cantonal ", 
                                "San Rafael De Sharug ", 
                                "San Fernando, Cabecera Cantonal ", 
                                "Chumblín ", 
                                "Santa Isabel, Cabecera Cantonal ", 
                                "Abdón Calderón ", 
                                "El Carmen De Pijilí ", 
                                "Shaglli ", 
                                "San Salvador De Cañaribamba ", 
                                "Sígsig, Cabecera Cantonal ", 
                                "Cuchil ", 
                                "Jima ", 
                                "Güel ", 
                                "Ludo ", 
                                "San Bartolomé ", 
                                "San José De Raranga ", 
                                "San Felipe De Oña, Cabecera Cantonal ", 
                                "Susudel ", 
                                "Chordeleg, Cabecera Cantonal ", 
                                "Principal ", 
                                "La Unión ", 
                                "Luis Galarza Orellana ", 
                                "San Martín De Puzhio ", 
                                "El Pan, Cabecera Cantonal ", 
                                "San Vicente ", 
                                "Sevilla De Oro, Cabecera Cantonal ", 
                                "Amaluza ", 
                                "Palmas ", 
                                "Guachapala, Cabecera Cantonal ", 
                                "Camilo Ponce Enríquez, Cabecera Cantonal ", 
                                "Guaranda, Cabecera Cantonal ", 
                                "Facundo Vela ", 
                                "Julio E. Moreno ", 
                                "Salinas ", 
                                "San Lorenzo ", 
                                "San Simón ", 
                                "Santa Fe ", 
                                "Simiátug ", 
                                "San Luis De Pambil ", 
                                "Chillanes, Cabecera Cantonal ", 
                                "San José Del Tambo ", 
                                "San José De Chimbo, Cabecera Cantonal ", 
                                "Asunción ", 
                                "La Magdalena ", 
                                "San Sebastián ", 
                                "Telimbela ", 
                                "Echeandía, Cabecera Cantonal ", 
                                "San Miguel, Cabecera Cantonal ", 
                                "Balsapamba ", 
                                "Bilován ", 
                                "Régulo De Mora ", 
                                "San Pablo ", 
                                "Santiago ", 
                                "San Vicente ", 
                                "Caluma, Cabecera Cantonal ", 
                                "Las Naves, Cabecera Cantonal ", 
                                "Azogues, Cabecera Cantonal ", 
                                "Cojitambo ", 
                                "Guapán ", 
                                "Javier Loyola ", 
                                "Luis Cordero ", 
                                "Pindilig ", 
                                "Rivera ", 
                                "San Miguel ", 
                                "Taday ", 
                                "Biblián, Cabecera Cantonal ", 
                                "Nazón ", 
                                "San Francisco De Sageo ", 
                                "Turupamba ", 
                                "Jerusalén ", 
                                "Cañar, Cabecera Cantonal ", 
                                "Chontamarca ", 
                                "Chorocopte ", 
                                "General Morales ", 
                                "Gualleturo ", 
                                "Honorato Vásquez ", 
                                "Ingapirca ", 
                                "Juncal ", 
                                "San Antonio ", 
                                "Zhud ", 
                                "Ventura ", 
                                "Ducur ", 
                                "La Troncal, Cabecera Cantonal ", 
                                "Manuel J. Calle ", 
                                "Pancho Negro ", 
                                "El Tambo, Cabecera Cantonal ", 
                                "Déleg, Cabecera Cantonal ", 
                                "Solano ", 
                                "Suscal, Cabecera Cantonal ", 
                                "Tulcán, Cabecera Cantonal ", 
                                "El Carmelo ", 
                                "Julio Andrade ", 
                                "Maldonado ", 
                                "Pioter ", 
                                "Tobar Donoso ", 
                                "Tufiño ", 
                                "Urbina ", 
                                "El Chical ", 
                                "Santa Martha De Cuba ", 
                                "Bolívar, Cabecera Cantonal ", 
                                "García Moreno ", 
                                "Los Andes ", 
                                "Monte Olivo ", 
                                "San Vicente De Pusir ", 
                                "San Rafael ", 
                                "El Ángel, Cabecera Cantonal ", 
                                "El Goaltal ", 
                                "La Libertad ", 
                                "San Isidro ", 
                                "Mira, Cabecera Cantonal ", 
                                "Concepción ", 
                                "Jijón Y Caamaño ", 
                                "Juan Montalvo ", 
                                "San Gabriel, Cabecera Cantonal ", 
                                "Cristóbal Colón ", 
                                "Chitán De Navarrete ", 
                                "Fernández Salvador ", 
                                "La Paz ", 
                                "Piartal ", 
                                "Huaca, Cabecera Cantonal ", 
                                "Mariscal Sucre ", 
                                "Latacunga, Cabecera Cantonal ", 
                                "Aláquez ", 
                                "Belisario Quevedo ", 
                                "Guaytacama ", 
                                "Joseguango Bajo ", 
                                "Mulaló ", 
                                "Once De Noviembre ", 
                                "Poaló ", 
                                "San Juan De Pastocalle ", 
                                "Tanicuchí ", 
                                "Toacaso ", 
                                "La Maná, Cabecera Cantonal ", 
                                "Guasaganda ", 
                                "Pucayacu ", 
                                "El Corazón, Cabecera Cantonal ", 
                                "Moraspungo ", 
                                "Pinllopata ", 
                                "Ramón Campaña ", 
                                "Pujilí, Cabecera Cantonal ", 
                                "Angamarca ", 
                                "Guangaje ", 
                                "La Victoria ", 
                                "Pilaló ", 
                                "Tingo ", 
                                "Zumbahua ", 
                                "San Miguel, Cabecera Cantonal ", 
                                "Antonio José Holguín ", 
                                "Cusubamba ", 
                                "Mulalillo ", 
                                "Mulliquindil ", 
                                "Pansaleo ", 
                                "Saquisilí, Cabecera Cantonal ", 
                                "Canchagua ", 
                                "Chantilín ", 
                                "Cochapamba ", 
                                "Sigchos, Cabecera Cantonal ", 
                                "Chugchillán ", 
                                "Isinlivi ", 
                                "Las Pampas ", 
                                "Palo Quemado ", 
                                "Riobamba, Cabecera Cantonal ", 
                                "Cacha ", 
                                "Calpi ", 
                                "Cubijíes ", 
                                "Flores ", 
                                "Licán ", 
                                "Licto ", 
                                "Pungalá ", 
                                "Punín ", 
                                "Quimiag ", 
                                "San Juan ", 
                                "San Luis ", 
                                "Alausí, Cabecera Cantonal ", 
                                "Achupallas ", 
                                "Guasuntos ", 
                                "Huigra ", 
                                "Multitud ", 
                                "Pistishi ", 
                                "Pumallacta ", 
                                "Sevilla ", 
                                "Sibambe ", 
                                "Tixán ", 
                                "Villa La Unión, Cabecera Cantonal ", 
                                "Cañi ", 
                                "Columbe ", 
                                "Juan De Velasco ", 
                                "Santiago De Quito ", 
                                "Chambo, Cabecera Cantonal ", 
                                "Chunchi, Cabecera Cantonal ", 
                                "Capzol ", 
                                "Compud ", 
                                "Gonzol ", 
                                "Llagos ", 
                                "Guamote, Cabecera Cantonal ", 
                                "Cebadas ", 
                                "Palmira ", 
                                "Guano, Cabecera Cantonal ", 
                                "Guanando ", 
                                "Ilapo ", 
                                "La Providencia ", 
                                "San Andrés ", 
                                "San Gerardo ", 
                                "San Isidro De Patulú ", 
                                "San José Del Chazo ", 
                                "Santa Fé De Galán ", 
                                "Valparaiso ", 
                                "Pallatanga, Cabecera Cantonal ", 
                                "Penipe, Cabecera Cantonal ", 
                                "El Altar ", 
                                "Matus ", 
                                "Puela ", 
                                "San Antonio De Bayushig ", 
                                "La Candelaria ", 
                                "Bilbao ", 
                                "Cumandá, Cabecera Cantonal ", 
                                "Machala, Cabecera Cantonal ", 
                                "El Retiro ", 
                                "Arenillas, Cabecera Cantonal ", 
                                "Chacras ", 
                                "Palmales ", 
                                "Carcabón ", 
                                "La Cuca ", 
                                "Paccha, Cabecera Cantonal ", 
                                "Ayapamba ", 
                                "Cordoncillo ", 
                                "Milagro ", 
                                "San José ", 
                                "San Juan De Cerro Azul ", 
                                "Balsas, Cabecera Cantonal ", 
                                "Bellamaría ", 
                                "Chilla, Cabecera Cantonal ", 
                                "El Guabo, Cabecera Cantonal ", 
                                "Barbones ", 
                                "La Iberia ", 
                                "Tendales ", 
                                "Río Bonito ", 
                                "Huaquillas, Cabecera Cantonal ", 
                                "Marcabelí, Cabecera Cantonal ", 
                                "El Ingenio ", 
                                "Pasaje, Cabecera Cantonal ", 
                                "Buenavista ", 
                                "Casacay ", 
                                "La Peaña ", 
                                "Progreso ", 
                                "Uzhcurrumi ", 
                                "Cañaquemada ", 
                                "Piñas, Cabecera Cantonal ", 
                                "Capiro ", 
                                "La Bocana ", 
                                "Moromoro ", 
                                "Piedras ", 
                                "San Roque ", 
                                "Saracay ", 
                                "Portovelo, Cabecera Cantonal ", 
                                "Curtincapa ", 
                                "Morales ", 
                                "Salatí ", 
                                "Santa Rosa, Cabecera Cantonal ", 
                                "Bellavista ", 
                                "Jambelí ", 
                                "La Avanzada ", 
                                "San Antonio ", 
                                "Torata ", 
                                "Victoria ", 
                                "Bellamaría ", 
                                "Zaruma, Cabecera Cantonal ", 
                                "Abañín ", 
                                "Arcapamba ", 
                                "Guanazán ", 
                                "Guizhaguiña ", 
                                "Huertas ", 
                                "Malvas ", 
                                "Muluncay Grande ", 
                                "Sinsao ", 
                                "Salvias ", 
                                "La Victoria, Cabecera Cantonal ", 
                                "La Libertad ", 
                                "El Paraíso ", 
                                "San Isidro ", 
                                "Esmeraldas, Cabecera Cantonal ", 
                                "Camarones ", 
                                "Coronel Carlos Concha Torres ", 
                                "Chinca ", 
                                "Majua ", 
                                "San Mateo ", 
                                "Tabiazo ", 
                                "Tachina ", 
                                "Vuelta Larga ", 
                                "Valdez, Cabecera Cantonal ", 
                                "Anchayacu ", 
                                "Atahualpa ", 
                                "Borbón ", 
                                "La Tola ", 
                                "Luis Vargas Torres ", 
                                "Maldonado ", 
                                "Pampanal De Bolívar ", 
                                "San Francisco De Onzole ", 
                                "Santo Domingo De Onzole ", 
                                "Selva Alegre ", 
                                "Telembí ", 
                                "Colón Eloy Del María ", 
                                "San José De Cayapas ", 
                                "Timbiré ", 
                                "Santa Lucía De Las Peñas ", 
                                "Muisne, Cabecera Cantonal ", 
                                "Bolívar ", 
                                "Daule ", 
                                "Galera ", 
                                "Quingue ", 
                                "Sálima ", 
                                "San Francisco ", 
                                "San Gregorio ", 
                                "San José De Chamanga ", 
                                "Rosa Zárate, Cabecera Cantonal ", 
                                "Cube ", 
                                "Chura ", 
                                "Malimpia ", 
                                "Viche ", 
                                "La Unión ", 
                                "San Lorenzo, Cabecera Cantonal ", 
                                "Alto Tambo ", 
                                "Ancón ", 
                                "Calderón ", 
                                "Carondelet ", 
                                "5 De Junio ", 
                                "Concepción ", 
                                "Mataje ", 
                                "San Javier De Cachaví ", 
                                "Santa Rita ", 
                                "Tambillo ", 
                                "Tululbí ", 
                                "Urbina ", 
                                "Atacames, Cabecera Cantonal ", 
                                "La Unión ", 
                                "Súa ", 
                                "Tonchigüe ", 
                                "Tonsupa ", 
                                "Rioverde, Cabecera Cantonal ", 
                                "Chontaduro ", 
                                "Chumundé ", 
                                "Lagarto ", 
                                "Montalvo ", 
                                "Rocafuerte ", 
                                "Guayaquil, Cabecera Cantonal ", 
                                "Juan Gómez Rendón ", 
                                "Morro ", 
                                "Posorja ", 
                                "Puná ", 
                                "Tenguel ", 
                                "Alfredo Baquerizo Moreno (Juján), Cabecera Cantonal ", 
                                "Balao, Cabecera Cantonal ", 
                                "Balzar, Cabecera Cantonal ", 
                                "Colimes, Cabecera Cantonal ", 
                                "San Jacinto ", 
                                "Daule, Cabecera Cantonal ", 
                                "Juan Bautista Aguirre ", 
                                "Laurel ", 
                                "Limonal ", 
                                "Los Lojas ", 
                                "Eloy Alfaro, Cabecera Cantonal ", 
                                "Velasco Ibarra, Cabecera Cantonal ", 
                                "Guayas ", 
                                "El Rosario ", 
                                "El Triunfo, Cabecera Cantonal ", 
                                "Milagro, Cabecera Cantonal ", 
                                "Chobo ", 
                                "Mariscal Sucre ", 
                                "Roberto Astudillo ", 
                                "Naranjal, Cabecera Cantonal ", 
                                "Jesús María ", 
                                "San Carlos ", 
                                "Santa Rosa De Flandes ", 
                                "Taura ", 
                                "Naranjito, Cabecera Cantonal ", 
                                "Palestina, Cabecera Cantonal ", 
                                "Pedro Carbo, Cabecera Cantonal ", 
                                "Valle De La Virgen ", 
                                "Sabanilla ", 
                                "Samborondón, Cabecera Cantonal ", 
                                "Tarifa ", 
                                "Santa Lucía, Cabecera Cantonal ", 
                                "El Salitre, Cabecera Cantonal ", 
                                "General Vernaza ", 
                                "La Victoria ", 
                                "Junquillal ", 
                                "San Jacinto De Yaguachi, Cabecera Cantonal ", 
                                "General Pedro J. Montero ", 
                                "Yaguachi Viejo ", 
                                "Virgen De Fátima ", 
                                "General Villamil, Cabecera Cantonal ", 
                                "Simón Bolívar, Cabecera Cantonal ", 
                                "Coronel Lorenzo De Garaycoa ", 
                                "Coronel Marcelino Maridueña, Cabecera Cantonal ", 
                                "Lomas De Sargentillo, Cabecera Cantonal ", 
                                "Narcisa De Jesús, Cabecera Cantonal ", 
                                "General Antonio Elizalde, Cabecera Cantonal ", 
                                "Isidro Ayora, Cabecera Cantonal ", 
                                "San Miguel De Ibarra, Cabecera Cantonal ", 
                                "Ambuquí ", 
                                "Angochagua ", 
                                "La Carolina ", 
                                "La Esperanza ", 
                                "Lita ", 
                                "Salinas ", 
                                "San Antonio ", 
                                "Atuntaqui, Cabecera Cantonal ", 
                                "Imbaya ", 
                                "San Francisco De Natabuela ", 
                                "San José De Chaltura ", 
                                "San Roque ", 
                                "Cotacachi, Cabecera Cantonal ", 
                                "Apuela ", 
                                "García Moreno ", 
                                "Imantag ", 
                                "Peñaherrera ", 
                                "Plaza Gutiérrez ", 
                                "Quiroga ", 
                                "Seis De Julio De Cuellaje ", 
                                "Vacas Galindo ", 
                                "Otavalo, Cabecera Cantonal ", 
                                "Dr. Miguel Egas Cabezas ", 
                                "Eugenio Espejo ", 
                                "González Suárez ", 
                                "Pataquí ", 
                                "San José De Quichinche ", 
                                "San Juan De Ilumán ", 
                                "San Pablo ", 
                                "San Rafael ", 
                                "Selva Alegre ", 
                                "Pimampiro, Cabecera Cantonal ", 
                                "Chugá ", 
                                "Mariano Acosta ", 
                                "San Francisco De Sigsipamba ", 
                                "Urcuquí, Cabecera Cantonal ", 
                                "Cahuasquí ", 
                                "La Merced De Buenos Aires ", 
                                "Pablo Arenas ", 
                                "San Blas ", 
                                "Tumbabiro ", 
                                "Loja, Cabecera Cantonal ", 
                                "Chantaco ", 
                                "Chuquiribamba ", 
                                "El Cisne ", 
                                "Gualel ", 
                                "Jimbilla ", 
                                "Malacatos ", 
                                "San Lucas ", 
                                "San Pedro De Vilcabamba ", 
                                "Santiago ", 
                                "Taquil ", 
                                "Vilcabamba ", 
                                "Yangana ", 
                                "Quinara ", 
                                "Cariamanga, Cabecera Cantonal ", 
                                "Colaisaca ", 
                                "El Lucero ", 
                                "Utuana ", 
                                "Sanguillín ", 
                                "Catamayo, Cabecera Cantonal ", 
                                "El Tambo ", 
                                "Guayquichuma ", 
                                "San Pedro De La Bendita ", 
                                "Zambi ", 
                                "Celica, Cabecera Cantonal ", 
                                "Cruzpamba ", 
                                "Pózul ", 
                                "Sabanilla ", 
                                "Teniente Maximiliano Rodríguez Loaiza ", 
                                "Chaguarpamba, Cabecera Cantonal ", 
                                "Buenavista ", 
                                "El Rosario ", 
                                "Santa Rufina ", 
                                "Amarillos ", 
                                "Amaluza, Cabecera Cantonal ", 
                                "Bellavista ", 
                                "Jimbura ", 
                                "Santa Teresita ", 
                                "27 De Abril ", 
                                "El Ingenio ", 
                                "El Airo ", 
                                "Gonzanamá, Cabecera Cantonal ", 
                                "Changaimina ", 
                                "Nambacola ", 
                                "Purunuma ", 
                                "Sacapalca ", 
                                "Macará, Cabecera Cantonal ", 
                                "Larama ", 
                                "La Victoria ", 
                                "Sabiango ", 
                                "Catacocha, Cabecera Cantonal ", 
                                "Cangonamá ", 
                                "Guachanamá ", 
                                "Lauro Guerrero ", 
                                "Orianga ", 
                                "San Antonio ", 
                                "Casanga ", 
                                "Yamana ", 
                                "Alamor, Cabecera Cantonal ", 
                                "Ciano ", 
                                "El Arenal ", 
                                "El Limo ", 
                                "Mercadillo ", 
                                "Vicentino ", 
                                "Saraguro, Cabecera Cantonal ", 
                                "El Paraíso De Celen ", 
                                "El Tablón ", 
                                "Lluzhapa ", 
                                "Manú ", 
                                "San Antonio De Qumbe ", 
                                "San Pablo De Tenta ", 
                                "San Sebastián De Yúluc ", 
                                "Selva Alegre ", 
                                "Urdaneta ", 
                                "Sumaypamba ", 
                                "Sozoranga, Cabecera Cantonal ", 
                                "Nueva Fátima ", 
                                "Tacamoros ", 
                                "Zapotillo, Cabecera Cantonal ", 
                                "Mangahurco ", 
                                "Garzareal ", 
                                "Limones ", 
                                "Paletillas ", 
                                "Bolaspamba ", 
                                "Cazaderos ", 
                                "Pindal, Cabecera Cantonal ", 
                                "Chaquinal ", 
                                "12 De Diciembre ", 
                                "Milagros ", 
                                "Quilanga, Cabecera Cantonal ", 
                                "Fundochamba ", 
                                "San Antonio De Las Aradas ", 
                                "Olmedo, Cabecera Cantonal ", 
                                "La Tingue ", 
                                "Babahoyo, Cabecera Cantonal ", 
                                "Caracol ", 
                                "Febres Cordero ", 
                                "Pimocha ", 
                                "La Unión ", 
                                "Baba, Cabecera Cantonal ", 
                                "Guare ", 
                                "Isla De Bejucal ", 
                                "Montalvo, Cabecera Cantonal ", 
                                "La Esmeralda ", 
                                "Puebloviejo, Cabecera Cantonal ", 
                                "Puerto Pechiche ", 
                                "San Juan ", 
                                "Quevedo, Cabecera Cantonal ", 
                                "San Carlos ", 
                                "La Esperanza ", 
                                "Catarama, Cabecera Cantonal ", 
                                "Ricaurte ", 
                                "Ventanas, Cabecera Cantonal ", 
                                "Zapotal ", 
                                "Chacarita ", 
                                "Los Ángeles ", 
                                "Vinces, Cabecera Cantonal ", 
                                "Antonio Sotomayor ", 
                                "Palenque, Cabecera Cantonal ", 
                                "San Jacinto De Buena Fe, Cabecera Cantonal ", 
                                "Patricia Pilar ", 
                                "Valencia, Cabecera Cantonal ", 
                                "Mocache, Cabecera Cantonal ", 
                                "Quinsaloma, Cabecera Cantonal ", 
                                "Portoviejo, Cabecera Cantonal ", 
                                "Abdón Calderón ", 
                                "Alhajuela ", 
                                "Crucita ", 
                                "Pueblo Nuevo ", 
                                "Riochico ", 
                                "San Plácido ", 
                                "Chirijos ", 
                                "Calceta, Cabecera Cantonal ", 
                                "Membrillo ", 
                                "Quiroga ", 
                                "Chone, Cabecera Cantonal ", 
                                "Boyacá ", 
                                "Canuto ", 
                                "Convento ", 
                                "Chibunga ", 
                                "Eloy Alfaro ", 
                                "Ricaurte ", 
                                "San Antonio ", 
                                "El Carmen, Cabecera Cantonal ", 
                                "Wilfrido Loor Moreira ", 
                                "San Pedro De Suma ", 
                                "Santa María ", 
                                "El Paraíso La 14 ", 
                                "Flavio Alfaro, Cabecera Cantonal ", 
                                "San Francisco De Novillo ", 
                                "Zapallo ", 
                                "Jipijapa, Cabecera Cantonal ", 
                                "América ", 
                                "El Anegado ", 
                                "Julcuy ", 
                                "La Unión ", 
                                "Membrillal ", 
                                "Pedro Pablo Gómez ", 
                                "Puerto Cayo ", 
                                "Junín, Cabecera Cantonal ", 
                                "Manta, Cabecera Cantonal ", 
                                "San Lorenzo ", 
                                "Santa Marianita ", 
                                "Montecristi, Cabecera Cantonal ", 
                                "La Pila ", 
                                "Paján, Cabecera Cantonal ", 
                                "Campozano ", 
                                "Cascol ", 
                                "Guale ", 
                                "Lascano ", 
                                "Pichincha, Cabecera Cantonal ", 
                                "Barraganete ", 
                                "San Sebastián ", 
                                "Rocafuerte, Cabecera Cantonal ", 
                                "Santa Ana De Vuelta Larga, Cabecera Cantonal ", 
                                "Ayacucho ", 
                                "Honorato Vásquez ", 
                                "La Unión ", 
                                "San Pablo ", 
                                "Bahía De Caráquez, Cabecera Cantonal ", 
                                "Charapotó ", 
                                "San Isidro ", 
                                "Tosagua, Cabecera Cantonal ", 
                                "Bachillero ", 
                                "Ángel Pedro Giler ", 
                                "Sucre, Cabecera Cantonal ", 
                                "Bellavista ", 
                                "Noboa ", 
                                "Arquitecto Sixto Durán Ballén ", 
                                "Pedernales, Cabecera Cantonal ", 
                                "Cojimíes ", 
                                "Diez De Agosto ", 
                                "Atahualpa ", 
                                "Olmedo, Cabecera Cantonal ", 
                                "Puerto López, Cabecera Cantonal ", 
                                "Machalilla ", 
                                "Salango ", 
                                "Jama, Cabecera Cantonal ", 
                                "Jaramijó, Cabecera Cantonal ", 
                                "San Vicente, Cabecera Cantonal ", 
                                "Canoa ", 
                                "Macas, Cabecera Cantonal ", 
                                "Alshi ", 
                                "General Proaño ", 
                                "San Isidro ", 
                                "Sevilla Don Bosco ", 
                                "Sinaí ", 
                                "Zuña ", 
                                "Cuchaentza ", 
                                "Río Blanco ", 
                                "Gualaquiza, Cabecera Cantonal ", 
                                "Amazonas ", 
                                "Bermejos ", 
                                "Bomboíza ", 
                                "Chigüinda ", 
                                "El Rosario ", 
                                "Nueva Tarqui ", 
                                "San Miguel De Cuyes ", 
                                "El Ideal ", 
                                "General Leonidas Plaza Gutiérrez, Cabecera Cantonal ", 
                                "Indanza ", 
                                "San Antonio ", 
                                "San Miguel De Conchay ", 
                                "Santa Susana De Chiviaza ", 
                                "Yunganza ", 
                                "Palora, Cabecera Cantonal ", 
                                "Arapicos ", 
                                "Cumandá ", 
                                "Sangay ", 
                                "16 De Agosto ", 
                                "Santiago De Méndez, Cabecera Cantonal ", 
                                "Copal ", 
                                "Chupianza ", 
                                "Patuca ", 
                                "San Luis De El Acho ", 
                                "Tayuza ", 
                                "San Francisco De Chinimbimi ", 
                                "Sucúa, Cabecera Cantonal ", 
                                "Asunción ", 
                                "Huambi ", 
                                "Santa Marianita De Jesús ", 
                                "Huamboya, Cabecera Cantonal ", 
                                "Chiguaza ", 
                                "San Juan Bosco, Cabecera Cantonal ", 
                                "Pan De Azúcar ", 
                                "San Carlos De Limón ", 
                                "San Jacinto De Wakambeis ", 
                                "Santiago De Pananza ", 
                                "Taisha, Cabecera Cantonal ", 
                                "Huasaga ", 
                                "Macuma ", 
                                "Tuutinentsa ", 
                                "Pumpuentsa ", 
                                "Logroño, Cabecera Cantonal ", 
                                "Yaupi ", 
                                "Shimpis ", 
                                "Pablo Sexto, Cabecera Cantonal ", 
                                "Santiago, Cabecera Cantonal ", 
                                "San José De Morona ", 
                                "Tena, Cabecera Cantonal ", 
                                "Ahuano ", 
                                "Chontapunta ", 
                                "Pano ", 
                                "Puerto Misahuallí ", 
                                "Puerto Napo ", 
                                "Tálag ", 
                                "San Juan De Muyuna ", 
                                "Archidona, Cabecera Cantonal ", 
                                "Cotundo ", 
                                "San Pablo De Ushpayacu ", 
                                "Hatun Sumaku ", 
                                "El Chaco, Cabecera Cantonal ", 
                                "Gonzalo Díaz De Pineda ", 
                                "Linares ", 
                                "Oyacachi ", 
                                "Santa Rosa ", 
                                "Sardinas ", 
                                "Baeza, Cabecera Cantonal ", 
                                "Cosanga ", 
                                "Cuyuja ", 
                                "Papallacta ", 
                                "San Francisco De Borja ", 
                                "Sumaco ", 
                                "Carlos Julio Arosemena Tola, Cabecera Cantonal ", 
                                "Puyo, Cabecera Cantonal ", 
                                "Canelos ", 
                                "Diez De Agosto ", 
                                "Fátima ", 
                                "Montalvo ", 
                                "Pomona ", 
                                "Río Corrientes ", 
                                "Río Tigre ", 
                                "Sarayacu ", 
                                "Simón Bolívar ", 
                                "Tarqui ", 
                                "Teniente Hugo Ortiz ", 
                                "Veracruz ", 
                                "El Triunfo ", 
                                "Mera, Cabecera Cantonal ", 
                                "Madre Tierra ", 
                                "Shell ", 
                                "Santa Clara, Cabecera Cantonal ", 
                                "San José ", 
                                "Arajuno, Cabecera Cantonal ", 
                                "Curaray ", 
                                "Quito, Cabecera Cantonal ", 
                                "Alangasí ", 
                                "Amaguaña ", 
                                "Atahualpa ", 
                                "Calacalí ", 
                                "Calderón ", 
                                "Conocoto ", 
                                "Cumbayá ", 
                                "Chavezpamba ", 
                                "Checa ", 
                                "El Quinche ", 
                                "Gualea ", 
                                "Guangopolo ", 
                                "Guayllabamba ", 
                                "La Merced ", 
                                "Llano Chico ", 
                                "Lloa ", 
                                "Nanegal ", 
                                "Nanegalito ", 
                                "Nayón ", 
                                "Nono ", 
                                "Pacto ", 
                                "Perucho ", 
                                "Pifo ", 
                                "Píntag ", 
                                "Pomasqui ", 
                                "Puéllaro ", 
                                "Puembo ", 
                                "San Antonio ", 
                                "San José De Minas ", 
                                "Tababela ", 
                                "Tumbaco ", 
                                "Yaruquí ", 
                                "Zámbiza ", 
                                "Cayambe, Cabecera Cantonal ", 
                                "Ascázubi ", 
                                "Cangahua ", 
                                "Olmedo ", 
                                "Otón ", 
                                "Santa Rosa De Cuzubamba ", 
                                "San José De Ayora ", 
                                "Machachi, Cabecera Cantonal ", 
                                "Aloag ", 
                                "Aloasí ", 
                                "Cutuglahua ", 
                                "El Chaupi ", 
                                "Manuel Cornejo Astorga ", 
                                "Tambillo ", 
                                "Uyumbicho ", 
                                "Tabacundo, Cabecera Cantonal ", 
                                "La Esperanza ", 
                                "Malchinguí ", 
                                "Tocachi ", 
                                "Tupigachi ", 
                                "Sangolquí, Cabecera Cantonal ", 
                                "Cotogchoa ", 
                                "Rumipamba ", 
                                "San Miguel De Los Bancos, Cabecera Cantonal ", 
                                "Mindo ", 
                                "Pedro Vicente Maldonado, Cabecera Cantonal ", 
                                "Puerto Quito, Cabecera Cantonal ", 
                                "Ambato, Cabecera Cantonal ", 
                                "Ambatillo ", 
                                "Atahualpa ", 
                                "Augusto N. Martínez ", 
                                "Constantino Fernández ", 
                                "Huachi Grande ", 
                                "Izamba ", 
                                "Juan Benigno Vela ", 
                                "Montalvo ", 
                                "Pasa ", 
                                "Picaihua ", 
                                "Pilagüín ", 
                                "Quisapincha ", 
                                "San Bartolomé De Pinllo ", 
                                "San Fernando ", 
                                "Santa Rosa ", 
                                "Totoras ", 
                                "Cunchibamba ", 
                                "Unamuncho ", 
                                "Baños, Cabecera Cantonal ", 
                                "Lligua ", 
                                "Río Negro ", 
                                "Río Verde ", 
                                "Ulba ", 
                                "Cevallos, Cabecera Cantonal ", 
                                "Mocha, Cabecera Cantonal ", 
                                "Pinguilí ", 
                                "Patate, Cabecera Cantonal ", 
                                "El Triunfo ", 
                                "Los Andes ", 
                                "Sucre ", 
                                "Quero, Cabecera Cantonal ", 
                                "Rumipamba ", 
                                "Yanayacu Mochapata ", 
                                "Pelileo, Cabecera Cantonal ", 
                                "Benítez ", 
                                "Bolívar ", 
                                "Cotaló ", 
                                "Chiquicha ", 
                                "El Rosario ", 
                                "García Moreno ", 
                                "Guambaló ", 
                                "Salasaca ", 
                                "Píllaro, Cabecera Cantonal ", 
                                "Baquerizo Moreno ", 
                                "Emilio María Terán ", 
                                "Marcos Espinel ", 
                                "Presidente Urbina ", 
                                "San Andrés ", 
                                "San José De Poaló ", 
                                "San Miguelito ", 
                                "Tisaleo, Cabecera Cantonal ", 
                                "Quinchicoto ", 
                                "Zamora, Cabecera Cantonal ", 
                                "Cumbaratza ", 
                                "Guadalupe ", 
                                "Imbana ", 
                                "Sabanilla ", 
                                "Timbara ", 
                                "San Carlos De Las Minas ", 
                                "Zumba, Cabecera Cantonal ", 
                                "Chito ", 
                                "El Chorro ", 
                                "La Chonta ", 
                                "Pucapamba ", 
                                "San Andrés ", 
                                "Guayzimi, Cabecera Cantonal ", 
                                "Zurmi ", 
                                "Nuevo Paraíso ", 
                                "Nankais ", 
                                "28 De Mayo, Cabecera Cantonal ", 
                                "La Paz ", 
                                "Tutupali ", 
                                "Yantzaza, Cabecera Cantonal ", 
                                "Chicaña ", 
                                "Los Encuentros ", 
                                "El Pangui, Cabecera Cantonal ", 
                                "El Guisme ", 
                                "Pachicutza ", 
                                "Tundayme ", 
                                "Zumbi, Cabecera Cantonal ", 
                                "Triunfo Dorado ", 
                                "Panguintza ", 
                                "Palanda, Cabecera Cantonal ", 
                                "El Porvenir Del Carmen ", 
                                "San Francisco Del Vergel ", 
                                "Valladolid ", 
                                "La Canela ", 
                                "Paquisha, Cabecera Cantonal ", 
                                "Bellavista ", 
                                "Nuevo Quito ", 
                                "Puerto Baquerizo Moreno, Cabecera Cantonal ", 
                                "El Progreso ", 
                                "Isla Santa María Floreana ", 
                                "Puerto Villamil, Cabecera Cantonal ", 
                                "Tomás De Berlanga ", 
                                "Puerto Ayora, Cabecera Cantonal ", 
                                "Bella Vista ", 
                                "Santa Rosa ", 
                                "Nueva Loja, Cabecera Cantonal ", 
                                "Dureno ", 
                                "General Farfán ", 
                                "El Eno ", 
                                "Pacayacu ", 
                                "Jambelí ", 
                                "Santa Cecilia ", 
                                "10 De Agosto ", 
                                "Lumbaquí, Cabecera Cantonal ", 
                                "El Reventador ", 
                                "Gonzalo Pizarro ", 
                                "Puerto Libre ", 
                                "Puerto El Carmen De Putumayo, Cabecera Cantonal ", 
                                "Palma Roja ", 
                                "Puerto Bolívar ", 
                                "Puerto Rodríguez ", 
                                "Santa Elena ", 
                                "Sansahuari ", 
                                "Shushufindi, Cabecera Cantonal ", 
                                "Limoncocha ", 
                                "Pañacocha ", 
                                "San Roque ", 
                                "San Pedro De Los Cofánes ", 
                                "Siete De Julio ", 
                                "La Bonita, Cabecera Cantonal ", 
                                "El Playón De San Francisco ", 
                                "La Sofía ", 
                                "Rosa Florida ", 
                                "Santa Bárbara ", 
                                "El Dorado De Cascales, Cabecera Cantonal ", 
                                "Santa Rosa De Sucumbíos ", 
                                "Sevilla ", 
                                "Nueva Troncal ", 
                                "Tarapoa, Cabecera Cantonal ", 
                                "Cuyabeno ", 
                                "Aguas Negras ", 
                                "El Coca (Puerto Francisco De Orellana), Cabecera Cantonal ", 
                                "Dayuma ", 
                                "Taracoa ", 
                                "Alejandro Labaka ", 
                                "El Dorado ", 
                                "El Edén ", 
                                "García Moreno ", 
                                "Inés Arango ", 
                                "La Belleza ", 
                                "Nuevo Paraíso ", 
                                "San José De Guayusa ", 
                                "San Luis De Armenia ", 
                                "Nuevo Rocafuerte, Cabecera Cantonal ", 
                                "Capitán Augusto Rivadeneyra ", 
                                "Cononaco ", 
                                "Santa María De Huiririma ", 
                                "Yasuní ", 
                                "La Joya De Los Sachas, Cabecera Cantonal ", 
                                "Enokanqui ", 
                                "Pompeya ", 
                                "San Carlos ", 
                                "San Sebastián Del Coca ", 
                                "Lago San Pedro ", 
                                "Rumipamba ", 
                                "Tres De Noviembre ", 
                                "Unión Milagreña ", 
                                "Loreto, Cabecera Cantonal ", 
                                "Ávila ", 
                                "Puerto Murialdo ", 
                                "San José De Payamino ", 
                                "San José De Dahuano ", 
                                "San Vicente De Huaticocha ", 
                                "Santo Domingo De Los Colorados, Cabecera Cantonal ", 
                                "Alluriquín ", 
                                "Puerto Limón ", 
                                "Luz De América ", 
                                "San Jacinto Del Búa ", 
                                "Valle Hermoso ", 
                                "El Esfuerzo ", 
                                "Santa María Del Toachi ", 
                                "La Concordia, Cabecera Cantonal ", 
                                "Monterrey ", 
                                "La Villegas ", 
                                "Plan Piloto ", 
                                "Santa Elena, Cabecera Cantonal ", 
                                "Atahualpa ", 
                                "Colonche ", 
                                "Chanduy ", 
                                "Manglaralto ", 
                                "Simón Bolívar ", 
                                "San José De Ancón ", 
                                "La Libertad, Cabecera Cantonal ", 
                                "Salinas, Cabecera Cantonal ", 
                                "Anconcito ", 
                                "José Luis Tamayo ", 
                                "Juval (Cañar-Chimborazo) ", 
                                "Bellavista ", 
                                "Cañaribamba ", 
                                "El Batán ", 
                                "El Sagrario ", 
                                "El Vecino ", 
                                "Gil Ramírez Dávalos ", 
                                "Huaynacápac ", 
                                "Machángara ", 
                                "Monay ", 
                                "San Blas ", 
                                "San Sebastián ", 
                                "Sucre ", 
                                "Totoracocha  ", 
                                "Yanuncay ", 
                                "Hermano Miguel ", 
                                "Ángel Polibio Cháves ", 
                                "Gabriel Ignacio Veintimilla ", 
                                "Guanujo ", 
                                "Las Mercedes ", 
                                "Las Naves ", 
                                "Aurelio Bayas Martínez ", 
                                "Azogues ", 
                                "Borrero ", 
                                "San Francisco ", 
                                "González Suárez ", 
                                "Tulcán ", 
                                "El Ángel ", 
                                "27 De Septiembre ", 
                                "González Suárez ", 
                                "San José ", 
                                "Eloy Alfaro  (San Felipe)  ", 
                                "Ignacio Flores (Parque Flores)  ", 
                                "Juan Montalvo (San Sebastián) ", 
                                "La Matriz ", 
                                "San Buenaventura ", 
                                "El Carmen ", 
                                "La Maná  ", 
                                "El Triunfo ", 
                                "Lizarzaburu ", 
                                "Maldonado ", 
                                "Velasco ", 
                                "Veloz ", 
                                "Yaruquíes ", 
                                "Cajabamba ", 
                                "Sicalpa ", 
                                "El Rosario ", 
                                "La Matriz ", 
                                "La Providencia ", 
                                "Machala ", 
                                "Puerto Bolívar ", 
                                "Nueve De Mayo ", 
                                "El Cambio ", 
                                "Ecuador ", 
                                "El Paraíso ", 
                                "Hualtaco ", 
                                "Milton Reyes ", 
                                "Unión Lojana ", 
                                "Bolívar ", 
                                "Loma De Franco ", 
                                "Ochoa León (Matriz) ", 
                                "Tres Cerritos ", 
                                "La Matriz ", 
                                "La Susaya ", 
                                "Piñas Grande ", 
                                "Santa Rosa ", 
                                "Puerto Jelí ", 
                                "Balneario Jambelí (Satélite) ", 
                                "Jumón (Satélite) ", 
                                "Nuevo Santa Rosa ", 
                                "La Victoria ", 
                                "Platanillos ", 
                                "Valle Hermoso ", 
                                "Bartolomé Ruiz (César Franco Carrión)  ", 
                                "5 De Agosto ", 
                                "Esmeraldas ", 
                                "Luis Tello  (Las Palmas) ", 
                                "Simón Plata Torres ", 
                                "Ayacucho ", 
                                "Bolívar  (Sagrario)  ", 
                                "Carbo (Concepción)  ", 
                                "Febres Cordero ", 
                                "García Moreno ", 
                                "Letamendi ", 
                                "Nueve De Octubre ", 
                                "Olmedo  (San Alejo)  ", 
                                "Roca ", 
                                "Rocafuerte ", 
                                "Sucre ", 
                                "Tarqui ", 
                                "Urdaneta ", 
                                "Ximena ", 
                                "Pascuales ", 
                                "Daule ", 
                                "La Aurora (Satélite) ", 
                                "Banife ", 
                                "Emiliano Caicedo Marcos ", 
                                "Magro ", 
                                "Padre Juan Bautista Aguirre ", 
                                "Santa Clara ", 
                                "Vicente Piedrahita ", 
                                "Eloy Alfaro (Durán) ", 
                                "El Recreo ", 
                                "Divino Niño ", 
                                "Camilo Andrade ", 
                                "Eloy Alfaro ", 
                                "Chirijos ", 
                                "Coronel Enrique Valdez ", 
                                "Rosa María ", 
                                "José María Velasco Ibarra ", 
                                "Vicente Rocafuerte ", 
                                "Ernesto Seminario ", 
                                "Las Piñas ", 
                                "Samborondón ", 
                                "La Puntilla (Satélite) ", 
                                "Bocana ", 
                                "Candilejos ", 
                                "Central ", 
                                "Paraíso ", 
                                "San Mateo ", 
                                "Caranqui ", 
                                "Guayaquil De Alpachaca ", 
                                "Sagrario ", 
                                "San Francisco ", 
                                "La Dolorosa Del Priorato ", 
                                "Andrade Marín  (Lourdes)  ", 
                                "Atuntaqui ", 
                                "Sagrario ", 
                                "San Francisco ", 
                                "Jordán ", 
                                "San Luis ", 
                                "El Sagrario ", 
                                "San Sebastián ", 
                                "Sucre ", 
                                "Valle ", 
                                "Carigán ", 
                                "Punzara ", 
                                "Cariamanga ", 
                                "Chile ", 
                                "San Vicente ", 
                                "Catamayo ", 
                                "San José ", 
                                "General Eloy Alfaro (San Sebastián)  ", 
                                "Macará  (Manuel Enrique Rengel Suquilanda) ", 
                                "Catacocha ", 
                                "Lourdes ", 
                                "Clemente Baquerizo ", 
                                "Doctor Camilo Ponce  ", 
                                "Barreiro ", 
                                "El Salto ", 
                                "Quevedo ", 
                                "San Camilo ", 
                                "Guayacán ", 
                                "Nicolás Infante Díaz ", 
                                "San Cristóbal ", 
                                "Siete De Octubre ", 
                                "24 De Mayo ", 
                                "Venus Del Río Quevedo ", 
                                "Viva Alfaro ", 
                                "10 De Noviembre ", 
                                "Ventanas ", 
                                "Balzar De Vinces ", 
                                "Vinces Central ", 
                                "San Lorenzo De Vinces ", 
                                "San Jacinto De Buena Fe ", 
                                "7 De Agosto ", 
                                "11 De Octubre ", 
                                "Valencia ", 
                                "La Unión ", 
                                "La Nueva Unión ", 
                                "Portoviejo ", 
                                "12 De Marzo ", 
                                "Colón ", 
                                "Picoazá ", 
                                "San Pablo ", 
                                "Andrés De Vera ", 
                                "Francisco Pacheco ", 
                                "18 De Octubre ", 
                                "Simón Bolívar ", 
                                "Chone ", 
                                "Santa Rita ", 
                                "El Carmen ", 
                                "4 De Diciembre ", 
                                "Doctor Miguel Morán Lucio  ", 
                                "Manuel Inocencio Parrales Y Guale ", 
                                "San Lorenzo De Jipijapa ", 
                                "Los Esteros ", 
                                "Manta ", 
                                "San Mateo ", 
                                "Tarqui ", 
                                "Eloy Alfaro ", 
                                "Aníbal San Andrés ", 
                                "Montecristi ", 
                                "El Colorado ", 
                                "General Eloy Alfaro ", 
                                "Leonidas Proaño ", 
                                "Isabel Muentes ", 
                                "Santa Ana ", 
                                "Lodana ", 
                                "Bahía De Caráquez ", 
                                "Leonidas Plaza Gutiérrez ", 
                                "Gualaquiza ", 
                                "Mercedes Molina ", 
                                "Belisario Quevedo ", 
                                "Carcelén ", 
                                "Centro Histórico ", 
                                "Cochapamba ", 
                                "Comité Del Pueblo ", 
                                "Cotocollao ", 
                                "Chilibulo ", 
                                "Chillogallo ", 
                                "Chimbacalle ", 
                                "El Condado ", 
                                "Guamaní ", 
                                "Iñaquito ", 
                                "Itchimbia ", 
                                "Jipijapa ", 
                                "Kennedy ", 
                                "La Argelia ", 
                                "La Concepción ", 
                                "La Ecuatoriana ", 
                                "La Ferroviaria ", 
                                "La Libertad ", 
                                "La Magdalena ", 
                                "La Mena ", 
                                "Mariscal Sucre ", 
                                "Ponceano ", 
                                "Puengasí ", 
                                "Quitumbe ", 
                                "Rumipamba ", 
                                "San Bartolo ", 
                                "San Isidro Del Inca ", 
                                "San Juan ", 
                                "Solanda ", 
                                "Turubamba ", 
                                "Cayambe ", 
                                "Juan Montalvo ", 
                                "Sangolquí ", 
                                "San Pedro De Taboada ", 
                                "San Rafael ", 
                                "Fajardo ", 
                                "Atocha – Ficoa ", 
                                "Celiano Monge ", 
                                "Huachi Chico ", 
                                "Huachi Loreto ", 
                                "La Merced ", 
                                "La Península ", 
                                "Matriz ", 
                                "Pishilata ", 
                                "San Francisco ", 
                                "Pelileo ", 
                                "Pelileo Grande ", 
                                "Ciudad Nueva ", 
                                "Píllaro ", 
                                "El Limón ", 
                                "Zamora ", 
                                "Nuevo Rocafuerte ", 
                                "Tiputini ", 
                                "Abraham Calazacón ", 
                                "Bombolí ", 
                                "Chiguilpe ", 
                                "Río Toachi ", 
                                "Río Verde ", 
                                "Santo Domingo De Los Colorados ", 
                                "Zaracay ", 
                                "Ballenita ", 
                                "Santa Elena ", 
                                "Carlos Espinoza Larrea ", 
                                "General Alberto Enríquez Gallo ", 
                                "Vicente  Rocafuerte ", 
                                "Santa Rosa ", 
                                "Exterior ", 
                                "Las Golondrinas ", 
                                "El Piedrero ", 
                                "Santa Rosa de Agua Clara ", 
                                "Abdón Calderón ", 
                                "Matilde Esther "
                     ),
                     ordered = FALSE)

df <- df %>%
  mutate(total = 1)
attr(df$total,"label") <- "Total Establecimientos."
as.numeric(df$total)


# Valores para el sector 

df <- df %>%
mutate(sector1 = if_else((sector == 1 ) == 1,"1","2"))

df$sector1 <- factor(df$sector1,
                    levels=c(1,2),
                    labels=c("Sector Público","Sector Privado"))


labelled::var_label(df$sector) <- "Sector"  
df$sector <- factor(df$sector, levels = c(1, 2, 3),   
                    labels = c("Sector público", "Privados con fines de lucro",   
                               "Privados sin fines de lucro")) 

# Añadiendo etiquetas para la variable 'tipo' 

df$tipo1 <- NA  # Inicializar la variable tipo  

labelled::var_label(df$tipo1) <- "Tipo"  
df$tipo1 <- factor(df$tipo1, levels = c(1, 2, 3, 4, 5),   
                    labels = c("Agudo", "Crónico",   
                               "Clínicas Generales sin especialidad",   
                               "Establecimientos sin internación",   
                               "Sin Tipo (Hospitales Básicos)"))  


# Añadiendo etiquetas para la variable 'clase'  

df <- df %>%  
  mutate(clase = factor(clase,   
                        levels = c("01", "02", "03", "04", "05", "06", "07", "08", "09", "10",   
                                   "11", "12", "13", "14", "15", "16", "17", "20", "21", "22",   
                                   "23", "24", "25", "26", "27", "28", "29", "30", "31", "32",   
                                   "33", "34", "35"),   
                        labels = c("Hospital Básico", "Hospital General", "Infectología",   
                                   "Gineco-Obstétrico", "Pediátrico",   
                                   "Psiquiatríco y Sanatorios de Alcohólicos", "Dermatológico",   
                                   "Oncológico", "Neumológico", "Geriátrico",   
                                   "Hospital de Especialidades",   
                                   "Clinica General( Sin Especialidad)",   
                                   "Gíneco Obstetricia", "Pediatría", "Traumatología",   
                                   "Psiquiatría", "Otras Clínicas Especializadas",   
                                   "Puesto de Salud", "Subcentro de Salud",   
                                   "Centro de Salud A", "Centro de Salud B",   
                                   "Centro de Salud C", "Dispensario Médico (Policlínico)",   
                                   "Consultorio General", "Consultorio de Especialidad",   
                                   "Centro de Especialidades",   
                                   "Centro Clínico-Quirúrgico (Hospital del Día)",   
                                   "Centros Especializados",   
                                   "Otros Establecimientos Sin Internación",   
                                   "Hospitales del Día Con Internación",   
                                   "Ancianatos Casas Hogares",   
                                   "Establecimientos de Alquiler de Quirofanos",   
                                   "Establecimientos de Alquiler de Consultorios"))
         )  

df <- df %>% 
  mutate(entidad = factor(entidad, 
                    levels = c("01" , "02", "03", "04", "05", "06", "07", "08", "09", "10",
                               "11", "12", "13", "14", "15", "16", "17", "18"),
                    labels = c("Ministerio de Salud Público", "Ministerio de Justicia, derechos humanos y cultos", "Ministerio de Defensa Nacional",
                               "Ministerio de Educación", "Otros Ministerios", "Instituto Ecuatoriano de Seguridad Social",
                               "Anexos al Sesuro Social", "Seguro Social Campesino", "Otros Públicos",
                               "Consejos Provinciales", "Municipios", "Universidades y Politécnicas",
                               "Junta Beneficencia de Guayaquil", "Cruz Roja Ecuatoriana", "Sociedad de Lucha contra el Cáncer",
                               "Fiscomisionales", "Privados sin Fines de Lucro", "Privados con Fines de Lucro"))

  )

df <- df %>%
  mutate(
    tmedicos = { val <- as.numeric(k1);  attr(val, "label") <- " Total médicos "; val },
    tod8 = { val <- k995 + k1000 + k1005 + k1010 + k1015 + k1020 + k1025 + k1030 + k1035 + k1055 + k1060;  attr(val, "label") <- " Total Odontólogos de 8 horas "; val },
    tod6 = { val <- k996 + k1001 + k1006 + k1011 + k1016 + k1021 + k1026 + k1031 + k1036 + k1056 + k1061;  attr(val, "label") <- " Total Odontólogos de 6 horas "; val },
    tod4 = { val <- k997  + k1002 + k1007 + k1012 + k1017 + k1022 + k1027 + k1032 + k1037 + k1057 + k1062;  attr(val, "label") <- " Total Odontólogos de 4 horas "; val },
    todmenos4 = { val <- k998 + k1003 + k1008 + k1013 + k1018 + k1023 + k1028 + k1033 + k1038 + k1058 + k1063;  attr(val, "label") <- " Total Odontólogos Eventual o de llamada menor a 4 horas "; val },
    todont = { val <- tod8 + tod6 + tod4 + todmenos4;  attr(val, "label") <- " Total Odontólogos "; val },
    tpsic8 = { val <- k227 + k262a + k262b;  attr(val, "label") <- " Total Psicólogos 8 horas "; val },
    tpsic6 = { val <- k228 + k263a + k263b;  attr(val, "label") <- " Total Psicólogos 6 horas "; val },
    tpsic4 = { val <- k229 + k264a + k264b;  attr(val, "label") <- " Total Psicólogos 4 horas "; val },
    tpsicmenos4 = { val <- k230 + k265a + k265b;  attr(val, "label") <- " Total psicólogo Eventual o de llamada o menor a 4 horas "; val },
    tpsic = { val <- tpsic8 + tpsic6 + tpsic4 + tpsicmenos4;  attr(val, "label") <- " Total psicólogo "; val },
    tenf8 = { val <- k212 + k217;  attr(val, "label") <- " Total Enfermeras de 8 horas "; val },
    tenf6 = { val <- k213 + k218;  attr(val, "label") <- " Total Enfermeras de 6 horas "; val },
    tenf4 = { val <- k214 + k219;  attr(val, "label") <- " Total Enfermeras de 4 horas "; val },
    tenfmenos4 = { val <- k215 + k220;  attr(val, "label") <- " Total Enfermeras Eventuales o de llamada o menor a 4 horas "; val },
    tenf = { val <- tenf8 + tenf6 + tenf4 + tenfmenos4;  attr(val, "label") <- " Total Enfermeras "; val },
    tobst8 = { val <- k202 + k207;  attr(val, "label") <- " Total Obstetrices de 8 horas "; val },
    tobst6 = { val <- k203 + k208;  attr(val, "label") <- " Total Obstetrices de 6 horas "; val },
    tobst4 = { val <- k204 + k209;  attr(val, "label") <- " Total Obstetrices de 4 horas "; val },
    tobstmenos4 = { val <- k205 + k210;  attr(val, "label") <- " Total Obstetrices Eventuales o de llamada o menor a 4 horas "; val },
    tobst = { val <- tobst8 + tobst6 + tobst4 + tobstmenos4;  attr(val, "label") <- " Total Obstetrices "; val },
    tauxenf8 = { val <- as.numeric(k312);  attr(val, "label") <- " Total Auxiliares de Enfermería de 8 horas "; val },
    tauxenf6 = { val <- as.numeric(k313);  attr(val, "label") <- " Total Auxiliares de Enfermería de 68 horas "; val },
    tauxenf4 = { val <- as.numeric(k314);  attr(val, "label") <- " Total Auxiliares de Enfermería de 4 horas "; val },
    tauxenfmenos4 = { val <- as.numeric(k315);  attr(val, "label") <- " Total Auxiliares de Enfermería Eventual o de llamada o menor a 4 horas "; val },
    tauxenf = { val <- tauxenf8 + tauxenf6 + tauxenf4 + tauxenfmenos4;  attr(val, "label") <- " Total Auxiliares de Enfermería "; val },
    tk1 = { val <- k1 - k6 - k176 - k181 - k186;  attr(val, "label") <- " Médicos Especialistas "; val },
    tk2 = { val <- as.numeric(k6);  attr(val, "label") <- " Médicos Generales "; val },
    tk3 = { val <- as.numeric(k176);  attr(val, "label") <- " Médicos Postgradistas "; val },
    tk4 = { val <- as.numeric(k181);  attr(val, "label") <- " Médicos Residentes "; val },
    tk5 = { val <- as.numeric(k186);  attr(val, "label") <- " Médicos Rurales "; val },
    tk6 = { val <- k994 + k999 + k1004 + k1009 + k1014 + k1019 + k1024 + k1029 + k1034 + k1054 + k1059;  attr(val, "label") <- " Odontólogos "; val },
    tk7 = { val <- k201 + k206;  attr(val, "label") <- " Obtetrices "; val },
    tk8 = { val <- k211 + k216;  attr(val, "label") <- " Enfermeras "; val },
    tk16 = { val <- k226 + k261a + k261b;  attr(val, "label") <- " Psicólogos "; val },
    tk9 = { val <- k221 + k231 + k236 + k241 + k246 + k261c + k251 + k256 + k261;  attr(val, "label") <- " Otros Profesionales "; val },
    tk10 = { val <- k271 + k276 + k281 + k286 + k291 + k296 + k301 + k301a + k306 + k1049;  attr(val, "label") <- " Licenciados y/o Tecnólogos "; val },
    tk11 = { val <- k316 + k321;  attr(val, "label") <- " Auxiliares de Enfermería "; val },
    tk12 = { val <- k331 + k336 + k341 + k346 + k351 + k1039 + k1044;  attr(val, "label") <- " Auxiliares de servicio técnico "; val },
    tk13 = { val <- k401 + k406 + k411 + k416a + k416 + k461;  attr(val, "label") <- " Personal de Apoyo Sanitario "; val },
    tk14 = { val <- k361 + k366 + k371 + k376 + k381 + k386 + k391 + k391a + k391b + k391c + k391d + k391e + k391f + k391g;  attr(val, "label") <- " Administrativo y Estadística "; val },
    tk15 = { val <- k426 + k431 + k436 + k441 + k446 + k451 + k456;  attr(val, "label") <- " De Servicio "; val },
    tper = { val <- tk1 + tk2 + tk3 + tk4 + tk5 + tk6 + tk7 + tk8 + tk9 + tk10 + tk11 + tk12 + tk13 + tk14 + tk15 + tk16;  attr(val, "label") <- " Total Persona "; val },
    t8hes = { val <- k2 - k177 - k182 - k187;  attr(val, "label") <- "  Médicos Especialistas 8 Horas diarias "; val },
    t6hes = { val <- k3 - k178 - k183 - k188;  attr(val, "label") <- " Médicos Especialistas 6 Horas diarias "; val },
    t4hes = { val <- k4 - k179 - k184 - k189;  attr(val, "label") <- " Médicos Especialistas 4 Horas diarias "; val },
    tevenes = { val <- k5 - k180 - k185 - k190;  attr(val, "label") <- " Médicos Especialistas Eventual o de llamada o menor a 4 horas diarias "; val },
    total1 = { val <- t8hes + t6hes + t4hes + tevenes;  attr(val, "label") <- " Total Médicos Especialistas "; val },
    t8hpos = { val <- k177 + k182 + k187;  attr(val, "label") <- " Médicos Postgradistas, Residentes, Rurales 8 horas diarias "; val },
    t6hpos = { val <- k178 + k183 + k188;  attr(val, "label") <- " Médicos Postgradistas, Residentes, Rurales 6 horas diarias "; val },
    t4hpos = { val <- k179 + k184 + k189;  attr(val, "label") <- " Médicos Postgradistas, Residentes, Rurales 4 horas diarias "; val },
    tevenpos = { val <- k180 + k185 + k190;  attr(val, "label") <- "  Médicos Postgradistas, Residentes, Rurales Eventual o llamada o menor a 4 horas diarias  "; val },
    total2 = { val <- t8hpos + t6hpos + t4hpos + tevenpos;  attr(val, "label") <- " Total Médicos Postgradistas, Residentes, Rurales "; val },
    t8ho = { val <- k995 + k1000 + k1005 + k1010 + k1015 + k1020 + k1025 + k1030 + k1035 + k1055 + k1060;  attr(val, "label") <- " Odontólogos 8 horas diarias "; val },
    t6ho = { val <- k996 + k1001 + k1006 + k1011 + k1016 + k1021 + k1026 + k1031 + k1036 + k1056 + k1061;  attr(val, "label") <- " Odontólogos 6 horas diarias "; val },
    t4ho = { val <- k997 + k1002 + k1007 + k1012 + k1017 + k1022 + k1027 + k1032 + k1037 + k1057 + k1062;  attr(val, "label") <- " Odontólogos 4 horas diarias "; val },
    teveo = { val <- k998 + k1003 + k1008 + k1013 + k1018 + k1023 + k1028 + k1033 + k1038 + k1058 + k1063;  attr(val, "label") <- " Odontólogos Eventual o de llamada o menor a 4 horas diarias "; val },
    totodo = { val <- t8ho + t6ho + t4ho + teveo;  attr(val, "label") <- " Total Odontólogos "; val },
    t8hp = { val <- k202 + k207 + k212 + k217 + k222 + k227 + k262a + k262b + k232 + k237 + k242 + k247 + k262c + k252 + k257 + k262;  attr(val, "label") <- " Otros profesionales 8 horas diarias "; val },
    t6hp = { val <- k203 + k208 + k213 + k218 + k223 + k228 + k263a + k263b + k233 + k238 + k243 + k248 + k263c + k253 + k258 + k263;  attr(val, "label") <- " Otros profesionales 6 horas diarias "; val },
    t4hp = { val <- k204 + k209 + k214 + k219 + k224 + k229 + k264a + k264b + k234 + k239 + k244 + k249 + k264c + k254 + k259 + k264;  attr(val, "label") <- " Otros profesionales 4 horas diarias "; val },
    tevep = { val <- k205 + k210 + k215 + k220 + k225 + k230 + k265a + k265b + k235 + k240 + k245 + k250 + k265c + k255 + k260 + k265;  attr(val, "label") <- " Otros profesionales Eventual o de llamada o menor a 4 horas diarias "; val },
    totop = { val <- t8hp + t6hp + t4hp + tevep;  attr(val, "label") <- " Total Otros profesionales "; val },
    lab2 = { val <- k156 + k161 + k166;  attr(val, "label") <- " Laboratorio "; val },
    teod = { val <- k994 + k999 + k1004 + k1009 + k1014 + k1019 + k1024 + k1029 + k1034 + k1054 + k1059;  attr(val, "label") <- " Total Especialistas Odontólogos "; val },
    op1 = { val <- k241 + k246;  attr(val, "label") <- " Bioquímicos y químicos farmacéuticos "; val },
    op11 = { val <- as.numeric(k261c);  attr(val, "label") <- " Microbiólogos "; val },
    op2 = { val <- k201 + k206;  attr(val, "label") <- " Obstetrices "; val },
    op3 = { val <- k211 + k216;  attr(val, "label") <- " Enfermeras "; val },
    op4 = { val <- as.numeric(k221);  attr(val, "label") <- " Nutricionistas "; val },
    op5 = { val <- k226 + k261a + k262a;  attr(val, "label") <- " Psicólogos y Psicorehabilitadors "; val },
    op6 = { val <- as.numeric(k231);  attr(val, "label") <- " Educadores para la salud "; val },
    op7 = { val <- as.numeric(k251);  attr(val, "label") <- " Trabajadoras sociales "; val },
    op8 = { val <- as.numeric(k236);  attr(val, "label") <- " Ingenieros sanitarios "; val },
    op9 = { val <- as.numeric(k256);  attr(val, "label") <- " Ingenieros ambientales "; val },
    op10 = { val <- as.numeric(k261);  attr(val, "label") <- " Otros profesionales "; val },
    tops = { val <- op1 + op2 + op3 + op4 + op5 + op6 + op7 + op8 + op9 + op10 + op11;  attr(val, "label") <- " Total profesional "; val },
    tlict = { val <- k271 + k276 + k281 + k286 + k291 + k296 + k301 + k301a + k1049 + k306;  attr(val, "label") <- " Total Personal "; val },
    taenfer = { val <- k316 + k321;  attr(val, "label") <- " Total aux. enfermeria "; val },
    tst = { val <- k341 + k346 + k336 + k331 + k1044 + k1039 + k351;  attr(val, "label") <- " Total otros auxiliares "; val },
    tpsa = { val <- k401 + k406 + k411 + k416 + k416a;  attr(val, "label") <- " Total pers. sanitario de apoyo "; val },
    ttotal = { val <- taenfer + tst + tpsa + k461;  attr(val, "label") <- " Total personal "; val },
    tadm = { val <- k361 + k366 + k376 + k381 + k386 + k391 + k391a + k391b + k391c + k391d + k391e + k391f + k391g;  attr(val, "label") <- " Total Personal Administrativo "; val },
    tpserv = { val <- k426 + k431 + k436 + k441 + k446 + k451 + k456;  attr(val, "label") <- " Total Personal de Servicio "; val },
    ttpesad = { val <- k371 + tadm + tpserv;  attr(val, "label") <- " Total Personal "; val },
    tamfis = { val <- k1398 + k1399 + k1400 + k1401;  attr(val, "label") <- " Cunas, termocunas y/o incubadoras "; val },
    tequod = { val <- k978 + k979 + k980 + k981 + k982 + k983 + k984 + k985 + k986 + k987 + k988 + k989 + k990 + k991 + k992 + k992a + k992b + k992c + k992d;  attr(val, "label") <- " Total Equipos Odontológicos "; val },
    mprim = { val <- k509 + k510 + k511 + k552 + k553;  attr(val, "label") <- " Primarias consultas de morbilidad "; val },
    msubs = { val <- k513 + k514 + k515 + k555 + k556;  attr(val, "label") <- "Consultas subsecuentes  de morbilidad "; val },
    tcmps = { val <- mprim + msubs;  attr(val, "label") <- " Total consultas de morbilidad "; val },
    pprim = { val <- k722 + k723 + k724;  attr(val, "label") <- " Primarias consultas de prevención "; val },
    psubs = { val <- k890 + k891 + k892;  attr(val, "label") <- " Consultas subsecuentes de prevención "; val },
    tcpps = { val <- pprim + psubs;  attr(val, "label") <- " Total consultas de prevención "; val },
    tcest = { val <- k1105 + k1106 + k1107;  attr(val, "label") <- " Total consultas de estomatología "; val },
    emer = { val <- k975 + k976;  attr(val, "label") <- " Total de Emergencia "; val },
    tmpest = { val <- tcmps + tcpps + tcest;  attr(val, "label") <- " Total "; val },
    morb = { val <- as.numeric(if_else(tcmps > 0, 1, 0));  attr(val, "label") <- " Morbilidad "; val },
    preve = { val <- as.numeric(if_else(tcpps > 0, 1, 0));  attr(val, "label") <- " Prevención "; val },
    esto = { val <- as.numeric(if_else(tcest > 0, 1, 0));  attr(val, "label") <- " Estomatología "; val },
    temerg = { val <- as.numeric(if_else(emer > 0, 1, 0));  attr(val, "label") <- " Emergencia "; val },
    tmorbmpo = { val <- k505+k506+k507+k549+k550;  attr(val, "label") <- " Total Morbilidad Médico, Obstetriz y Psicólogo "; val },
    e1 = { val <- k466 + k517;  attr(val, "label") <- " Menos de 1 mes "; val },
    e2 = { val <- k468 + k469 + k519 + k520;  attr(val, "label") <- " 1 - 11 meses "; val },
    e3 = { val <- k471 + k472 + k522 + k523;  attr(val, "label") <- " 1 - 4 años "; val },
    e4 = { val <- k474 + k475 + k525 + k526;  attr(val, "label") <- " 5 - 9 años "; val },
    e5 = { val <- k477 + k478 + k479 + k528 + k529;  attr(val, "label") <- " 10 - 14 años "; val },
    e6 = { val <- k481 + k482 + k483 + k531 + k532;  attr(val, "label") <- " 15 - 19 años "; val },
    e7 = { val <- k485 + k486 + k487 + k534 + k535;  attr(val, "label") <- " 20 - 35 años "; val },
    e8 = { val <- k489 + k490 + k491 + k537 + k538;  attr(val, "label") <- " 36 - 49 años "; val },
    e9 = { val <- k493 + k494 + k495 + k540 + k541;  attr(val, "label") <- " 50 - 64 años "; val },
    e10 = { val <- k497 + k498 + k499 + k543 + k544;  attr(val, "label") <- " 65 y más añoss "; val },
    e11 = { val <- k501 + k502 + k503 + k546 + k547;  attr(val, "label") <- " Edad no especificada "; val },
    tconed = { val <- e1 + e2 + e3 + e4 + e5 + e6 + e7 + e8 + e9 + e10 + e11;  attr(val, "label") <- " Total Consultas de morbilidad por grupos de edad "; val },
    tcmm = { val <- k505 + k549;  attr(val, "label") <- " Médicos "; val },
    tcmos = { val <- as.numeric(k506);  attr(val, "label") <- " Obstetriz "; val },
    tcmpsi = { val <- k507 + k550;  attr(val, "label") <- " Psicólogos "; val },
    tcprevpri = { val <- k722 + k723 + k724;  attr(val, "label") <- " Primarias "; val },
    tcprevsub = { val <- k890 + k891 + k892;  attr(val, "label") <- " Subsecuentes "; val },
    tprevps = { val <- tcprevpri + tcprevsub;  attr(val, "label") <- " Total C. Prevención "; val },
    tprv1 = { val <- as.numeric(k650);  attr(val, "label") <- " Menores de 1 año "; val },
    tprv2 = { val <- k652 + k653;  attr(val, "label") <- " 1 - 4 años "; val },
    tprv3 = { val <- k655 + k656;  attr(val, "label") <- " 5 - 9 años "; val },
    tn = { val <- tprv1 + tprv2 + tprv3;  attr(val, "label") <- " Niños "; val },
    tprv4 = { val <- k658 + k659 + k660 + k666 + k667;  attr(val, "label") <- " 10 - 14 años "; val },
    tprv5 = { val <- k662 + k663 + k664 + k669 + k670;  attr(val, "label") <- " 15 - 19 años "; val },
    ta = { val <- tprv4 + tprv5;  attr(val, "label") <- " Adolescentes "; val },
    tprv6 = { val <- k672 + k673 + k674 + k688 + k690;  attr(val, "label") <- " 20 - 35 años "; val },
    tprv7 = { val <- k676 + k677 + k678 + k692 + k694;  attr(val, "label") <- " 36 - 49 años "; val },
    tprv8 = { val <- k680 + k681 + k682 + k696 + k698;  attr(val, "label") <- " 50 - 64 años "; val },
    tprv9 = { val <- k684 + k685 + k686 + k700 + k702;  attr(val, "label") <- " 65 años y más "; val },
    tad = { val <- tprv6 + tprv7 + tprv8 + tprv9;  attr(val, "label") <- " Adultos "; val },
    tprv10 = { val <- k704 + k705;  attr(val, "label") <- " Prenatal 10 - 19 años "; val },
    tpartom = { val <- k707 + k708;  attr(val, "label") <- " Parto(Atención de partos) 10 - 19 años "; val },
    tprv11 = { val <- k710 + k711;  attr(val, "label") <- " Post-parto 10 - 19 años "; val },
    tm = { val <- tprv10 + tpartom + tprv11;  attr(val, "label") <- " Mujeres 10 - 19 años "; val },
    tprv12 = { val <- k713 + k714;  attr(val, "label") <- " Prenatal 20 - 50 años "; val },
    tpartoh = { val <- k716 + k717;  attr(val, "label") <- " Parto(Atención de partos) 20 - 50 año "; val },
    tprv13 = { val <- k719 + k720;  attr(val, "label") <- " Post-parto 20 - 50 años "; val },
    tm1 = { val <- tprv12 + tpartoh + tprv13;  attr(val, "label") <- " Mujeres 20 - 50 años "; val },
    tedad = { val <- k684a + k685a + k686a + k700a + k702a;  attr(val, "label") <- "Edad no especificada "; val },
    tprv14 = { val <- k726 + k727 + k728 + k728aa + k768 + k769 + k770 + k770aa;  attr(val, "label") <- " Dispositivo intrauterino diu "; val },
    tprv32 = { val <- k729a + k730a + k731a + k731aa + k732a + k733a + k734a + k734aa + k771a + k772a + k773a + k773aa + k774a + k775a + k776a + k776aa;  attr(val, "label") <- " Anticonceptivos Orales Combinados "; val },
    tprv33 = { val <- k729b + k730b + k731b + k731bb + k732b + k733b + k734b + k734bb + k771b + k772b + k773b + k773bb + k774b + k775b + k776b + k776bb;  attr(val, "label") <- " Anticonceptivos Orales sólo progesterona "; val },
    tprv34 = { val <- k729c + k730c + k731c + k731cc + k732c + k733c + k734c + k734cc + k771c + k772c + k773c + k773cc + k774c + k775c + k776c + k776cc;  attr(val, "label") <- " Anticonceptivo Oral de emergencia "; val },
    tprv16 = { val <- k735 + k736 + k737 + k737aa + k738 + k739 + k740 + k740aa + k777 + k778 + k779 + k779aa + k780 + k781 + k782 + k782aa;  attr(val, "label") <- " Inyectable "; val },
    tprv17 = { val <- k741 + k742 + k743 + k743aa + k744 + k745 + k746 + k746aa + k783 + k784 + k785 + k785aa + k786 + k787 + k788 + k788aa;  attr(val, "label") <- " Preservativos "; val },
    tprv18 = { val <- k747 + k748 + k749 + k749aa + k789 + k790 + k791 + k791aa;  attr(val, "label") <- " Implantes "; val },
    tprv19 = { val <- k751 + k752 + k752aa;  attr(val, "label") <- " Vasectomía "; val },
    tprv20 = { val <- k754 + k755 + k755aa + k796 + k797 + k797aa;  attr(val, "label") <- " Salpingectomía "; val },
    tprv35 = { val <- k756a + k757a + k758a + k758aa + k798a + k799a + k800a + k800aa;  attr(val, "label") <- " Anillo Vaginal "; val },
    tprv36 = { val <- k756b + k757b + k758b + k758bb + k798b + k799b + k800b + k800bb;  attr(val, "label") <- " Parche Trandérmico "; val },
    tprv37 = { val <- k756 + k757 + k758 + k758aaa + k759 + k760 + k761 + k761aa + k798 + k799 + k800 + k800aaa + k801 + k802 + k803 + k803aa;  attr(val, "label") <- " Otros "; val },
    tprv38 = { val <- k762 + k763 + k764 + k764aa + k765 + k766 + k767 + k767aa + k804 + k805 + k806 + k806aa + k807 + k808 + k809 + k809aa;  attr(val, "label") <- " Total sin metodos desglosados "; val },
    tpf = { val <- tprv14 + tprv32 + tprv33 + tprv34 + tprv16 + tprv17 + tprv18 + tprv19 + tprv20 + tprv35 + tprv36 + tprv37 + tprv38;  attr(val, "label") <- " Planificación familiar "; val },
    tprv23 = { val <- k816 + k817;  attr(val, "label") <- " Cérvicouterino "; val },
    tprv24 = { val <- k818 + k819 + k829;  attr(val, "label") <- " Mamario "; val },
    tprv25 = { val <- as.numeric(k828);  attr(val, "label") <- " Próstata "; val },
    tprv26 = { val <- k820 + k830;  attr(val, "label") <- " Pulmonar "; val },
    tprv27 = { val <- k821 + k831;  attr(val, "label") <- " Gástrico "; val },
    tprv28 = { val <- k822 + k832;  attr(val, "label") <- " Hepático "; val },
    tprv29 = { val <- k823 + k833;  attr(val, "label") <- " Colorrectal "; val },
    tprv30 = { val <- k825 + k834;  attr(val, "label") <- " Piel "; val },
    ttiro = { val <- k825a + k834a;  attr(val, "label") <- " Tiroide "; val },
    tcan = { val <- tprv23 + tprv24 + tprv25 + tprv26 + tprv27 + tprv28 + tprv29 + tprv30 + ttiro;  attr(val, "label") <- " Detección oportuna del cáncer "; val },
    ttotr = { val <- k825b + k834b + k834c;  attr(val, "label") <- " Otros "; val },
    tprv31 = { val <- k707 + k708 + k716 + k717;  attr(val, "label") <- " Total Auxiliares de Enfermería de 8 horas "; val },
    tsk1 = { val <- as.numeric(k836);  attr(val, "label") <- " Menores de 1 año "; val },
    tsk2 = { val <- k838 + k839;  attr(val, "label") <- " 1 - 4 años "; val },
    tsk3 = { val <- k841 + k842;  attr(val, "label") <- " 5 - 9 años "; val },
    tsn = { val <- tsk1 + tsk2 + tsk3;  attr(val, "label") <- " Niños "; val },
    tsk4 = { val <- k844 + k845 + k846 + k852 + k853;  attr(val, "label") <- " 10 - 14 años "; val },
    tsk5 = { val <- k848 + k849 + k850 + k855 + k856;  attr(val, "label") <- " 15 - 19 años "; val },
    tsad = { val <- tsk4 + tsk5;  attr(val, "label") <- " Adolescentes "; val },
    tsk6 = { val <- k858 + k859 + k860 + k874 + k875;  attr(val, "label") <- " 20 - 35 años "; val },
    tsk7 = { val <- k862 + k863 + k864 + k877 + k878;  attr(val, "label") <- " 36 - 49 años "; val },
    tsk8 = { val <- k866 + k867 + k868 + k880 + k881;  attr(val, "label") <- " 50 - 64 años "; val },
    tsk9 = { val <- k870 + k871 + k872 + k883 + k884;  attr(val, "label") <- " 65 años y más "; val },
    tsadu = { val <- tsk6 + tsk7 + tsk8 + tsk9;  attr(val, "label") <- " Adultos "; val },
    tsk10 = { val <- k886 + k887;  attr(val, "label") <- " Prenatal 10 - 19 años "; val },
    tsk11 = { val <- k888 + k889;  attr(val, "label") <- " Prenatal 20 - 49 años "; val },
    tsmu = { val <- tsk10 + tsk11;  attr(val, "label") <- " Mujeres "; val },
    tedads = { val <- k870a + k871a + k872a + k883a + k884a;  attr(val, "label") <- " Edad no especificada "; val },
    tspc = { val <- tsn + tsad + tsadu + tsmu + tedads;  attr(val, "label") <- " Consultas Subsecuentes "; val },
    tsk12 = { val <- k894 + k895 + k896 + k896aa + k930 + k931 + k932 + k932aa;  attr(val, "label") <- " Dispositivo intrauterino diu "; val },
    tsk13 = { val <- k897a + k898a + k899a + k899aa + k900a + k901a + k902a + k902aa + k933a + k934a + k935a + k935aa + k936a + k937a + k938a + k938aa;  attr(val, "label") <- " Anticonceptivos Orales Combinados "; val },
    tsk19 = { val <- k897b + k898b + k899b + k899bb + k900b + k901b + k902b + k902bb + k933b + k934b + k935b + k935bb + k936b + k937b + k938b + k938bb;  attr(val, "label") <- " Anticonceptivos Orales sólo progesterona "; val },
    tsk20 = { val <- k897c + k898c + k899c + k899cc + k900c + k901c + k902c + k902cc + k933c + k934c + k935c + k935cc + k936c + k937c + k938c + k938cc;  attr(val, "label") <- "Anticonceptivo Oral de emergencia "; val },
    tsk14 = { val <- k903 + k904 + k905 + k905aa + k906 + k907 + k908 + k908aa + k939 + k940 + k941 + k941aa + k942 + k943 + k944 + k944aa;  attr(val, "label") <- " Inyectable "; val },
    tsk15 = { val <- k909 + k910 + k911 + k911aa + k912 + k913 + k914 + k914aa + k945 + k946 + k947 + k947aa + k948 + k949 + k950 + k950aa;  attr(val, "label") <- " Preservativos "; val },
    tsk16 = { val <- k915 + k916 + k917 + k917aa + k951 + k952 + k953 + k953aa;  attr(val, "label") <- " Implantes "; val },
    tsk17 = { val <- k913a + k913b + k913c;  attr(val, "label") <- " Vasectomía "; val },
    tsk18 = { val <- k916a + k917a + k917aaa + k955a + k956a + k956aa;  attr(val, "label") <- " Salpingectomía "; val },
    tsk21 = { val <- k918a + k919a + k920a + k920aa + k954b + k955b + k956b + k956bb;  attr(val, "label") <- " Anillo Vaginal "; val },
    tsk22 = { val <- k918b + k919b + k920b + k920bb + k954c + k955c + k956c + k956cc;  attr(val, "label") <- " Parche Trandérmico "; val },
    tsk23 = { val <- k918 + k919 + k920 + k920aaa + k921 + k922 + k923 + k923aa + k954 + k955 + k956 + k956aaa + k957 + k958 + k959 + k959aa;  attr(val, "label") <- " Otros "; val },
    tsk24 = { val <- k924 + k925 + k926 + k926aa + k927 + k928 + k929 + k929aa + k960 + k961 + k962 + k962aa + k963 + k964 + k965 + k965aa;  attr(val, "label") <- " Total sin metodos desglosados "; val },
    tspf = { val <- tsk12 + tsk13 + tsk19 + tsk20 + tsk14 + tsk15 + tsk16 + tsk17 + tsk18 + tsk21 + tsk22 + tsk23 + tsk24;  attr(val, "label") <- " Planificación familiar "; val },
    tnin = { val <- k1069 + k1072 + k1075;  attr(val, "label") <- " Total Niños "; val },
    tadole = { val <- k1078 + k1084;  attr(val, "label") <- " Total adolescentes "; val },
    tadult = { val <- k1087 + k1090 + k1093 + k1096;  attr(val, "label") <- " Total adultos "; val },
    niños = { val <- as.numeric(if_else(tnin > 0, 1, 0));  attr(val, "label") <- " Niños "; val },
    adolsc = { val <- as.numeric(if_else(tadole > 0, 1, 0));  attr(val, "label") <- " Adolescentes "; val },
    adulto = { val <- as.numeric(if_else(tadult > 0, 1, 0));  attr(val, "label") <- " Adultos "; val },
    tpnin = { val <- k1070 + k1073 + k1076;  attr(val, "label") <- " Total prev. prim. niños "; val },
    tpadole = { val <- k1079 + k1085;  attr(val, "label") <- " Total prev. prim. adolescentes "; val },
    tpadult = { val <- k1088 + k1091 + k1094 + k1097;  attr(val, "label") <- " Total prev. prim. adultos "; val },
    totaln = { val <- tpnin + tpadole + tpadult + k1082 + k1100 + k1103 + k1103a;  attr(val, "label") <- " Total Primarias "; val },
    pniños = { val <- as.numeric(if_else(tpnin > 0, 1, 0));  attr(val, "label") <- " Niños "; val },
    padolsc = { val <- as.numeric(if_else(tpadole > 0, 1, 0));  attr(val, "label") <- " Adolescentes "; val },
    padulto = { val <- as.numeric(if_else(tpadult > 0, 1, 0));  attr(val, "label") <- " Adultos "; val },
    tsnin = { val <- k1071 + k1074 + k1077;  attr(val, "label") <- " Total sub. prev. niños "; val },
    tsadole = { val <- k1080 + k1086;  attr(val, "label") <- " Total sub. prev. adolescs "; val },
    tsadult = { val <- k1089 + k1092 + k1095 + k1098;  attr(val, "label") <- " Total sub. prev. adulto "; val },
    totalsubp = { val <- tsnin + tsadole + tsadult + k1083 + k1101 + k1104 + k1104a;  attr(val, "label") <- " Total Subsecuentes "; val },
    sniños = { val <- as.numeric(if_else(tsnin > 0, 1, 0));  attr(val, "label") <- " Niños "; val },
    sadolsc = { val <- as.numeric(if_else(tsadole > 0, 1, 0));  attr(val, "label") <- " Adolescentes "; val },
    sadulto = { val <- as.numeric(if_else(tsadult > 0, 1, 0));  attr(val, "label") <- " Adultos "; val },
    totalcest = { val <- k1105 + totaln + totalsubp;  attr(val, "label") <- " Total de consultas estomatologia "; val },
    totalpsub = { val <- totaln + totalsubp;  attr(val, "label") <- " Total consultas prevención "; val },
    tcpre = { val <- k1106+k1107;  attr(val, "label") <- " Total Consultas de Prevención"; val },
    tpres = { val <- k1071+k1074+k1077+k1080+k1083+k1086+k1089+k1092+k1095+k1098+k1101+k1104a+k1104;  attr(val, "label") <- " Total Consultas de prevención Subsecuentes "; val },
    hema = { val <- k1127+k1128+k1129;  attr(val, "label") <- " HematologíaMédicos Residentes "; val },
    qsan = { val <- k1131+k1132+k1133;  attr(val, "label") <- " Quimica Sanguinea "; val },
    inm = { val <- k1135+k1136+k1137;  attr(val, "label") <- " Inmunología "; val },
    uro = { val <- k1139+k1140+k1141;  attr(val, "label") <- " Uroanálisis "; val },
    copro = { val <- k1143+k1144+k1145;  attr(val, "label") <- " Coproanálisis "; val },
    micro = { val <- k1147+k1148+k1149;  attr(val, "label") <- " Microbiología "; val },
    hmns = { val <- k1155+k1156+k1157;  attr(val, "label") <- " Hormonas "; val },
    tklg1 = { val <- k1210 + k1211 + k1212 + k1218 + k1219 + k1220 + k1230 + k1231 + k1232 + k1242 + k1243 + k1244;  attr(val, "label") <- " Radiografías "; val },
    tklg2 = { val <- k1214 + k1215 + k1216 + k1254 + k1255 + k1256;  attr(val, "label") <- " Ecografías "; val },
    tklg3 = { val <- k1222 + k1223 + k1224 + k1246 + k1247 + k1248;  attr(val, "label") <- " Tomografías "; val },
    tklg4 = { val <- k1226 + k1227 + k1228 + k1250 + k1251 + k1252;  attr(val, "label") <- " Mamografías "; val },
    tklg5 = { val <- k1234 + k1235 + k1236;  attr(val, "label") <- " Dosimetría ósea "; val },
    tklg6 = { val <- k1238 + k1239 + k1240;  attr(val, "label") <- " Resonancia magnética nuclear intervencionista "; val },
    tklg7 = { val <- k1258 + k1259 + k1260;  attr(val, "label") <- " Otros "; val },
    ttrafis = { val <- k1348 + k1351 + k1354 + k1357 + k1360 + k1363 + k1363a + k1366;  attr(val, "label") <- " Total Tratamientos de Fisioterapia "; val },
    ttdqo = { val <- k1376a + k1376b + k1376bb + k1376c + k1376d + k1376e;  attr(val, "label") <- " Total Tratamientos de Diálisis, Quimioterapia y Otros "; val },
    tconsul = { val <- tcmps+tcpps+tcest;  attr(val, "label") <- " Total Consultas "; val },
    lab2 = { val <- k156 + k161 + k166;  attr(val, "label") <- " Laboratorio "; val },
    tmed = { val <-k6+k11+k16+k16a+k16b+k16c+k16d+k16e+k16f+k191d+k41+k21+k26+k31+k36+k46+k51+k56+k61+k66+k71+k76+k81+k86+k91+k96+k101+k106+k111+k116+k121+k126+k131+k136+k141+k146+k151+k156+k171+k191+k191a+k191b+k191c+k191e+k191f+k191g+k191h+k191i+k191j+k191k+k191l+k191m+k191n+k191o+k191p+k191q+k191r+k191s+k191t+k191u+k191w+k191x+k191y+k191z+k191aa+k191cc+k191dd+k191ee;  attr(val, "label") <- " Total médicos generales y por especialidad"; val },
    kfar1 = { val <- as.numeric(if_else(kfar == 1, 1, 0));  attr(val, "label") <- " Farmacia "; val },
    kbotq1 = { val <- as.numeric(if_else(kbotq == 1, 1, 0));  attr(val, "label") <- " Botiquín "; val },
    labcl = { val <- as.numeric(if_else(klcl == 1, 1, 0));  attr(val, "label") <- " Laboratorio Clínico "; val },
    labhs = { val <- as.numeric(if_else(klhs == 1, 1, 0));  attr(val, "label") <- " Laboratorio Hispatológico "; val },
    labot = { val <- as.numeric(if_else(kotl == 1, 1, 0));  attr(val, "label") <- " Otros Laboratorios "; val },
    labhs = { val <- as.numeric(if_else(klhs == 1, 1, 0));  attr(val, "label") <- " Laboratorio Hispatológico "; val },
    tpc = { val <- tn+ta+tad+tm+tm1+tprv31+tedad;  attr(val, "label") <- " Consultas Primarias "; val },
    tpartom = { val <- k707+k708;  attr(val, "label") <- " Parto(Atención de partos) 10 - 19 años "; val },
    tpartoh = { val <- k716+k717;  attr(val, "label") <- " Parto(Atención de partos) 20 - 50 años "; val },
    tm = { val <- tprv10+tprv11;  attr(val, "label") <- " Mujeres 10 - 19 años "; val },
    tm1 = { val <- tprv12+tprv13;  attr(val, "label") <- " Mujeres 20 - 49 años "; val },
    totalpar1 = { val <- tm+tpartom;  attr(val, "label") <- " Mujeres 10 - 19 años "; val },
    totalpar2 = { val <- tm1+tpartoh;  attr(val, "label") <- " Mujeres 20 - 99 años "; val }
        )





orden <- c("Total Nacional", "Total Región Sierra",	"Azuay", "Bolívar", "Cañar", "Carchi", "Cotopaxi", "Chimborazo", "Imbabura", "Loja", "Pichincha", "Tungurahua", "Santo Domingo de los Tsáchilas", "Total Región Costa", "El Oro", "Esmeraldas", "Guayas", "Los Ríos", "Manabí", "Santa Elena", "Total Región Amazónica", "Morona Santiago", "Napo", "Pastaza", "Zamora Chinchipe", "Sucumbíos", "Orellana", "Total Región Insular", "Galápagos")

proyección <- c(  17614.396,  7701.333,  825.773,  206.608,  237.790,  182.445,  475.870,  495.781,  482.224,  496.526,  3217.582,  571.693,  509.041,  8937.687,  738.399,  593.324,  4601.037,  948.792,  1659.426,  396.709,  946.228,  196.157, 132.987, 112.771, 113.912, 207.728, 182.673, 29.148, 29.148)
                  
orden2 <- c("Total Nacional",	"Total Nacional Urbano",	"Total Nacional Rural",	"Total Región Sierra",	"Total Región Sierra Urbano",	"Total Región Sierra Rural",	"Azuay",	"Azuay Urbano",	"Azuay Rural",	"Bolívar",	"Bolívar Urbano",	"Bolívar Rural",	"Cañar",	"Cañar Urbano",	"Cañar Rural",	"Carchi",	"Carchi Urbano",	"Carchi Rural",	"Cotopaxi",	"Cotopaxi Urbano",	"Cotopaxi Rural",	"Chimborazo",	"Chimborazo Urbano",	"Chimborazo Rural",	"Imbabura",	"Imbabura Urbano",	"Imbabura Rural",	"Loja",	"Loja Urbano",	"Loja Rural",	"Pichincha",	"Pichincha Urbano",	"Pichincha Rural",	"Tungurahua",	"Tungurahua Urbano",	"Tungurahua Rural",	"Santo Domingo de los Tsáchilas",	"Santo Domingo de los Tsáchilas Urbano",	"Santo Domingo de los Tsáchilas Rural",	"Total Región Costa",	"Total Región Costa Urbano",	"Total Región Costa Rural",	"El Oro",	"El Oro Urbano",	"El Oro Rural",	"Esmeraldas",	"Esmeraldas Urbano",	"Esmeraldas Rural",	"Guayas",	"Guayas Urbano",	"Guayas Rural",	"Los Ríos",	"Los Ríos Urbano",	"Los Ríos Rural",	"Manabí",	"Manabí Urbano",	"Manabí Rural",	"Santa Elena",	"Santa Elena Urbano",	"Santa Elena Rural",	"Total Región Amazónica",	"Total Región Amazónica Urbano",	"Total Región Amazónica Rural",	"Morona Santiago",	"Morona Santiago Urbano",	"Morona Santiago Rural",	"Napo",	"Napo Urbano",	"Napo Rural",	"Pastaza",	"Pastaza Urbano",	"Pastaza Rural",	"Zamora Chinchipe",	"Zamora Chinchipe Urbano",	"Zamora Chinchipe Rural",	"Sucumbíos",	"Sucumbíos Urbano",	"Sucumbíos Rural", "Orellana",	"Orellana Urbano",	"Orellana Rural",	"Total Región Insular",	"Total Región Insular Urbano",	"Total Región Insular Rural",	"Galápagos",	"Galápagos Urbano",	"Galápagos Rural")                                   
                
# ****************************************************************************************************************  

#FUNCIONES####

procesar_totales_multivariable <- function(df, agrupador, variables, nombre_seguro) {
  # 1. Agrupamos y sumamos las variables por regiones
  serie <- df %>%
    select(all_of(c(agrupador, variables))) %>%
    group_by(across(all_of(agrupador))) %>%
    summarise(across(all_of(variables), ~ sum(.x, na.rm = TRUE)), .groups = "drop")
  
  # 2. Total general (suma de todos los registros en el df original)
  total_general <- df %>%
    summarise(across(all_of(variables), ~ sum(.x, na.rm = TRUE), .names = "total_{col}"), .groups = "drop")
  
  # 3. Crear fila de totales regionales
  fila_total_region <- serie %>% 
    mutate (!!sym(agrupador) := paste("Total Región", unique(df[[agrupador]])))  # Asegúrate de usar los valores únicos como base
  prov_ubi = paste("Total Región", unique(df[[agrupador]]))
  
  for (var in variables) {
    fila_total_region[[var]] <- total_general[[var]]
  }
  
  # 4. Crear fila de total nacional
  fila_total_nacional <- tibble(
    !!sym(agrupador) := "Total Nacional",
    prov_ubi = "Total"
  )
  
  for (var in variables) {
    fila_total_nacional[[var]] <- sum(df[[var]], na.rm = TRUE)
  }
  
  # 5. Unión de todos
  resultado <- bind_rows(serie, fila_total_region, fila_total_nacional)
  
  # 6. Ordenar por agrupador
  resultado <- resultado %>%
    arrange(!!sym(agrupador))
  
  resultado <- resultado %>% 
    select(region, prov_ubi,everything()) %>% 
    mutate(prov_ubi = if_else(!!sym(agrupador) == "Región Sierra","Total Región Sierra","")) %>% 
    mutate(prov_ubi = if_else(!!sym(agrupador) == "Región Costa","Total Región Costa",prov_ubi)) %>% 
    mutate(prov_ubi = if_else(!!sym(agrupador) == "Región Amazónica","Total Región Amazónica",prov_ubi)) %>% 
    mutate(prov_ubi = if_else(!!sym(agrupador) == "Región Insular","Total Región Insular",prov_ubi)) %>% 
    mutate(prov_ubi = if_else(!!sym(agrupador) == "Total Nacional","Total Nacional",prov_ubi))
  
    resultado <- resultado %>%
    filter(if_all(everything(), ~ !is.na(.)))
  
  return(resultado)
}

procesar_series <- function(df, columna_parametro, nombre_tabla1) {
  
  .serie_in <- df %>%
    select(region, prov_ubi, !!sym(columna_parametro)) %>%
    group_by(region, prov_ubi) %>%
    summarise(Tot_Indicador = sum(!!sym(columna_parametro), na.rm = TRUE), .groups = 'drop') 
  
 .serie_2.1 <- .serie_in %>%
    group_by(region) %>%
    summarise(Tot_Indicador = sum(Tot_Indicador, na.rm = TRUE)) %>%
    mutate(prov_ubi = "Total") %>%
    mutate(prov_ubi = paste(prov_ubi,region)) %>%
    select(region, prov_ubi, Tot_Indicador)
  
  .total_nacional <- .serie_in %>%
    summarise(region = "Nacional",
              prov_ubi = "Total Nacional",
              Tot_Indicador = sum(Tot_Indicador, na.rm = TRUE)) %>%
    select(region, prov_ubi, Tot_Indicador)
  
  .serie_2.11 <- bind_rows(.serie_2.1, .serie_in, .total_nacional) 
  
  .serie_2.11$prov_ubi <- factor(.serie_2.11$prov_ubi, levels = orden)
  .serie_2.11 <- .serie_2.11 %>%
    arrange(prov_ubi)
  
  if (nrow(.serie_2.11) == length(proyección)) {
    .serie_2.11 <- cbind(.serie_2.11, Proyecciones = proyección)%>%
      mutate(Tasa = round((Tot_Indicador / Proyecciones) * 10.000, 1)) # Cambia 'nombre_tabla' por 'tmedicos' si es necesario
  } else {
    warning("La longitud de proyecciones no coincide con la cantidad de filas en serie_final.")
  }
  
  .serie_2.11 <- .serie_2.11 %>% 
    select(2,4,3,5)
  
  colnames(.serie_2.11)[3] <- nombre_tabla1
  
  return(.serie_2.11)
}



procesar_gráfico <- function(df, valor_estcsi, columna_nombre) {
  
  .graf_inter <- df %>%
    filter(estcsi == valor_estcsi) %>%
    group_by(sector1, clase, estcsi) %>%
    summarise(cantidad = n(), .groups='drop') %>%
    pivot_wider(names_from=estcsi, values_from=cantidad, values_fill=0) 
  
  .totales_sector <- .graf_inter %>%
    group_by(sector1) %>%
    summarise(across(where(is.numeric), sum)) %>%
    mutate(clase = 'Total Sector') %>% 
    select(1,3,2) 
  
  .graf_inter <- bind_rows(.totales_sector, .graf_inter) %>% 
    arrange(sector1)
  
  .totales_graf_inter <- .totales_sector %>%
    summarise(across(where(is.numeric), sum), .groups='drop') %>%
    mutate(sector1 = "Total Nacional") %>%
    mutate(clase = 'Total Nacional')  %>% 
    select(2,3,1)
  
  .resultadog <- bind_rows(.totales_graf_inter, .totales_sector)
  
  cantidad <- .resultadog[[columna_nombre]]
  cantidad2 <- .resultadog[[columna_nombre]][1]
  
  .resultadog <- .resultadog %>%
    mutate(porcentaje = scales::percent((cantidad / cantidad2)))
  
    fil0 <- nrow(.graf_inter)
  
    condi <- (.graf_inter$clase=="Total Sector" & .graf_inter$sector1=="Sector Privado" ) 
  
    fil1<- which(condi)
  
    cantidad0 <- .graf_inter[[columna_nombre]][1:fil1 - 1]
    cantidad1 <- .graf_inter[[columna_nombre]][fil1:fil0]
  
    cantidad2_val <- .graf_inter[[columna_nombre]][1]
    cantidad3 <- .graf_inter[[columna_nombre]][fil1]
  
    cantidad4 <- (cantidad0 / cantidad2_val)
    cantidad5 <- (cantidad1 / cantidad3)
  
  .graf_inter <- .graf_inter %>%
    mutate(porcentaje = 0)
  
  .graf_inter$porcentaje[1:fil1-1] <- cantidad4   
  .graf_inter$porcentaje[fil1:fil0] <- cantidad5
  
  .graf_inter <- .graf_inter %>%
    mutate(porcentaje = round(porcentaje, digits = 2)) %>% 
    mutate(porcentaje = scales::percent(porcentaje))

  .gráfico_final  <- bind_rows(.resultadog, .graf_inter)
  
  return(.gráfico_final)

}

cuagen_flexible <- function(df, variable) {
 
  var <- enquo(variable)
  
  .cuagen <- df %>%
    select(region, prov_ubi, !!var) %>%
    group_by(region, prov_ubi, !!var) %>%
    summarise(conteo = n(), .groups = 'drop') %>%
    pivot_wider(
      names_from = !!var,
      values_from = conteo,
      values_fill = list(conteo = 0)
    )
  
  .datos_seleccionados <- .cuagen[, c(3, 4, 5)]
  
  .cuagen <- .cuagen %>%
    mutate(Total_Nacional = rowSums(.datos_seleccionados, na.rm = TRUE))
  
  .cuagen <- .cuagen %>%
    select(1, 2, Total_Nacional, everything())
  
  return(.cuagen)
}

cuag_sector_estcsi <- function(df, categoria_estcsi) {

  .df_filtrado <- df %>% filter(estcsi == categoria_estcsi)

  .cua_3 <- .df_filtrado %>%
    select(region, prov_ubi, sector) %>%
    group_by(region, prov_ubi, sector) %>%
    summarise(conteo = n(), .groups = 'drop') %>%
    pivot_wider(
      names_from = sector,
      values_from = conteo,
      values_fill = list(conteo = 0)
    )
  
  .columnas_sector <- setdiff(names(.cua_3), c("region", "prov_ubi"))
  
  .cua_3 <- .cua_3 %>%
    mutate(Total_Nacional = rowSums(across(all_of(.columnas_sector)), na.rm = TRUE))
  
  .cua_3 <- .cua_3 %>%
    select(1, 2, Total_Nacional, everything())
  
  return(.cua_3)
}


cuadros_ser3 <- function() {
  
  .res1 <- cuagen_flexible(df, sector)
  
  .resul_res1 <- procesar_totales_multivariable(
    df = .res1,
    agrupador = "region",   
    variables = c("Total_Nacional", "Sector público", "Privados con fines de lucro", "Privados sin fines de lucro"), 
    nombre_seguro = "region"  
  )
  
  .rest1  <- bind_rows(.resul_res1, .res1)
  
  .res2 <- cuag_sector_estcsi(df, "Con Internación")
  
  .resul_res2 <- procesar_totales_multivariable(
    df = .res2,
    agrupador = "region", 
    variables = c("Total_Nacional", "Sector público", "Privados con fines de lucro", "Privados sin fines de lucro"), 
    nombre_seguro = "region"  
  )
  
  .rest2 <- bind_rows(.resul_res2, .res2)
  .rest2 <- .rest2 %>%
    rename_with(
      ~ ifelse(. %in% c("region", "prov_ubi"), ., paste0("Con Internación ",.))
    )
  
  .res3 <- cuag_sector_estcsi(df, "Sin Internación")
  
  .resul_res3 <- procesar_totales_multivariable(
    df = .res3,
    agrupador = "region",  
    variables = c("Total_Nacional", "Sector público", "Privados con fines de lucro", "Privados sin fines de lucro"), 
    nombre_seguro = "region"  
  )
  
  .rest3  <- bind_rows(.resul_res3, .res3)
  .rest3 <- .rest3 %>%
    rename_with(
      ~ ifelse(. %in% c("region", "prov_ubi"), ., paste0("Sin Internación ",.))
    )

  .resultado_final <- .rest1 %>%
    full_join(.rest2, by = c("region", "prov_ubi")) %>%
    full_join(.rest3, by = c("region", "prov_ubi"))
              
    .resultado_final$prov_ubi <- factor(.resultado_final$prov_ubi, levels = orden)
  
  .resultado_final_ordenado <- .resultado_final %>%
    arrange(prov_ubi)
  
  return(.resultado_final_ordenado)
}


sumar_por_region_y_prov <- function(df, region, prov_ubi, ...) {

    parametros_adicionales <- list(...)
    
    if(length(parametros_adicionales) == 0) {
      stop("Debe ingresar al menos un parámetro adicional para sumar.")
    }
    
     columnas_seleccionadas <- c("region", "prov_ubi", unlist(parametros_adicionales))
    
    if(!all(columnas_seleccionadas %in% names(df))) {
      stop("Una o más columnas especificadas no existen en el dataframe.")
    }
    
    .resultadorp <- df %>%
      group_by(region, prov_ubi) %>%
      summarise(across(all_of(unlist(parametros_adicionales)), sum, na.rm = TRUE))
    
    .columnas_total <- setdiff(names(.resultadorp), c("region", "prov_ubi"))
    
    .resultadorp <- .resultadorp %>%
      mutate(Total_Nacional = rowSums(across(all_of(.columnas_total)), na.rm = TRUE))
    
    .resultadorp <- .resultadorp %>%
      select(1, 2, Total_Nacional, everything())
    
    return(.resultadorp)
  }
  
  cuadros_312 <- function() {
    
  .resultado312 <- sumar_por_region_y_prov(
    df,
    region = "region",
    prov_ubi = "prov_ubi",
    "tmedicos",
    "todont",
    "tpsic",
    "tenf",
    "tobst",
    "tauxenf"
  )

  .resul_312 <- procesar_totales_multivariable(
    df = .resultado312,
    agrupador = "region",   # La columna en comillas
    variables = c("Total_Nacional", "tmedicos", "todont", "tpsic", "tenf", "tobst", "tauxenf"), # Lista de columnas a sumar
    nombre_seguro = "region"  # Texto adicional (puedes dejar vacío)
  )

  .result_312 <- bind_rows(.resul_312, .resultado312)
  
  .result_312$prov_ubi <- factor(.result_312$prov_ubi, levels = orden)
  
  # Ordenar el data frame por esa columna
  .resultado_final_ordenado312 <- .result_312 %>%
    arrange(prov_ubi)
  
  .res312fin <- cbind(.resultado_final_ordenado312, Proyecciones = proyección)  %>% 
    select(1,2,10,4,5,6,7,8,9)%>% 
       mutate( Tasa_Médicos = round((tmedicos / Proyecciones) * 10.000, 2),
               Tasa_Odontólogos = round((todont / Proyecciones) * 10.000, 2),  
               Tasa_Psicólogos = round((tpsic / Proyecciones) * 10.000, 2),  
               Tasa_Enfermeras = round((tenf / Proyecciones) * 10.000, 2), 
               Tasa_Obstetras = round((tobst / Proyecciones) * 10.000, 2), 
               Tasa_Auxiliares_Enfermería = round((tauxenf / Proyecciones) * 10.000, 2)
    )
  
    .res312fin <- .res312fin %>%
    rename(
      Médicos = tmedicos,
      Odontólogos = todont,
      Psicólogos = tpsic,
      Enfermeras = tenf,
      Obstetras = tobst,
      Auxiliares_Enfermería = tauxenf
    ) %>% 
      select(1,2,3,4,10,5,11,6,12,7,13,8,14,9,15)
  
  return(.res312fin)
  
  }

    cuadros_313parm <- function(df, cols_sumar, nombres_renombrados, orden, orden2) {
    
    .resultado313 <- list(
      df = df,
      region = "region",
      prov_ubi = "prov_ubi"
    )
    .args_sumar <- c(.resultado313, as.list(cols_sumar))
    
    .resultado313 <- do.call(sumar_por_region_y_prov, .args_sumar)
    
    # Paso 2: procesamiento de totales
    .resultado313t <- procesar_totales_multivariable(
      df = .resultado313,
      agrupador = "region",
      variables = c("Total_Nacional", cols_sumar),
      nombre_seguro = "region"
    )
    
    .result_313 <- bind_rows(.resultado313t, .resultado313)
    
    .result_313$prov_ubi <- factor(.result_313$prov_ubi, levels = orden)
    
    # Ordenar el data frame por esa columna
    .resultado_final_ordenado313 <- .result_313 %>%
      arrange(prov_ubi) %>% 
      select(everything(), -Total_Nacional) 
    
      .urb_rur <- df %>% 
      select(region, prov_ubi, all_of(cols_sumar), area) %>% 
      group_by(region, prov_ubi, area) %>% 
      summarise(across(all_of(cols_sumar), ~ sum(.x, na.rm = TRUE)), .groups = "drop") %>%
      mutate(prov_ubi = paste(prov_ubi, area, sep = " ")) %>% 
      select(region, prov_ubi, everything(), -area)
    
    # Calcular totales por región y área
    .urb_rur2 <- df %>%
      select(region, all_of(cols_sumar), area) %>%
      group_by(region, area) %>%
      summarise(across(all_of(cols_sumar), ~ sum(.x, na.rm = TRUE)), .groups = "drop") %>%
      mutate(prov_ubi = paste("Total", region, area, sep = " ")) %>%
      select(region, prov_ubi, everything(), -area) %>%
      bind_rows(
        df %>%
          group_by(area) %>%
          summarise(across(all_of(cols_sumar), ~ sum(.x, na.rm = TRUE)), .groups = "drop") %>%
          mutate(region = "Total Nacional", prov_ubi = paste("Total Nacional", area, sep = " ")) %>%
          select(region, prov_ubi, everything())
      )
    
   .turbrur <- bind_rows(.urb_rur2, .urb_rur) %>% 
      select(everything(), -area)
    
    .total_urbrur <- bind_rows(.resultado_final_ordenado313, .turbrur)
    
    .total_urbrur <- .total_urbrur %>%
      mutate(prov_ubi = factor(prov_ubi, levels = orden2)) %>%
      arrange(prov_ubi)  
    
    
    .total_urbrur <- .total_urbrur %>%
      mutate(prov_ubi = factor(prov_ubi, levels = orden2)) %>%
      arrange(prov_ubi)
    
    # Verifica qué columnas existen y cuáles intentamos renombrar}
    colnames(.total_urbrur) <- nombres_renombrados
    
      return(.total_urbrur)
  }
  
  
    transform_indicadores_wide <- function(df_sum, indicators) {
      
            # 2) Asegurar que sean numéricos (si ya lo son, este paso no cambia)
      df[indicators] <- lapply(df[indicators], as.numeric)
      
      # 3) Sumar por sector y entidad para cada indicador
      .df_sum <- df %>%
        group_by(sector, entidad) %>%
        summarize(across(all_of(indicators), sum, na.rm = TRUE), .groups = "drop")
      # Paso 0: asegurar que los indicadores sean numéricos
      .df_sum <- .df_sum %>% mutate(across(all_of(indicators), as.numeric))
      
      # Paso 1: Transformar a formato largo y luego ancho por indicador
      .df_final <- .df_sum %>%
        pivot_longer(
          cols = all_of(indicators),
          names_to = "indicador",
          values_to = "valor"
        ) %>%
        unite("secc_ent", sector, entidad, sep = "_") %>%
        pivot_wider(
          id_cols = indicador,
          names_from = secc_ent,
          values_from = valor
        )
      
      # Paso 2: Calcular totales por grupo/sector
      # Nota: ajusta los prefijos exactos de tus columnas si difieren
      .df_final <- .df_final %>%
        mutate(
          Total_Públicos = rowSums(select(., starts_with("Sector público")), na.rm = TRUE),
          Total_Privados_con_fines_de_lucro = rowSums(select(., starts_with("Privados con")), na.rm = TRUE),
          Total_Privados_sin_fines_de_lucro = rowSums(select(.,starts_with("Privados sin")), na.rm = TRUE))
      
      .df_final <- .df_final %>%
        mutate(
                   Total_Sector = rowSums(select(., starts_with("Total")), na.rm = TRUE)
        )
      
      return(.df_final)
    }
    

    cuadros_sec_ent <- function(data, vars_to_sum) {
      # 1) Suma por región, provincia y combinación (sector, entidad) para las variables especificadas
     .df_sum <- data %>%
        group_by(region, prov_ubi, sector, entidad) %>%
        summarise(across(all_of(vars_to_sum), ~sum(.x, na.rm = TRUE), .names = "sum_{col}"), .groups = "drop")
      
      # 2) Crear clave para columnas y convertir a formato ancho
      # Unión de sector_entidad para crear columnas
      .df_wide <- .df_sum %>%
        unite("key", sector, entidad, sep = "_") %>%
        pivot_wider(names_from = key, values_from = starts_with("sum_"), values_fill = 0)
      
      # 3) Orden y totales intermedios (según tu flujo)
      .df_wide <- .df_wide %>%
        arrange(region, prov_ubi) %>%
        mutate(Total_Público = rowSums(select(., starts_with("Sector Público")), na.rm = TRUE)) %>% 
        mutate(Total_privado_con_fines_de_lucro = rowSums(select(., starts_with("Privados con")), na.rm = TRUE)) %>% 
        mutate(Total_privado_sin_fines_de_lucro = rowSums(select(., starts_with("Privados sin")), na.rm = TRUE))
      
      # 4) Total nacional (acumulado)
      .total_nacional <- .df_wide %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(region = "Nacional",
               prov_ubi = "Total Nacional") %>%
        select(region, prov_ubi, everything())
      
      .totales_region_filas <- .df_wide %>%
        group_by(region) %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(prov_ubi = paste0("Total ", region)) %>%  # concatenar "Total" con la región
        select(region, prov_ubi, everything()) %>%
        ungroup()
      
      # 5) Unir totales con la tabla original
      .final_con_total_region <- bind_rows(.df_wide, .totales_region_filas, .total_nacional)
      
      .final_con_total_region$prov_ubi <- factor(.final_con_total_region$prov_ubi, levels = orden) 
      
       .resultado_final_ordenado <- .final_con_total_region %>%
        arrange(prov_ubi) %>% 
        select(2, 21, 3, 4, 5, 6, 7, 8, 9,  10, 22, 11, 23, 12, 19, 20, 13, 14)
      
    .resultado_final_ordenado <- .resultado_final_ordenado %>%
      arrange(prov_ubi)
    
    return(.resultado_final_ordenado)
    }
    
     cuadros_sector <- function(data, vars_to_sum) {
      
      .df_sum <- data %>%
        group_by(region, prov_ubi, sector) %>%
        summarise(across(all_of(vars_to_sum), ~sum(.x, na.rm = TRUE), .names = "sum_{col}"), .groups = "drop")
      
      .df_wide <- .df_sum %>%
        unite("key", sector, sep = "_") %>%
        pivot_wider(names_from = key, values_from = starts_with("sum_"), values_fill = 0)
      
      .df_wide <- .df_wide %>%
        arrange(region, prov_ubi) %>%
        mutate(total = rowSums(select(., where(is.numeric) ), na.rm = TRUE))
      
      .total_nacional <- .df_wide %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(region = "Nacional",
               prov_ubi = "Total Nacional") %>%
        select(region, prov_ubi, everything())
      
      .totales_region_filas <- .df_wide %>%
        group_by(region) %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(prov_ubi = paste0("Total ", region)) %>%  # concatenar "Total" con la región
        select(region, prov_ubi, everything()) %>%
        ungroup()
      
      .final_con_total_region <- bind_rows(.df_wide, .totales_region_filas, .total_nacional)
      
      if (!is.null(orden)) {
      .final_con_total_region$prov_ubi <- factor(.final_con_total_region$prov_ubi, levels = orden) 
      }
      
      .resultado_final_ordenado <- .final_con_total_region %>%
        arrange(prov_ubi)
      .resultado_final_ordenado <-.resultado_final_ordenado 
      
      return(.resultado_final_ordenado)
    }
    
   
    cuadros_sec_clase <- function(data, vars_to_sum) {
      # 1) Suma por región, provincia y combinación (sector, entidad) para las variables especificadas
      .df_sum <- data %>%
        group_by(region, prov_ubi, sector, clase) %>%
        summarise(across(all_of(vars_to_sum), ~sum(.x, na.rm = TRUE), .names = "sum_{col}"), .groups = "drop")
      
      # 2) Crear clave para columnas y convertir a formato ancho
      # Unión de sector_entidad para crear columnas
      .df_wide <- .df_sum %>%
        unite("key", sector, clase, sep = "_") %>%
        pivot_wider(names_from = key, values_from = starts_with("sum_"), values_fill = 0)
      
      # 3) Orden y totales intermedios (según tu flujo)
      .df_wide <- .df_wide %>%
        arrange(region, prov_ubi) %>%
        mutate(Total_Público = rowSums(select(., starts_with("Sector público")), na.rm = TRUE)) %>% 
        mutate(Total_privado_con_fines_de_lucro = rowSums(select(., starts_with("Privados con")), na.rm = TRUE)) %>% 
        mutate(Total_privado_sin_fines_de_lucro = rowSums(select(., starts_with("Privados sin")), na.rm = TRUE))
      
      # 4) Total nacional (acumulado)
      .total_nacional <- .df_wide %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(region = "Nacional",
               prov_ubi = "Total Nacional") %>%
        select(region, prov_ubi, everything())
      
      .totales_region_filas <- .df_wide %>%
        group_by(region) %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(prov_ubi = paste0("Total ", region)) %>%  # concatenar "Total" con la región
        select(region, prov_ubi, everything()) %>%
        ungroup()
      
      # 5) Unir totales con la tabla original
      .final_con_total_region <- bind_rows(.df_wide, .totales_region_filas, .total_nacional)
      
      .final_con_total_region$prov_ubi <- factor(.final_con_total_region$prov_ubi, levels = orden) 
      .resultado_final_ordenado <- .final_con_total_region %>%
        arrange(prov_ubi)     
      .resultado_final_ordenado <- .final_con_total_region %>%
        arrange(prov_ubi)
   
     .mi_tabla_filtrada <- .resultado_final_ordenado %>%
        select(where(~ any(. != 0)))
      
      return(.mi_tabla_filtrada)
    }
    
 cuadro3129 <- function(df, columnas_k) {
      
      # 1. Resumir los datos por sector y entidad
      .tabla_resumen <- df %>%
        select(sector, entidad, all_of(columnas_k)) %>% # Usa all_of() para seleccionar columnas desde un vector
        group_by(sector, entidad) %>%
        summarise(
          across(all_of(columnas_k), sum, na.rm = TRUE),
          .groups = 'drop'
        )
      
      # 2. Crear los data frames de totales
      .total_nacional <- .tabla_resumen %>%
        summarise(
          sector = "Total",
          entidad = "Total nacional",
          across(starts_with("k"), sum, na.rm = TRUE)
        )
      
      .total_publico <- .tabla_resumen %>%
        filter(sector == "Sector público") %>%
        summarise(
          sector = "Total",
          entidad = "Total públicos",
          across(starts_with("k"), sum, na.rm = TRUE)
        )
      
      .total_privado_lucro <- .tabla_resumen %>%
        filter(sector == "Privados con fines de lucro") %>%
        summarise(
          sector = "Total",
          entidad = "Total Privados con fines de lucro",
          across(starts_with("k"), sum, na.rm = TRUE)
        )
      
      .total_privado_sin_lucro <- .tabla_resumen %>%
        filter(sector == "Privados sin fines de lucro") %>%
        summarise(
          sector = "Total",
          entidad = "Total Privados sin fines de lucro",
          across(starts_with("k"), sum, na.rm = TRUE)
        )
      
      # --- 2. Combinar los data frames ---
      
      # Unir todos los data frames en el orden deseado
      .tabla_final_desordenada <- bind_rows(
        .total_nacional,
        .total_publico,
        .tabla_resumen %>% filter(sector == "Sector público"),
        .total_privado_lucro,
        .tabla_resumen %>% filter(sector == "Privados con fines de lucro"),
        .total_privado_sin_lucro,
        .tabla_resumen %>% filter(sector == "Privados sin fines de lucro")
      )


      return(.tabla_final_desordenada)
    }
   
    cuadros_clase <- function(data, vars_to_sum) {
      
      # 1) Suma por región, provincia y clase para las variables especificadas
      .df_sum <- data %>%
        group_by(region, prov_ubi, clase) %>%
        summarise(across(all_of(vars_to_sum), ~sum(.x, na.rm = TRUE), .names = "sum_{col}"), .groups = "drop")
      
      # 2) Crear clave para columnas y convertir a formato ancho
      .df_wide <- .df_sum %>%
        unite("key", clase, sep = "_") %>% # Elimina 'sector' de la unión
        pivot_wider(names_from = key, values_from = starts_with("sum_"), values_fill = 0)
      
      # 3) Orden y totales intermedios (revisar esta parte, ya que no hay 'sector')
      .df_wide <- .df_wide %>%
        arrange(region, prov_ubi)

      # 4) Total nacional (acumulado)
      .total_nacional <- .df_wide %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(region = "Nacional",
               prov_ubi = "Total Nacional") %>%
        select(region, prov_ubi, everything())
      
      .totales_region_filas <- .df_wide %>%
        group_by(region) %>%
        summarise(across(where(is.numeric), sum, na.rm = TRUE)) %>%
        mutate(prov_ubi = paste0("Total ", region)) %>%
        select(region, prov_ubi, everything()) %>%
        ungroup()
      
      # 5) Unir totales con la tabla original
      .final_con_total_region <- bind_rows(.df_wide, .totales_region_filas, .total_nacional)
      
      .final_con_total_region$prov_ubi <- factor(.final_con_total_region$prov_ubi, levels = orden) 
      
      .resultado_final_ordenado <- .final_con_total_region %>%
        arrange(prov_ubi)
      
      .mi_tabla_filtrada <- .resultado_final_ordenado %>%
        select(where(~ any(. != 0)))
      
      return(.mi_tabla_filtrada)
    }
    
    
    cuadros_314fgen <- function(df,
                                columnas_sumar,    # vector de nombres de columnas a sumar (dinámico)
                                renombrado_alias) { # vector de nuevos nombres para esas columnas (misma longitud)
      
      # Validaciones básicas
      if (is.null(df) || !is.data.frame(df)) {
        stop("df debe ser un data.frame.")
      }
      if (!is.character(columnas_sumar) || length(columnas_sumar) < 1) {
        stop("columnas_sumar debe ser un vector de nombres de columnas (caracteres) de longitud >= 1.")
      }
      if (!is.character(renombrado_alias) || length(renombrado_alias) != length(columnas_sumar)) {
        stop("renombrado_alias debe tener la misma longitud que columnas_sumar.")
      }
      
      # Verificar columnas existentes
      if (!all(columnas_sumar %in% names(df))) {
        stop("Una o más columnas en columnas_sumar no existen en el dataframe.")
      }
      
      .required_cols <- c("region", "prov_ubi", "cant_ubi")
      .missing_required <- setdiff(.required_cols, names(df))
      if (length(.missing_required) > 0) {
        stop("Faltan columnas requeridas en df: ", paste(.missing_required, collapse = ", "))
      }
      
      # Filtrar columnas válidas a sumar
      sum_cols <- columnas_sumar[columnas_sumar %in% names(df)]
      
      # Paso 1: sumar por región, prov_ubi y cant_ubi para las columnas dinámicas
      .resultado316_1 <- df %>%
        group_by(region, prov_ubi, cant_ubi) %>%
        summarise(across(all_of(sum_cols), ~ sum(.x, na.rm = TRUE),
                         .names = "{.col}"), .groups = "drop")
      
      # Renombrado dinámico
      .final_res <- .resultado316_1 %>%
        rename_with(~ renombrado_alias[match(.x, sum_cols)], all_of(sum_cols))
      
      # Paso 3: Total_Nacional por grupo (suma de renombradas)
      if (length(renombrado_alias) > 0) {
        .final_res <- .final_res %>%
          mutate(Total_Nacional = rowSums(across(all_of(renombrado_alias)), na.rm = TRUE))
      } else {
        .final_res <- .final_res %>% mutate(Total_Nacional = NA_real_)
      }
      
      # Opcional: reordenar columnas
      cols_order <- c("region", "prov_ubi", "cant_ubi", renombrado_alias, "Total_Nacional")
      .final_res <- .final_res %>% select(any_of(cols_order))
      
      # Crear fila de totales (TOTAL) al inicio
      if (length(sum_cols) > 0) {
        # Suma global por cada columna renombrada
        .tot_por_col <- .final_res %>%
          filter(region != "TOTAL") %>%  # excluir la fila TOTAL si ya existiera
          summarise(across(all_of(renombrado_alias), ~ sum(.x, na.rm = TRUE)),
                    Total_Nacional = sum(Total_Nacional, na.rm = TRUE))
        
        # Construimos la fila TOTAL con los nombres correctos
        .total_row <- tibble::tibble(
          region = "Total_Nacional",
          prov_ubi = "Total_Nacional",
          cant_ubi = "Total_Nacional"
        )
        
        # Añadir cada columna renombrada con su total correspondiente
        for (i in seq_along(renombrado_alias)) {
          .total_row[[renombrado_alias[i]]] <- .tot_por_col[[renombrado_alias[i]]]
        }
        .total_row$Total_Nacional <- .tot_por_col$Total_Nacional
        
        # Asegurar el orden de columnas acorde a final_res
        .final_res <- bind_rows(.total_row, .final_res)
      }
      
      return(.final_res)
    }
    
    
    cuadros_316gen <- function(df,
                               columnas_sumar,    # vector de columnas a sumar (dinámico)
                               renombrado_alias) { # vector de nuevos nombres para esas columnas
      
      # Validaciones básicas
      if (!is.character(columnas_sumar) || length(columnas_sumar) < 1) {
        stop("columnas_sumar debe ser un vector de nombres de columnas (caracteres) de longitud >= 1.")
      }
      if (!is.character(renombrado_alias) || length(renombrado_alias) != length(columnas_sumar)) {
        stop("renombrado_alias debe tener la misma longitud que columnas_sumar.")
      }
      
      # Paso 1: llamada a sumar_por_region_y_prov (adaptar a tu firma con do.call si es necesario)
      base_args <- list(
        df = df,
        region = "region",
        prov_ubi = "prov_ubi"
      )
      args_sumar <- c(base_args, as.list(columnas_sumar))
      
      .resultado316_1 <- do.call(sumar_por_region_y_prov, args_sumar)
      
      # Paso 2: procesamiento de totales
      .resul_316_1 <- procesar_totales_multivariable(
        df = .resultado316_1,
        agrupador = "region",
        variables = c("Total_Nacional", columnas_sumar),
        nombre_seguro = "region"
      )
      
      .result_3161 <- bind_rows(.resul_316_1, .resultado316_1) %>% 
        select(everything(), - Total_Nacional)
      
      # Aplicar orden si existe en el entorno
      if (exists("orden") && is.character(orden)) {
        .result_3161$prov_ubi <- factor(.result_3161$prov_ubi, levels = orden)
      }
      
      .resultado_final_ordenado3161 <- .result_3161 %>%
        arrange(prov_ubi)
      
      # Renombrado dinámico
      map_rename <- setNames(renombrado_alias, columnas_sumar)
      
      .final_res <- .resultado_final_ordenado3161 %>%
        rename_with(~ map_rename[.x], all_of(columnas_sumar))
      
      
      colnames(.final_res)[2] <- "Regiones / Provincia"
      .final_res <- .final_res %>% 
        select(everything(), -1)
      
      return(.final_res)
    }
    
    ##############################################################################
    
    
    
    
    
    
    